
(function($) {
    $.fn.inputFilter = function(inputFilter) {
        return this.on("input keydown keyup mousedown mouseup select contextmenu drop", function() {
            if (inputFilter(this.value)) {
                this.oldValue = this.value;
                this.oldSelectionStart = this.selectionStart;
                this.oldSelectionEnd = this.selectionEnd;
            } else if (this.hasOwnProperty("oldValue")) {
                this.value = this.oldValue;
                this.setSelectionRange(this.oldSelectionStart, this.oldSelectionEnd);
            }
        });
    };
}(jQuery));


$(document).ready(function() {

    $('.submit-btn').on('click', function () {
        $(this).prop('disabled', true);
    });


    $('#airtime-network').on('change', function(){
        let _this = $(this);
        let icon_url = _this.find(':selected').data('icon-url');
        $('#service-img').attr('src', icon_url);
        let percent = parseInt(_this.find(':selected').data('percent'));
        let text = " Select a network provider.";
        if( percent ){
            text = ' You receive ' + percent +'% charge back for this network.';
        }
        $('.alert-notification').html(`<div class="alert alert-success"><h5><i class="fas fa-info-circle"></i>${text}</h5></div>`);
    });

    $('.airtime-proceed').on('click', function(e){
        e.preventDefault();
        let _btn = $(this);
        $(this).prop('disabled', true);
        let amount = $('#amount').val();
        let network = $('#airtime-network').val();
        let recipent = $('#phone').val();
        let ported = $("input[name='bypass']:checked").val();

        if( amount === '' || amount < 100 ){
            sweet_alert('Error', 'Sorry amount can not be less than N100', 'error');
            _btn.prop('disabled', false);
            return false;
        }

        if( recipent === '' ){
            sweet_alert('Error', 'Please fill in the phone number', 'error');
            _btn.prop('disabled', false);
            return false;
        }
        if( network === '' ){
            sweet_alert('Error', 'You need to select a network', 'error');
            _btn.prop('disabled', false);
            return false;
        }
        swal({
            title :'Confirm?',
            text : 'Please press "Ok" to confirm that your data are correct.',
            icon: 'warning',
            buttons : true,
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url : base_url + 'ajax/buy_airtime/',
                    method: "POST",
                    cache : false,
                    data: {amount, network, recipent, ported},
                    success : function(response){
                        if( response.status === 'success' ){
                            sweet_alert('Success', response.message, 'success', false);
                            $('.swal-button--confirm').on('click', function () {
                                window.location = window.location.href;
                            })
                        }else{
                            sweet_alert('Error', response.message, 'error', false);
                            _btn.prop('disabled', false);
                        }
                    },
                    error : function(response){
                        sweet_alert('Error', 'There was an error with the transaction, please contact us if debited', 'error');
                        _btn.prop('disabled', false);
                        console.log( response );
                    }
                });
            }
        });
    });

    $('.tv-options').on('change', function(){
        let network = $(this).val();
        $('.data-body').empty();
        $('.verify-tv').css({display: "flex"}).prop('disabled', true)
        $('#customer_name').val('');
        $('#content').css({display: "none"});
        $('.data-body').html("<h4>Loading Bouquet Plans, please wait.</h4>");
        if( network ){
            let data_list ='';
            $.get( `${base_url}/ajax/fetch_bouquets`, { network } )
                .done(function( response ) {
                    $('.verify-tv').prop('disabled', false)
                    if( response.status !== 'success'){
                        alert('Bouquets not fetched, please try again later.');
                        return;
                    }
                    $('.data-body').html('');
                    $.each(response.message, function ( key, value ) {
                        data_list += `<tr><td align="center"><input type="radio" name="plan" value="${value.id}" required></td><td>${value.name} </td><td>${format_currency(value.amount)}</td></tr>`
                    });
                    $('.data-body').append(data_list);
                });
        }
    });

    $('.verify-tv').on('click', function(){
        $(this).prop("disabled", true).text("Verifying...")
        $.get( `${base_url}/ajax/verify_tv`, $('#tv-form').serialize() )
            .done(function( response ) {
                if( response.status !== 'success'){
                    sweet_alert("Oops",response.message);
                    $(this).prop("disabled", false).text("Verify")
                    return;
                }
                sweet_alert("Success", "Verification successful.", 'success');
                $('#customer_name').val(response.message);
                $('#content').css({display: 'block'})
                $('.verify-tv').css({display: 'none'})
            });
    });

    $('#data-network').on('change', function () {
        $('.data-btn').removeClass('proceed-btn');
        $('.data-btn').prop('disabled', true);
        let _this = $(this);
        let _data_notif = $('.data-notification');
        let icon_url = _this.find(':selected').data('icon-url');

        let service_message = _this.find(':selected').data('validity');
        $('#service-img').attr('src', icon_url);
        $('.data-body').empty();

        let sid = _this.val();
        if( sid !== '' ){
            let data_list = ``;
            setTimeout(function () {
                $.get( `${base_url}/ajax/fetch_plans`, { "service_id": sid } )
                    .done(function( response ) {
                        _data_notif.html('');
                        $.each(response.message, function ( key, value ) {
                            data_list += `<tr><td align="center"><input title="Select ${value.name} for ${format_currency(value.amount)}" type="radio" name="plan" value="${value.id}" required></td><td>${value.name}</td><td>${format_currency(value.amount)}</td></tr>`
                        });
                        $('.data-body').append(data_list);
                    });
            }, 500);
            $('.data-btn').prop('disabled', false);
            $('.data-btn').addClass('proceed-btn');
            $('#inner-div').css('display', 'block');
        }else{
            $('#inner-div').css('display', 'none');
            _data_notif.html(`<div class="alert alert-success"><h5><i class="fas fa-info"></i> Please select data network before proceeding...</h5></div>`);
        }
    });

    $('.proceed-btn').on('click', function(e){
        e.preventDefault();
        $(this).prop('disabled', true);
        let _btn = $(this);
        let plan_id = $("input[name='plan']:checked").val();
        let network = $('#data-network').val();
        let recipent = $('#phone').val();
        let frequency = $('#frequency').val();
        let ported = $("input[name='bypass']:checked").val();

        if( recipent === '') {
            _btn.prop('disabled', false);
            sweet_alert('Error', 'Number field can not be empty', 'error');
            return false;
        }
        if( plan_id === ''){
            _btn.prop('disabled', false);
            sweet_alert('Error', 'Please select a data plan', 'error');
            return false;
        }
        swal({
            title :'Confirm?',
            text : 'Please press "Ok" to confirm that your data are correct.',
            icon: 'warning',
            buttons : true,
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url : base_url + 'ajax/data_purchase/',
                    method: "POST",
                    cache: false,
                    data: {network,plan_id, recipent, frequency, ported},
                    success : function(response){
                        if( response.status === 'success' ){
                            sweet_alert('Success', response.message, 'success', false);
                            $('.swal-button--confirm').on('click', function () {
                                window.location = window.location.href;
                            })
                        }else{
                            sweet_alert('Error', response.message, 'error', false);
                            _btn.prop('disabled', false);
                        }
                    }
                });
            }
            $(this).prop('disabled', false);
        });

    });

    $('#electricity-network').on('change', function () {
        let _this = $(this);
        let icon_url = _this.find(':selected').data('icon-url');
        $('#service-img').attr('src', icon_url);
        $('#endpoint_id').val( _this.data('endpoint'));
        $('#validate_id').val( _this.data('validate'));
        $('.verify-notification').css('display', 'none');
    });

    $('.verify-electricity').on('click', function () {
        let number = $('#number').val();
        let verify_notif = $('.verify-notification');
        if( number !== '' ){
            setTimeout(function () {
                verify_notif.html(`<div class="alert alert-success"><h5><i class="fas fa-spin fa-spinner"></i> Please wait... Verifying your Meter number.</h5></div>`);

                $('.verify-electricity , .verify-notification').css('display', 'none');
                $('#electricity_form').submit();
            }, 2000);
        }else{
            verify_notif.html(`<div class="alert alert-danger"><h5><i class="fas fa-info"></i> Please enter valid meter number.</h5></div>`);
            $('#number').focus();
        }
    });

    $('#tv-network').on('change', function () {
        let _this = $(this);
        let icon_url = _this.find(':selected').data('icon-url');
        $('#service-img').attr('src', icon_url);
        let sid = _this.val();
        $('.data-body').empty();
        let data_list = ``;
        setTimeout(function () {
            $.get( `${base_url}/ajax/fetch_plans`, { "service_id": sid } )
                .done(function( response ) {
                    $.each(response.message, function ( key, value ) {
                        data_list += `<tr><td align="center"><input type="radio" name="plan" value="${value.id}" required></td><td>${value.name} </td><td>${format_currency(value.amount)}</td></tr>`
                    });
                    $('.data-body').append(data_list);
                });
        }, 500);
    });

    $('.verify').on('click', function () {
        let number = $('#number').val();
        let verify_notif = $('.verify-notification');
        let sid = $('#tv-network').val();
        let network_name = $('#tv-network').find(':selected').data('network-name');
        $('#network_name').val(network_name);

        if( number !== '' || sid !== '' ){
            verify_notif.html(`<div class="alert alert-success"><h5><i class="fas fa-spin fa-spinner"></i> Please wait... Verifying your smart card number.</h5></div>`);
            setTimeout(function () {
                $('.verify, .verify-notification').css('display', 'none');
                $('#tv-subscription-form').submit();
            }, 500);

            verify_notif.html(`<div class="alert alert-success"><h5><i class="fas fa-spin fa-spinner"></i> Please wait... Verifying your smart card number.</h5></div>`);
        }else{
            verify_notif.html(`<div class="alert alert-danger"><h5><i class="fas fa-info"></i> Please select bill and enter valid smart card number.</h5></div>`);
            $('#number').focus();
        }
    });


    $('.fund-wallet').on('click', function(e){
        e.preventDefault();
        let _this = $(this);
        _this.prop('disabled', true);
        let amount = $('#amount').val();
        let payment_method = $('#payment-method').val();
        let bank = $('#bank').val();
        let frequency = $('#frequency').val();
        let notif = $('#notification');

        if( payment_method === '' ){
            notif.html(`<div class="alert alert-danger"><h5><i class="fas fa-info"></i> Please select a payment thod to proceed.</h5></div>`);
            _this.prop('disabled', false);
            return false;
        }
        if( payment_method === '1' && amount < 1000 ){
            notif.html(`<div class="alert alert-danger"><h5><i class="fas fa-info"></i> You can't fund less than N1000 using Bank Deposit / Transfer</h5></div>`);
            _this.prop('disabled', false);
            return false;
        }else if( amount < 100){
            notif.html(`<div class="alert alert-danger"><h5><i class="fas fa-info"></i> We can only process a transaction of N100 and above</h5></div>`);
            _this.prop('disabled', false);
            return false;
        }
        if( payment_method === '1' && bank === '' ){
            notif.html(`<div class="alert alert-danger"><h5><i class="fas fa-info"></i> Please select the bank you will be paying into.</h5></div>`);
            _this.prop('disabled', false);
            return false;
        }
        if(payment_method === '3' && amount > 2499 ){
            notif.html(`<div class="alert alert-danger"><h5><i class="fas fa-info"></i> Please make use of the Bank Transfer option for any amount which is N2500 and above.</h5></div>`);
            _this.prop('disabled', false);
            return false;
        }

        amount = parseInt(amount);
        payment_method = parseInt(payment_method);

        $.ajax({
            url : base_url + 'ajax/fund_wallet/',
            method : "POST",
            data : {
                'payment_method' : payment_method,
                'amount' : amount,
                'bank' : bank,
                'frequency': frequency
            },
            success: function (response) {
                if( response.status === 'success' ){
                    console.log(payment_method);
                    if( payment_method === 1 ){
                        sweet_alert('Info',
                            `Please upload proof of payment after making payment for this transaction on the table below. Your transaction ID is ${response.message}`,
                            'info', false);
                        $('.swal-button--confirm').on('click', function () {
                            window.location = base_url + 'dashboard/wallet/' + response.message;
                        });
                    }else if( payment_method === 3){ // 3
                        charge = (1.5 / 100 ) * amount;
                        amount = (amount + parseFloat(charge));
                        let data = {'amount' : amount * 100, 'ref' : response.message};
                        payWithPaystack( data );
                    }else{
                        sweet_alert('info','Please select a payment method','error');
                    }

                }else{
                    sweet_alert('Error!', response.message, response.status );
                    console.log(response.message);
                    _this.prop('disabled', false);
                }
            },
            error : function (response) {
                console.log(response.responseText);
            }
        });

    });




    $('#payment-method').on('change', function () {
        $('#bank-details').css({'display' :'none'});
        $('#povidus-block').css({'display' :'none'});
        $('.fund-wallet').css({'display' :'block'});
        let _value = $(this).val();
        if( _value === '1' ) {
            $('#bank-details').css({'display' :'block'});
        }

        if( _value === '5' ) {
            $('#providus-block').css({'display' :'block'});
            $('.fund-wallet').css({'display' :'none'});
        }
    });



    $('.confirm-reseller-transaction').on('click', function () {
        let tid = $(this).data('tid');
        let _this = $(this);
        let user_id = _this.data('user_id');
        swal({
            title :'Confirm?',
            text : 'You are about confirming this transaction.',
            icon: 'warning',
            buttons : true,
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url : base_url + 'ajax/confirm_reseller/',
                    method: 'POST',
                    cache: false,
                    data : {'tid' : tid , 'user_id' : user_id },
                    success : function(response){
                        if( response.status === 'success' ){
                            sweet_alert('Success', 'Transaction Confirmed successfully.', 'success');
                            $(_this).parents("tr").remove();
                        }else{
                            sweet_alert('Error!', response.message, response.status );
                        }
                    },
                    error : function (response) {
                        console.log(response);
                    }
                });
            }
        });
    });

    $('.confirm-transaction').on('click', function (e) {
        e.preventDefault();
        let tid = $(this).data('tid');
        let _this = $(this);
        let amount = _this.data('amount');
        let user_id = _this.data('user_id');
        swal({
            title :'Confirm?',
            text : 'You are about confirming this transaction.',
            icon: 'warning',
            buttons : true,
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url : base_url + 'ajax/confirm_transaction/',
                    method: 'POST',
                    cache: false,
                    data : {'tid' : tid , 'amount' : amount , 'user_id' : user_id },
                    success : function(response){
                        if( response.status === 'success' ){
                            sweet_alert('Success', 'Transaction Confirmed successfully.', 'success');
                            $(_this).parents("tr").remove();
                        }else{
                            sweet_alert('Error!', response.message, response.status );
                        }
                    },
                    error : function (response) {
                        console.log(response);
                    }
                });
            }
        });
    });

    $('.del-transaction').on('click', function ( e ) {
        e.preventDefault();
        let tid = $(this).data('tid');
        let _this = $(this);
        swal({
            title :'Delete?',
            text : 'You are about deleting this transaction permanently',
            icon: 'warning',
            buttons : true,
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url : base_url + 'ajax/delete_transaction/',
                    method: 'POST',
                    cache: false,
                    data : {'tid' : tid },
                    success : function(response){
                        if( response.status === 'success' ){
                            sweet_alert('Success', 'Transaction deleted successfully.', 'success');
                            $(_this).parents("tr").remove();
                        }else{
                            sweet_alert('Error!', response.message, response.status );
                        }
                    },
                    error : function (response) {
                        console.log(response);
                    }
                });
            }
        });
    });


    $('.confirm-upgrade').on('click', function (e) {
        e.preventDefault();
        let tid = $(this).data('tid');
        let _this = $(this);
        let type = _this.data('type');
        let amount = _this.data('amount');
        let user_id = _this.data('user_id');
        swal({
            title :'Confirm?',
            text : 'You are about confirming this user Upgrade.',
            icon: 'warning',
            buttons : true,
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url : base_url + 'ajax/confirm_upgrade/',
                    method: 'POST',
                    cache: false,
                    data : {'tid' : tid , 'type' : type ,'amount' : amount , 'user_id' : user_id },
                    success : function(response){
                        if( response.status === 'success' ){
                            sweet_alert('Success', 'Transaction Confirmed successfully.', 'success');
                            $(_this).parents("tr").remove();
                        }else{
                            sweet_alert('Error!', response.message, response.status );
                        }
                    },
                    error : function (response) {
                        console.log(response);
                    }
                });
            }
        });
    });


    $('.del-upgrade').on('click', function (e) {
        e.preventDefault();
        let tid = $(this).data('tid');
        let _this = $(this);
        swal({
            title :'Delete?',
            text : 'You are about deleting this transaction permanently',
            icon: 'warning',
            buttons : true,
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url : base_url + 'ajax/delete_upgrade/',
                    method: 'POST',
                    cache: false,
                    data : {'tid' : tid },
                    success : function(response){
                        if( response.status === 'success' ){
                            sweet_alert('Success', 'Transaction deleted successfully.', 'success');
                            $(_this).parents("tr").remove();
                        }else{
                            sweet_alert('Error!', response.message, response.status );
                        }
                    },
                    error : function (response) {
                        console.log(response);
                    }
                });
            }
        });
    });


    $(".number").inputFilter(function (value) {
        return /^-?\d*$/.test(value);
    });


    $('.amount').on('keyup', function () {
        let n = $(this).val();
        let resp = addCommas(n);
        $(this).val( resp );
    });

    $('#airtime_pin_network').on('change', function () {
        let icon_url = $(this).find(':selected').data('icon-url');
        $('#service-img').attr('src', icon_url);
    });

    $('#pin_amount').on('change', function () {
        let pin_amount = $(this).val();
        let network = $('#airtime_pin_network').val();
        let amount = 0;
        if( network !== '' ){
            let rate = 0;
            $('.amount_to_earn').css('display', 'block');
            $.get( `${base_url}/ajax/fetch_network_price`, { "network": network } )
                .done(function( response ) {
                    rate = parseInt(response.message);
                    switch (network) {
                        case 'mtn':
                            amount = (rate/100) * pin_amount;
                            $('.to_receive').text(`You will be receiving ${format_currency(amount)}`);
                            $('#amount_earned').val(amount);
                            break;
                        case 'glo':
                            amount = (rate/100) * pin_amount;
                            $('.to_receive').text(`You will be receiving ${format_currency(amount)}`);
                            $('#amount_earned').val(amount);
                            break;
                        case '9mobile':
                            amount = (rate/100) * pin_amount;
                            $('.to_receive').text(`You will be receiving ${format_currency(amount)}`);
                            $('#amount_earned').val(amount);
                            break;
                        default:
                            amount = (rate/100) * pin_amount;
                            $('.to_receive').text(`You will be receiving ${format_currency(amount)}`);
                            $('#amount_earned').val(amount);
                            break;
                    }
                });
        }else{
            $('.amount_to_earn').css('display', 'none');
        }
    });


    $('.transfer-now').on('click', function (e) {
        e.preventDefault();
        let _this = $(this);
        _this.prop('disabled', true);
        let amount = $('#transfer_amount').val();
        let receiver = $('#receiver').val();
        let product_id = $('#transfer_product_id').val();

        if( payment_method === '' ){
            sweet_alert('Error!', 'Please select a payment method.', 'error' );
            _this.removeAttr('disabled');
        }
        if( receiver === '' ){
            sweet_alert('Error!', 'Please enter the receiver number and must be Gecharl.com user.', 'error' );
            _this.removeAttr('disabled');
        }
        $.ajax({
            url : base_url + 'ajax/fund_wallet/',
            method : "POST",
            data : {'payment_method' : payment_method, 'amount' : amount, 'product_id' : product_id },
            success: function (response) {
                if( response.status === 'success' ){
                    console.log(payment_method);
                    if( payment_method === '1' ){
                        sweet_alert('Info',
                            `Please pay to any of our account details, and use the transaction ID as reference ${response.message}. <b>Sokoya Adeniji Philip</b><br />`,
                            'info', false);
                    }else{

                    }
                }else{
                    sweet_alert('Error!', response.message, response.status );
                    _this.removeAttr('disabled');
                }
            },
            error : function (response) {
                console.log(response.responseText);
            }
        });

    });


    $('#airtime_network').on('change', function () {
        if( $(this).val() ){
            let discount = $(this).find(':selected').data('discount');
            if( discount > 0 ){
                $('.you-pay').text('You will receive '+ discount +'% discount for this transaction.');
            }
        }
    });

    $('#network').on('change', function(e){
        e.preventDefault();
        let service_id = $(this).val();
        $('#smart-card-info').html('');
        $('#smart_card_number').val('');
        let discount = $(this).data('discount');
        if( discount === undefined) discount = $(this).find(':selected').data('discount');

        if( discount > 0 ) {
            $('.you-pay').html('You will receive '+ discount +'% discount for this transaction.');
        }

        $('#network_plan')
            .find('option')
            .remove()
            .end()
            .append('<option value="" selected>--Select Plan --</option>');

        $.ajax({
            url : base_url + 'ajax/fetch_plans/',
            method: "POST",
            data: {'service_id' : service_id },
            success : function(response){
                if( response.status === 'success' ){
                    let count = response.message.length;
                    for( let i = 0; i < count; i++ ){
                        $('#network_plan').append(`<option value="${response.message[i].id}">${response.message[i].name} - ${format_currency(response.message[i].amount)}</option>`);
                    }
                }else{
                    console.log(response.message);
                }
            }
        })
    });


    $('#multichoicenetwork').on('change', function(e){
        e.preventDefault();
        let service_id = $(this).val();
        $('#smart-card-info').html('');
        let network_name = $(this).find(':selected').data('network-name');
        $('#network_name').val(network_name);

        $('#network_plan')
            .find('option')
            .remove()
            .end()
            .append('<option value="" selected>--Select Plan --</option>');

        $.ajax({
            url : base_url + 'ajax/fetch_plans/',
            method: "POST",
            data: {'service_id' : service_id },
            success : function(response){
                if( response.status === 'success' ){
                    let count = response.message.length;
                    for( let i = 0; i < count; i++ ){
                        $('#network_plan').append(`<option value="${response.message[i].name}:${response.message[i].amount}">${response.message[i].name} - ${format_currency(response.message[i].amount)}</option>`);
                    }
                }else{
                    console.log(response.message);
                }
            }
        })
    });



    $('.delete-service').on('click', function(){
        let id = $(this).data('id');
        let _this = $(this);
        swal({
            title :'Are you sure?',
            text : 'Every associated plans will also be deleted with this plan!',
            icon: 'warning',
            buttons : true,
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {

                $.ajax({
                    url : base_url + 'ajax/delete_service/',
                    method: 'POST',
                    cache: false,
                    data : {'service_id' : id },
                    success : function(response){
                        if( response.status === 'success' ){
                            sweet_alert('Success', 'Service and associated deleted successfully.', 'success');
                            $(_this).parents("tr").remove();
                        }else{
                            sweet_alert('Error!', response.message, response.status );
                        }
                    },
                    error : function (response) {
                        console.log(response);
                    }
                });
            }else{
                swal("Oops! We're still good :) ");
            }
        });
    });


    $('.delete-plan').on('click', function(){
        let id = $(this).data('id');
        let _this = $(this);
        swal({
            title :'Are you sure?',
            text : 'You are about deleting this plan.',
            icon: 'warning',
            buttons : true,
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {

                $.ajax({
                    url : base_url + 'ajax/delete_plan/',
                    method: 'POST',
                    cache: false,
                    data : {'plan_id' : id },
                    success : function(response){
                        if( response.status === 'success' ){
                            sweet_alert('Success', 'Plan deleted successfully.', 'success');
                            $(_this).parents("tr").remove();
                        }else{
                            sweet_alert('Error!', response.message, response.status );
                        }

                    },
                    error : function (response) {
                        console.log(response);
                    }
                });
            }else{
                swal("Oops! We're still good :) ");
            }
        });
    });

    $('#phone').on('blur', function(){
        let phone = $(this).val();
        let re = /^-?\d*$/.test(phone);
        if( re ){
            if( phone.length > 1 ){
            let newVal = phone.split(' ').join('');
            newVal = phone.split('.').join('');
            if( newVal.length > 11 ){
                sweet_alert('Error', "Invalid phone number.", 'error');
                $('#phone').val('');
            }
        }
        }else{
            sweet_alert('Error', "Invalid phone number.", 'error');
            $('#phone').val('');
        }
    })


    $('.update-wallet').on('click', function(){
        let id = $(this).data('wid');
        swal({
            title :'Are you sure?',
            text : 'You are about updating this user wallet.',
            icon: 'warning',
            buttons : true,
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                $(`#${id}`).submit();
            }else{
                swal("Huh! Don't be scared... Nothing happens, smile :) ");
            }
        });
    });

    $('.upgrade').on('click', function(){
        let amount = $(this).data('amount');
        let type = $(this).data('type');

        swal({
            title :'Confirm?',
            text : `Please confirm that you'll like to go for this service. You will be paying N${amount} for the ${type} plan.`,
            icon: 'warning',
            buttons : true,
            dangerMode: true,
        }).then((yesConfirm) => {
            if (yesConfirm) {
                $.ajax({
                    url : base_url + 'ajax/upgrade_membership_request/',
                    method: "POST",
                    cache : false,
                    data: {'type' : type, 'amount' : amount},
                    success : function(response){
                        if( response.status === 'success' ){
                            sweet_alert('Success',"Please complete the process by clicking OK", 'success', false);
                            $('.swal-button--confirm').on('click', function () {
                                window.location = base_url + 'dashboard/confirm_upgrade/?tid=' +response.message;
                            })
                        }else{
                            sweet_alert('Error', response.message, 'error', false);
                        }
                    },
                    error : function(response){
                        sweet_alert('Error', 'There was an error processing this...', 'error');
                    }
                });
            }else{
                sweet_alert('Info', "We're still good. Nothing happened.", 'info');
            }
        });
    });


    $('.getMonnify').on('click', function(){
        $(this).text('Generating your account number...');
        $.get(`${base_url}ajax/get_reserve_account`)
            .done(function( resp ) {
                if( resp.status === 'success'){
                    // toastr.success("Good! Your auto-funding account has been created....");
                    // console.log(resp);
                    window.location = window.location.href;
                }else{
                    sweet_alert('Error', 'There was an error when creating the account. Please try again later or contact support.', 'error');
                }
            });
    })


});

function saveContact(x){
    let y = parseInt(x);
    if( y === 1 ){
        $('#save-contact-box').css({'display':'block'});
        $('#save-confirmation').css({'display' : 'none'});
    }else{
        $('.save-contact-container').css({'display':'none'});
    }
}

function setContact( x ){
    $('#phone').val(x);
    $('.m-scroll').css({'display':'none'});
}




function format_currency(str) {
    return '₦' + str.toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,")
}


function sweet_alert(title, message, type ='error', close = true) {
    const template = (`<strong'>${message}</strong>`);
    swal({
        icon : type,
        title : title,
        closeOnClickOutside: close,
        closeOnEsc: close,
        content :{
            element : 'p',
            attributes : {
                innerHTML : `${template}`
            }
        }
    });
}



function addCommas(nStr) {
    nStr += '';
    var x = nStr.split('.');
    var x1 = x[0];
    var x2 = x.length > 1 ? '.' + x[1] : '';
    var rgx = /(\d+)(\d{3})/;
    while (rgx.test(x1)) {
        x1 = x1.replace(rgx, '$1' + ',' + '$2');
    }
    return x1 + x2;
}


function payWithPaystack( data ){
    var handler = PaystackPop.setup({
        key: pk_key,
        email: user.email,
        amount: data.amount,
        currency: "NGN",
        ref: ''+data.ref,
        metadata: {
            custom_fields: [
                {
                    display_name: "",
                    variable_name: "user",
                    value: user.user
                }
            ]
        },
        callback: function(response){
            verifyPaystack( response.reference, data.ref );
        },
        onClose: function(){
            sweet_alert('Info', "You closed the window, and for this reason we could'nt validate your payment", 'info');

        }
    });
    handler.openIframe();
}

function verifyPaystack( pref, ref){
    $.ajax({
        url : base_url + 'ajax/verifyPaystack/',
        method : "POST",
        cache: false,
        data : {'reference' : pref, 'ref' : ref },
        success: function (response) {
            if( response.status === 'success' ){
                sweet_alert('Success!', response.message, response.status );
                console.log(response.message);
            }else{
                sweet_alert('Error!', response.message, response.status );
                console.log(response.message);
            }
            $('.swal-button--confirm').on('click', function () {
                window.location = window.location.href;
            });
        },
        error : function (response) {
            console.log(response.responseText);
        }
    });
}
$(document).ready( function () {
    $('.table').DataTable({
        "order": [[ 0, "desc" ]]
    });
} );




