﻿<?php $this->load->view('landing/resources/meta');?>
<body>

    <!--Header-->
    <header id="header" class="header-effect-shrink" data-plugin-options="{'stickyEnabled': true, 'stickyEnableOnBoxed': true, 'stickyEnableOnMobile': true, 'stickyStartAt': 120}">
        <div class="header-body">
            <div class="header-top">
                <div class="header-top-container container">
                    <div class="header-row">
                        <div class="header-column justify-content-start">
                            <a href="https://www.facebook.com/payscribe/" target="_blank" class="social-icon si-borderless si-facebook si-small mb-0" title="Facebook">
                                <i class="si-icon-facebook"></i>
                                <i class="si-icon-facebook"></i>
                            </a>
                            <a href="#" class="social-icon si-borderless si-twitter si-small mb-0" title="Twitter">
                                <i class="si-icon-twitter"></i>
                                <i class="si-icon-twitter"></i>
                            </a>
                            <a href="#" class="social-icon si-borderless si-instagram si-small mb-0" title="Instagram">
                                <i class="si-icon-instagram"></i>
                                <i class="si-icon-instagram"></i>
                            </a>
                        </div>
                        <div class="header-column justify-content-end">
                            <div class="d-md-block d-sm-block d-xl-block mb-0">
                            <span class=" d-sm-flex align-items-center ml-3">
                            <i class="fab fa-whatsapp mr-1"></i>
                            <a href="tel:<?= lang('contact_no'); ?>">Call us: <strong><?= lang('contact_no'); ?></strong></a>
                            </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="header-container container">
                <div class="header-row">
                    <div class="header-column justify-content-start">
                        <div class="header-logo">
                            <a href="<?= base_url();?>">
                                <img alt="Payscribe" width="130" src="<?= base_url('assets/img/payscribe_logo.png')?>">
                            </a>
                        </div>
                    </div>
                    <div class="header-column justify-content-end">
                        <div class="header-nav header-nav-light-dropdown">
                            <?php if( !$this->session->userdata('logged_in')) :?>
                                <div class="header-nav-main header-nav-main-effect-1 header-nav-main-sub-effect-1">
                                    <nav class="collapse">
                                        <ul class="nav flex-column flex-lg-row" id="mainNav">
                                            <li class="dropdown dropdown-mega">
                                                <a href="<?= base_url('page/data_pricing/'); ?>">Data Pricing</a>
                                            </li>
                                            <li class="dropdown dropdown-mega">
                                                <a href="<?= base_url('auth/login/'); ?>">Login</a>
                                            </li>
                                        </ul>
                                    </nav>
                                </div>
                                <div class="header-button d-none d-sm-flex ml-3">
                                    <a class="btn v-btn standard lightgrey sf-icon-reveal mb-0 mr-0" href="<?= base_url('auth/create/')?>" target="_self">
                                        <i class="icon-user-2"></i><span class="text text-uppercase">Get Started</span>
                                    </a>
                                </div>
                            <?php else: ?>
                                <div class="header-nav-main header-nav-main-effect-1 header-nav-main-sub-effect-1">
                                    <nav class="collapse">
                                        <ul class="nav flex-column flex-lg-row" id="mainNav">
                                            <li class="dropdown dropdown-mega">
                                                <a href="<?= base_url('page/data_pricing/'); ?>">Data Pricing</a>
                                            </li>
                                            <li class="dropdown dropdown-mega">
                                                <a href="<?= base_url('logout/'); ?>">Logout</a>
                                            </li>
                                        </ul>
                                    </nav>
                                </div>
                                <div class="header-button d-sm-flex ml-3">
                                    <a class="btn v-btn standard lightgrey sf-icon-reveal mb-0 mr-0" href="<?= base_url('dashboard/')?>" target="_self">
                                        <i class="icon-user-2"></i><span class="text text-uppercase">My Account</span>
                                    </a>
                                </div>
                            <?php endif; ?>

                            <button class="header-btn-collapse-nav ml-3" data-toggle="collapse" data-target=".header-nav-main nav">
                            <span class="hamburguer">
                                <span></span>
                                <span></span>
                                <span></span>
                            </span>
                                <span class="close">
                                <span></span>
                                <span></span>
                            </span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!--End Header-->

    <div role="main" class="main">
        <section class="page-header">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-md-8 text-left">
                        <h1>Data Pricing</h1>
                    </div>
                    <div class="col-md-4">
                        <ul class="breadcrumb justify-content-start justify-content-md-end mb-0">
                            <li><a href="<?= base_url();?>">Home</a></li>
                            <li class="active">Cheap & Lasting data pricing.</li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>

        <div class="v-page-wrap">
<!--        <div class="v-page-wrap has-right-sidebar has-one-sidebar">-->

            <div class="container">
                <div class="col-sm-12">
                    <h3 class="v-heading v-center-heading"><span>User Data Pricing:</span></h3>
                </div>

                <div class="pricing-table pricing-table-style-1 mb-5">
                    <div class="row">
                        <?php foreach( $users_plan as $user ) : ?>
                            <div class="col-lg-3 col-md-6 p-0 plan">
                                <div class="plan-title">
                                    <h3 class="text-color-secondary"><?= ucwords( $user->network_name ); ?></h3>
                                </div>
                                <div class="plan-price">
                                    <p><img alt="<?= $user->network_name . '-' . $user->message; ?>" style="width: 30px;" src="<?= CLOUDINARY_IMG_URL . $user->image;?>" /></p>
                                        <em>Check Balance: <?= $user->check_balance; ?></em>
                                </div><hr />
                                <div class="plan-detail">
                                    <ul>
                                        <?php $plans = $this->site->get_result('plans', 'name, amount', array('sid' => $user->id));
                                            foreach( $plans as $plan ):
                                        ?>
                                            <li><?= $plan->name . ' - ' . ngn($plan->amount);?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                    <a href="<?= base_url('auth/login/')?>" class="btn btn-outline-primary btn-rounded pr-5 pl-5">BUY NOW</a>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-12">
                        <div class="v-shadow-wrap">
                            <div class="v-tagline-box v-tagline-box-v1 v-box-shadow shadow-effect-2">
                                <h2>Join our fast rising reseller package</h2>
                                <p>
                                    Check out our reseller data package. You also get a one-time N500 when the person you referred to transact up-to N5000 above.
                                    <strong><?= anchor('/auth/login/', 'Login to get started', 'class="text-primary"')?></strong>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="col-sm-12">
                    <h3 class="v-heading v-center-heading"><span>Reseller Data Pricing:</span></h3>
                </div>

                <div class="pricing-table pricing-table-style-1 mb-5">
                    <div class="row">
                        <?php foreach( $resellers_plan as $reseller ) : ?>
                            <div class="col-lg-3 col-md-6 p-0 plan plan-most-popular border-color-primary">
                                <div class="plan-title">
                                    <h3 class="text-color-dark"><?= ucwords( $reseller->network_name ); ?></h3>
                                </div>
                                <div class="plan-price">
                                    <p><img alt="<?= $reseller->network_name . '-' . $reseller->message; ?>" style="width: 30px;" src="<?= CLOUDINARY_IMG_URL . $reseller->image;?>" /></p>
                                    <em>Check Balance: <?= $reseller->check_balance; ?></em>
                                </div><hr />
                                <div class="plan-detail">
                                    <ul>
                                        <?php $plans = $this->site->get_result('plans', 'name, amount', array('sid' => $reseller->id));
                                        foreach( $plans as $plan ):
                                            ?>
                                            <li><?= $plan->name . ' - ' . ngn($plan->amount);?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                    <a href="<?= base_url('auth/login/')?>" class="btn btn-outline-primary btn-rounded pr-5 pl-5">BUY NOW</a>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                </div>

                <div class="col-sm-12">
                    <h3 class="v-center-heading"><span>Still need to contact us? <br /> We're available 24/7 Call / WhatsApp
                            <a class="text-primary" href="tel:07038067493" title="Call/ WhatsApp">07038067493</a> or
                            <a class="text-primary" href="<?= base_url('page/contact/')?>" title="COntact Us">Contact Us</a>
                        </span>
                    </h3>
                </div>

            </div>



            <div class="container">
                <div class="row">
                    <div class="v-spacer col-sm-12 v-height-mini"></div>

                </div>
            </div>

            <div class="v-clients-widget-v2">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-12">
                            <h3>Our Partners </h3>
                            <div class="v-clients-wrap-v2 carousel-wrap">
                                <div class="owl-carousel" data-plugin-options='{"items": 6, "singleItem": false, "autoPlay": true}'>
                                    <div class="item">
                                        <figure>
                                            <a href="https://www.mtnonline.com" target="_blank">
                                                <img alt="Payscribe partner with MTN Nigeria" src="<?= base_url('assets/img/partners/mtn.png'); ?>" />
                                            </a>
                                        </figure>
                                    </div>
                                    <div class="item">
                                        <figure>
                                            <a href="https://www.gloworld.com/ng/" target="_blank">
                                                <img alt="Payscribe partner with Glo world" src="<?= base_url('assets/img/partners/glo.png'); ?>" />
                                            </a>
                                        </figure>
                                    </div>
                                    <div class="item">
                                        <figure>
                                            <a href="https://9mobile.com.ng/" target="_blank">
                                                <img alt="Payscribe in partnership with 9mobile" src="<?= base_url('assets/img/partners/9mobile.png'); ?>" />
                                            </a>
                                        </figure>
                                    </div>
                                    <div class="item">
                                        <figure>
                                            <a href="https://airtel.com.ng/" target="_blank">
                                                <img alt="Buying Airtal Data plan in Nigeria" src="<?= base_url('assets/img/partners/airtel.png');?>" />
                                            </a>
                                        </figure>
                                    </div>
                                    <div class="item">
                                        <figure>
                                            <a href="http://www.dstv.com/" target="_blank">
                                                <img alt="Subscribe DSTV using Payscribe" src="<?= base_url('assets/img/partners/dstv.png'); ?>" />
                                            </a>
                                        </figure>
                                    </div>
                                    <div class="item">
                                        <figure>
                                            <a href="http://eazy.gotvafrica.com/en/ng/" target="_blank">
                                                <img alt="GOTV Africa subscription using payscribe " src="<?= base_url('assets/img/partners/gotv.png'); ?>" />
                                            </a>
                                        </figure>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <!--Footer-Wrap-->
        <?php $this->load->view('landing/resources/footer'); ?>
        <!--End Footer-Wrap-->
    </div>

    <!-- Libs -->
    <?php $this->load->view('landing/resources/script'); ?>
</body>
</html>