<?php $this->load->view('app/resources/meta'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">

                    <?php $this->load->view('confirm_upgrade'); ?>

                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-header">Wallet</div>

                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-3"></div>
                                    <div class="col-md-6">
                                        <?php $this->load->view('msg_view'); ?>
                                        <?php if(!$row) :?>
                                            <?= form_open(''); ?>
                                            <div class="form-group">
                                                <label for="Deposit Amount">Deposit Amount</label>
                                                <input type="text" name="amount" id="amount" required class="form-control number" placeholder="Enter Amount">
                                            </div>
                                            <div class="form-group">
                                                <label for="payment type">Payment Type</label>
                                                <select class="form-control" id="payment-method" required name="payment_method">
                                                    <option value="">--Select A Payment Type--</option>
                                                    <option value="1">Bank Transfer / Deposit</option>
                                                    <option value="3" >Pay Online Using ATM Card ( + 1.5% )</option>
                                                    <option value="5" >Fund Using Your Providus Account</option>
                                                </select>
                                            </div>

                                            <div class="row">
                                                <div class="form-group" id="bank-details" style="display: none;">
                                                    <label for="bank-details">Select bank</label>
                                                    <select name="bank" id="bank" class="form-control">
                                                        <option value="">-- Please select the bank details you'll like paying into --</option>
                                                        <?php
                                                        $banks = explode('|', lang('company_banks'));
                                                        foreach ( $banks as $bank ) :
                                                            ?>
                                                            <option value="<?= $bank; ?>" <?= set_select('bank', $bank ); ?> ><?= $bank; ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>
                                                <div class="col-sm-12">
                                                    <div class="form-group" style="display: none;" id="providus-block">
                                                        <p class="card-text">Dear <?= ucwords($user->name)?>, Your Providus Account details is: <br />
                                                            <b>Bank Name:</b> Providus Bank<br />
                                                            <b>Account Name:</b>  <?= lang('app_name').' '. $user->user_code; ?><br />
                                                            <b>Account Number:</b> <?= $user->providus; ?>
                                                        </p>
                                                        <p class="text-success">Send money to it, and and your wallet will be funded instantly.</p>
                                                    </div>
                                                </div>
                                            </div>

                                            <div id="notification"></div>
                                            <button class="btn btn-sm btn-success col-sm-12 fund-wallet">PROCEED</button>
                                            <?= form_close(); ?>

                                        <?php else :?>
                                                <div class="alert alert-info">
                                                    <p>Please confirm you have made payment</p>
                                                </div>
                                                <?= form_open_multipart('', 'role="form"'); ?>
                                                <div class="form-group">
                                                    <label for="Deposit Amount">Amount Deposited</label>
                                                    <input type="text" name="amount" id="amount" readonly class="form-control number" value="<?= set_value('amount', $row->amount)?>" required >
                                                </div>
                                                <div class="form-group" id="bank-details">
                                                    <label for="bank-details">Please select bank</label>
                                                    <select name="bank" id="bank" class="form-control" required>
                                                        <option value="" selected>--Please select the bank you paid into--</option>
                                                        <?php
                                                        $banks = explode('|', lang('company_banks'));
                                                        foreach ( $banks as $bank ) :
                                                            ?>
                                                            <option value="<?= $bank; ?>" <?= set_select('bank', $bank ); ?> ><?= $bank; ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>
                                                <div class="form-group">
                                                    <label for="pop">Screenshot</label>
                                                    <input type="file" name="pop" required accept="image/*">
                                                </div>
                                                <div class="form-group">
                                                    <label for="comment">Comment</label>
                                                    <textarea name="comment" required class="form-control" placeholder="Payment remark/comment."><?= set_value('comment',''); ?></textarea>
                                                </div>
                                                <input type="hidden" name="trans_id" value="<?=$row->trans_id;?>">
                                                <button class="btn btn-sm btn-primary mr-2 mb" type="submit">SUBMIT</button>
                                                <a href="<?= base_url('dashboard/wallet/')?>" class="btn btn-sm btn-danger mr-2 mb">CANCEL</a>
                                                <?= form_close(); ?>
                                        <?php endif; ?>


                                    </div>
                                    <div class="col-md-3"></div>
                                </div>

                                <div class="row py-5">
                                    <div class="col-md-12">

                                        <?php if($transactions) : ?>
                                            <div class="title">Please confirm you have made the payment</div>
                                            <div class="table-responsive">
                                                <table class="table table-striped table-hover">
                                                    <thead>
                                                    <tr>
                                                        <th style="display: none;">id</th>
                                                        <th>S/N</th>
                                                        <th>Transaction Id</th>
                                                        <th>Amount</th>
                                                        <th>Date Initiated</th>
                                                        <th>Action</th>
                                                        <th>Status</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php $x = 1;  foreach($transactions as $transaction) : ?>
                                                        <tr>
                                                            <td style="display: none;"><?= $transaction->id; ?></td>
                                                            <td><?= $x; ?></td>
                                                            <td><?= $transaction->trans_id; ?>
                                                                <?php if( is_null($transaction->tid) && $transaction->payment_method == 1 ) : ?>
                                                                    &nbsp;<a title="Click to upload proof of payment" href="<?= base_url('dashboard/wallet/' . $transaction->trans_id .'/'); ?>">Upload proof of payment</a>
                                                                <?php endif; ?>
                                                            </td>
                                                            <td><?= ngn( $transaction->amount); ?></td>
                                                            <td><?= neatDate($transaction->date_initiated) . ' ' . neatTime( $transaction->date_initiated); ?></td>
                                                            <td>
                                                                <?php if($transaction->payment_method == 3 ) : ?>
                                                                    <button class="btn btn-sm btn-info"><?= !empty($transaction->payment_status) ? $transaction->payment_status : 'Transaction Not completed'; ?></button>
                                                                <?php else :?>
                                                                    <?php if(is_null($transaction->tid)) : ?>
                                                                        <a class="btn btn-sm btn-success" href="<?= base_url('dashboard/wallet/' . $transaction->trans_id .'/'); ?>">Upload proof of payment</a> |
                                                                        <button class="btn btn-sm btn-danger del-transaction" data-tid="<?= $transaction->id; ?>">Delete Transaction</button>
                                                                    <?php else : ?>
                                                                        <button type="button" class="btn btn-sm btn-success" disabled >Payment Uploaded</button>
                                                                    <?php endif; ?>
                                                                <?php endif;?>
                                                            </td>
                                                            <td class="text-center"><?= statusLabel( $transaction->status); ?></td>
                                                        </tr>
                                                        <?php $x++ ; endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
</body>
</html>
