<?php $this->load->view('app/resources/meta'); ?>
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="col-md-12">
                    <?php $this->load->view('msg_view'); ?>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?php $this->load->view('msg_view'); ?>
                        <div class="main-card mb-3 card">
                            <div class="card-header">Verify TV Subscription</div>
                            <?= form_open(base_url('dashboard/tv_subscription'), 'id="tv-form"'); ?>
                            <div class="card-body">
                                <div class="form-group">
                                    <label class="label" for="Network">Select Network</label>
                                    <select required class="form-control tv-options" name="network_name">
                                        <option value="" selected>-- Select TV Cable --</option>
                                        <?php foreach ($networks as $network ): ?>
                                            <option value="<?= $network->network_name; ?>"><?= ucwords($network->title); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <?= form_error('network_name'); ?>
                                </div>
                                <div class="form-group">
                                    <label for="iuc-number">IUC / Smart Card Number</label>
                                    <input type="text" name="smart_card_number" class="form-control number" required autocomplete="on" placeholder="IUC Number">
                                    <?= form_error('smart_card_number'); ?>
                                </div>

                                <div class="form-group y-scroll">
                                    <label>Select a plan to proceed</label>
                                    <table class="table table-striped table-bordered" id="tv-list">
                                        <tbody class="data-body"></tbody>
                                    </table>
                                </div>

                                <div class="form-group">
                                    <label for="iuc-number">Number of month subscription</label>
                                    <select name="month" class="form-control">
                                        <option value="1" selected> 1 Month</option>
                                        <?php for( $x = 2; $x <= 12; $x++ ): ?>
                                                <option value="<?=$x?>" > <?=$x?> Month</option>
                                        <?php endfor;?>
                                    </select>
                                </div>
                            </div>
                            <div class="d-block card-footer">
                                <div id="content" style="display: none">
                                    <div class="form-group">
                                        <label for="customer_name">Customer Name</label>
                                        <input type="text" name="customer_name" id="customer_name" readonly class="form-control" required  placeholder="Customer Name">
                                    </div>
                                    <div class="form-group">
                                        <label for="name">Phone Number</label>
                                        <input class="form-control" type="text" name="phone" value="<?=$user->phone?>"  id="phone">
                                    </div>
                                    <p>
                                        <span class="text-danger">Kindly confirm the data are correct before submitting</span>
                                    </p>
                                    <button class="btn-wide btn btn-primary" type="submit">Submit</button>
                                </div>
                                <div class="row justify-content-between mx-4">
                                    <button class="btn-wide btn btn-success verify-tv" disabled type="button">Verify</button>
                                </div>
                            </div>
                            <?= form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
</body>
</html>
