<?php $this->load->view('app/resources/meta'); ?>
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">
                    <div class="col-md-12">
                        <?php $this->load->view('msg_view'); ?>
                    </div>
                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-header">Verify Meter Number</div>
                            <?= form_open(''); ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-3"></div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label" for="Network">Electricity</label>
                                            <select required class="form-control" id="network" name="electricity_name">
                                                <option value="" selected>-- Select Electricity Name --</option>
                                                <?php foreach ( $electricity as $plan ): ?>
                                                    <option value="<?=$plan->message ?>">
                                                        <?= ucwords($plan->title); ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                            <?= form_error('electricity_name'); ?>
                                        </div>
                                        <div class="form-group">
                                            <label for="iuc-number">Meter Number</label>
                                            <input type="text" name="meter_number" value="<?= set_value('meter_number','')?>" class="form-control" required placeholder="Meter Number">
                                            <?= form_error('meter_number'); ?>
                                        </div>
                                        <div class="form-group">
                                            <label for="meter_type">Meter Type</label>
                                            <select class="form-control" name="meter_type" id="meter_type" required>
                                                <option value="" selected> -- Select Meter Type -- </option>
                                                <option value="prepaid" <?php if( isset($_POST['meter_type']) && $_POST['meter_type'] == 'prepaid') echo 'selected'?> <?= set_select('meter_type', 'prepaid'); ?> >Prepaid</option>
                                                <option value="postpaid" <?php if( isset($_POST['meter_type']) && $_POST['meter_type'] == 'postpaid') echo 'selected'?> <?= set_select('meter_type', 'postpaid'); ?> >Postpaid</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="iuc-number">Amount *</label>
                                            <input type="text" name="amount" class="form-control" required placeholder="Amount">
                                        </div>
                                    </div>
                                    <div class="col-md-3"></div>
                                </div>
                            </div>
                            <div class="d-block text-center card-footer">
                                <button class="mr-2 btn-icon btn-icon-only btn btn-outline-danger" type="reset">Reset Form</button>
                                <button class="btn-wide btn btn-success" type="submit">Verify</button>
                            </div>
                            <?= form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
</body>
</html>
