<?php $this->load->view('app/resources/meta'); ?>
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">
                    <div class="col-md-12">
                        <?php $this->load->view('msg_view'); ?>
                    </div>
                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-header">Subscribe <?= strtoupper($tv_sub['network_name']); ?></div>
                            <?= form_open('dashboard/tv_subscription'); ?>
                            <div class="card-body">
                                <div class="form-group">
                                    <label class="label" for="Network">Select Network</label>
                                    <select class="form-control" id="network" name="network">
                                        <option value="" selected>-- Select TV Cable --</option>
                                        <?php foreach ($networks as $network ): ?>
                                            <option data-network-name="<?= $network->network_name; ?>"
                                                <?php if( strtoupper($network->network_name) == $tv_sub['network_name']) echo 'selected'; ?>
                                                    value="<?= $network->id?>"><?= ucwords($network->title); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <?= form_error('network'); ?>
                                </div>

                                <div class="col-sm-12">
                                    <div class="form-group y-scroll">
                                        <span class="text-danger">Select a plan to proceed</span>
                                        <table class="table table-striped table-bordered" id="tv-list">
                                            <tbody class="data-body">
                                            <?php if( $tv_sub['bouquets'] ) :?>
                                                <?php $x =0; foreach( $tv_sub['bouquets'] as $bouquet ) :?>
                                                    <tr>
                                                        <?php if( strtolower($tv_sub['network_name']) == 'startimes') : ?>
                                                            <td align="center">
                                                                <input type="radio" name="plan" value="<?= $bouquet['name']; ?>">
                                                            </td>
                                                            <td>
                                                                <?= $bouquet['name']; ?>
                                                            </td>
                                                            <td class="text-primary">
                                                                <select name="<?= $bouquet['name']?>_cycle" class="form-control">
                                                                    <option value="">- Select the cycle -</option>
                                                                    <?php foreach( $bouquet['cycles'] as $cycle => $value ) : ?>
                                                                        <option value="<?= $cycle . ':' . $value;?>"><?=$cycle . ' - ' . ngn($value)?></option>
                                                                    <?php endforeach; ?>
                                                                </select>
                                                            </td>
                                                        <?php else :?>
                                                            <td align="center">
                                                                <input type="radio" name="plan" value="<?= $bouquet['plan']?>::<?= $bouquet['amount'];?>" required>
                                                            </td>
                                                            <td>
                                                                <?= $bouquet['name']; ?>
                                                            </td>
                                                            <td>
                                                                <?= ngn( $bouquet['amount']); ?>
                                                            </td>
                                                        <?php endif;?>
                                                    </tr>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="iuc-number">IUC/ Smart Card Number</label>
                                    <input type="text" name="smart_card_number" id="smart_card_number" value="<?= $tv_sub['smart_card_number']; ?>" class="form-control number" required autocomplete="off" placeholder="IUC Number">
                                    <?= form_error('smart_card_number'); ?>
                                </div>

                                <div class="form-group">
                                    <label for="registered_name">Registered Name</label>
                                    <input type="text" name="registered_name" id="registered_name" value="<?= $tv_sub['customer_name']; ?>" class="form-control" required readonly>
                                    <?= form_error('registered_name'); ?>
                                </div>

                                <div class="form-group">
                                    <label for="registered_name">User Phone Number</label>
                                    <input type="number" name="phone" id="phone" value="<?= $user->phone; ?>" class="form-control" required>
                                </div>
                                <input type="hidden" name="productCode" value="<?= $tv_sub['productCode']; ?>">
                                <input type="hidden" name="productToken" value="<?= $tv_sub['productToken']; ?>">
                                <input type="hidden" name="network_name" id="network_name" value="<?= $tv_sub['network_name']; ?>">

                            </div>
                            <div class="d-block text-center card-footer">
                                <p>
                                    <span class="text-danger">Please confirm that the data you entered are correct.</span>
                                </p>
                                <button class="btn-wide btn btn-success" type="submit">Subscribe</button>
                            </div>
                            <?= form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
</body>
</html>
