<?php $this->load->view('app/resources/meta'); ?>
<link rel="stylesheet" href="<?= base_url('assets/css/classic.css');?>">
<link rel="stylesheet" href="<?= base_url('assets/css/classic.date.css');?>">
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">

                    <?php $this->load->view('confirm_upgrade'); ?>

                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-header">Transactions</div>
                            <?= form_open(''); ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-1"></div>
                                    <div class="col-md-10">
                                        <?php $this->load->view('msg_view'); ?>
                                        <div class="row">
                                            <?= form_open('', 'role="form"')?>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label for="start_date">Start Date</label>
                                                    <input type="date" class="form-control datepicker" name="start_date" value="<?= (isset($_POST['start'])) ? $_POST['start'] : '' ;?>">
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <label for="end_date">End Date</label>
                                                <input type="date" class="form-control datepicker" name="end_date" value="<?= (isset($_POST['end'])) ? $_POST['end'] : '' ;?>">
                                            </div>
                                            <div class="col-sm-3">
                                                <label for="product">Transaction Type</label>
                                                <select class="form-control" name="transaction_type">
                                                    <option value=""> -- All --</option>
                                                    <?php foreach($products as $product) :?>
                                                        <option <?php if (isset($_POST['transaction_type']) && $_POST['transaction_type'] == $product->id ) echo 'selected';?>
                                                                value="<?= $product->id; ?>"><?= ucwords($product->title); ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                            <div class="col-sm-3">
                                                <label for="submit_btn">&nbsp;</label>
                                                <button type="submit" class="btn btn-sm btn-primary col-sm-12"><b>FILTER</b></button>
                                            </div>
                                            <?= form_close();?>
                                        </div>
                                        <?php if($transactions != '') : ?>
                                        <div class="py-7" style="padding-top: 40px;">
                                            <div class="table-responsive">
                                                <table id="dataTable" class="table-striped table-hover">
                                                    <thead>
                                                    <tr>
                                                        <th style="display: none;">ID</th>
                                                        <th>TX ID</th>
                                                        <th>Time</th>
                                                        <th>Amount</th>
                                                        <th>Balance</th>
                                                        <th>Product</th>
                                                        <th>Description</th>
                                                        <th>Status</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php foreach($transactions as $transaction ) : ?>
                                                        <tr>
                                                            <td style="display: none;">
                                                                <a href="<?= base_url('dashboard/invoice/' . $transaction->trans_id); ?>">
                                                                    <?= $transaction->id; ?>
                                                                </a>
                                                            </td>
                                                            <td><?= $transaction->trans_id; ?></td>
                                                            <td><?= neatDate( $transaction->date_initiated) . ' ' . neatTime( $transaction->date_initiated); ?></td>
                                                            <td><?= ngn($transaction->amount);?></td>
                                                            <td><?= ngn($transaction->balance);?></td>
                                                            <td><?= product_name($transaction->product_id)?></td>
                                                            <td><?= payment_id_replacer($transaction->description); ?></td>
                                                            <td>
                                                                <?php if( $transaction->status == "success" || $transaction->status == "approved" ) : ?>
                                                                <?php endif; ?>
                                                                <?= statusLabel($transaction->status); ?>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach;?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                        <?php endif; ?>
                                    <div class="col-md-1"></div>
                                </div>
                            </div>
                            <?= form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
<script type="text/javascript" src="<?= base_url('assets/js/picker.js')?>"></script>
<script type="text/javascript" src="<?= base_url('assets/js/datepicker.js')?>"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>

<script>
    $(document).ready(function () {
        $("#dataTable").dataTable({
            "order": [[ 0, "desc" ]],
            dom: 'Bfrtip',
            buttons: [
                'copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5'
            ]
        });
    });
</script>
</body>
</html>
