<?php
$this->load->view('app/resources/meta');
?>
</head>
<body>
<div class="wrapper">
    <!-- top navbar-->
    <?php $this->load->view('app/resources/header'); ?>
    <!-- sidebar-->
        <?php $this->load->view('app/resources/aside'); ?>
    <!-- Main section-->
    <section>
        <!-- Page content-->
        <div class="content-wrapper">
            <div class="container-md">
                <div class="row">
                    <div class="col-md-3">
                        <div class="panel b">
                            <div class="panel-heading bg-gray-lighter text-bold">Personal Settings</div>
                            <div class="list-group"><a class="list-group-item" href="#tabSetting1" data-toggle="tab">Profile</a><a class="list-group-item" href="#tabSetting2" data-toggle="tab">Account</a>
                                <a class="list-group-item" href="#tabSetting3" data-toggle="tab">Notifications</a>
                                <a class="list-group-item" href="#tabSetting4" data-toggle="tab">Applications</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <?php $this->load->view('msg_view'); ?>
                        <div class="tab-content p0 b0">
                            <div class="tab-pane active" id="tabSetting1">
                                <div class="panel b">
                                    <div class="panel-heading bg-gray-lighter text-bold">Profile</div>
                                    <div class="panel-body">
                                        <?= form_open('/dashboard/profile_setting', 'role="form"'); ?>
                                            <div class="form-group">
                                                <label for="name">Name</label>
                                                <input class="form-control" type="text" name="name" value="<?= set_value('name', $user->name); ?>">
                                                <?= form_error('name')?>
                                            </div>
                                            <div class="form-group">
                                                <label for="name">Account Name</label>
                                                <input class="form-control" type="text" name="account_name" value="<?= set_value('account_name', $user->account_name); ?>">
                                                <?= form_error('account_name')?>
                                            </div>
                                            <div class="form-group">
                                                <label for="name">Account Number</label>
                                                <input class="form-control" type="text" name="account_number" value="<?= set_value('account_number', $user->account_number); ?>">
                                                <?= form_error('account_number')?>
                                            </div>

                                            <div class="form-group">
                                                <label for="account_type">Account Type</label>
                                                <select class="form-control" name="account_type">
                                                    <option value="current" <?php if($user->account_type == 'current') echo 'selected'; ?>>Current Account</option>
                                                    <option value="savings" <?php if($user->account_type == 'savings') echo 'selected'; ?>>Savings Account</option>
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label for="bank_name">Bank Name</label>
                                                <select name="bank_name" class="form-control">
                                                    <option value="">-- Select Bank Name --</option>
                                                    <?php
                                                    $banks = explode(',', lang('banks'));
                                                    foreach ( $banks as $bank ) : ?>
                                                        <option value="<?= trim($bank); ?>" <?php if( $user->bank_name == trim($bank) ) echo 'selected'; ?> ><?= trim($bank); ?></option>
                                                    <?php endforeach;
                                                    ?>
                                                </select>
                                            </div>

                                            <div class="form-group">
                                                <label for="bio">Bio</label>
                                                <textarea class="form-control" rows="3" name="bio"> <?= set_value('bio', $user->bio)?></textarea>
                                                <?= form_error('bio')?>
                                            </div>

                                            <div class="form-group">
                                                <label for="url">URL</label>
                                                <input class="form-control" type="text" name="url" value="<?= set_value('url', $user->url)?>">
                                                <?= form_error('url'); ?>
                                            </div>

                                            <div class="form-group">
                                                <label>Company</label>
                                                <input class="form-control" type="text" name="company" value="<?= set_value('company', $user->company); ?>">
                                                <?= form_error('company')?>
                                            </div>

                                            <div class="form-group">
                                                <label for="password">Confirm Password</label>
                                                <input type="password" name="confirm_password" id="confirm_password" class="form-control" required placeholder="Please enter your password for confirmation">
                                            </div>

                                            <input type="hidden" name="post_type" value="account">
                                            <button class="btn btn-info" type="submit">Update settings</button>
                                        <?= form_close(); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tabSetting2">
                                <div class="panel b">
                                    <div class="panel-heading bg-gray-lighter text-bold">Account</div>
                                    <div class="panel-body">
                                        <?= form_open('dashboard/profile_setting', 'role="form"'); ?>
                                            <div class="form-group">
                                                <label>Current password</label>
                                                <input class="form-control" type="password" name="current_password">
                                                <?= form_error('password'); ?>
                                            </div>
                                            <div class="form-group">
                                                <label>New password</label>
                                                <input class="form-control" type="password" name="new_password">
                                                <?= form_error('new_password'); ?>
                                            </div>
                                            <div class="form-group">
                                                <label>Confirm new password</label>
                                                <input class="form-control" type="password" name="confirm_password">
                                                <?= form_error('confirm_password'); ?>
                                            </div>
                                            <input type="hidden" name="post_type" value="password_change">
                                            <button class="btn btn-info" type="submit">Update password</button>
                                        <?= form_close(); ?>
                                    </div>
                                </div>
                                <div class="panel b">
                                    <div class="panel-heading bg-danger text-bold">Delete account</div>
                                    <div class="panel-body bt">
                                        <p>You will be asked for confirmation before delete account.</p>
                                        <button class="btn btn-default" type="button">
                                            <span class="text-danger">Delete account</span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tabSetting3">
                                <?= form_open('dashboard/profile_setting', 'role="form"'); ?>

                                    <div class="panel b">
                                        <div class="panel-heading bg-gray-lighter text-bold">Notifications</div>
                                        <div class="panel-body bb">
                                            <div class="form-group">
                                                <div class="checkbox">
                                                    <label>
                                                        <input type="checkbox" name="email_notif" <?php if( $user->email_notif == 1) echo 'checked'; ?> >&nbsp;
                                                        <strong>Enable/Disable email notifications</strong>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="panel-body">
                                            <p>
                                                <strong>Interaction</strong>
                                            </p>
                                            <div class="form-group">
                                                <div class="checkbox">
                                                    <label>
                                                        <input type="checkbox" name="recurring_notif" <?php if($user->recurring_notif == 1) echo 'checked'; ?> >&nbsp;
                                                        Alert me when I've low balance for recurring charges
                                                    </label>
                                                </div>
                                            </div>
                                            <input type="hidden" name="post_type" value="notification">
                                            <button class="btn btn-info" type="submit">Update notifications</button>
                                            <p>
                                                <small class="text-muted">Please be informed that <?= lang('app_name'); ?> understands how valuable your privacy is, and for this reasons we will not spam you.</small>
                                            </p>
                                        </div>
                                    </div>
                                <?= form_close(); ?>
                            </div>
                            <div class="tab-pane" id="tabSetting4">
                                <div class="panel b">
                                    <div class="panel-heading bg-gray-lighter text-bold">Applications</div>
                                    <div class="panel-body">
                                        <div class="alert alert-danger">
                                            <p>Coming Soon For Developers</p>
                                        </div>
<!--                                        <p>-->
<!--                                            <span>You have granted access for</span>-->
<!--                                            <strong>3 applications</strong>-->
<!--                                            <span>to your account.</span>-->
<!--                                        </p>-->
<!--                                        <ul class="list-group">-->
<!--                                            <li class="list-group-item clearfix">-->
<!--                                                <div class="pull-left mr">-->
<!--                                                    <img class="img-responsive thumb48" src="img/dummy.png" alt="App">-->
<!--                                                </div>-->
<!--                                                <div class="pull-right">-->
<!--                                                    <button class="btn btn-default" type="button">-->
<!--                                                        <strong>Revoke</strong>-->
<!--                                                    </button>-->
<!--                                                </div>-->
<!--                                                <p class="text-bold mb0">Application #1</p>-->
<!--                                                <small>Ut turpis urna, tristique sed adipiscing nec, luctus quis leo.</small>-->
<!--                                            </li>-->
<!--                                            <li class="list-group-item clearfix">-->
<!--                                                <div class="pull-left mr">-->
<!--                                                    <img class="img-responsive thumb48" src="img/dummy.png" alt="App">-->
<!--                                                </div>-->
<!--                                                <div class="pull-right">-->
<!--                                                    <button class="btn btn-default" type="button">-->
<!--                                                        <strong>Revoke</strong>-->
<!--                                                    </button>-->
<!--                                                </div>-->
<!--                                                <p class="text-bold mb0">Application #2</p>-->
<!--                                                <small>Ut turpis urna, tristique sed adipiscing nec, luctus quis leo.</small>-->
<!--                                            </li>-->
<!--                                            <li class="list-group-item clearfix">-->
<!--                                                <div class="pull-left mr">-->
<!--                                                    <img class="img-responsive thumb48" src="img/dummy.png" alt="App">-->
<!--                                                </div>-->
<!--                                                <div class="pull-right">-->
<!--                                                    <button class="btn btn-default" type="button">-->
<!--                                                        <strong>Revoke</strong>-->
<!--                                                    </button>-->
<!--                                                </div>-->
<!--                                                <p class="text-bold mb0">Application #3</p>-->
<!--                                                <small>Ut turpis urna, tristique sed adipiscing nec, luctus quis leo.</small>-->
<!--                                            </li>-->
<!--                                        </ul>-->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Page footer-->
    <footer>
        <span><?= lang('copyright'); ?></span>
    </footer>
</div>
<?php $this->load->view('app/resources/script');?>
</body>
</html>