<?php $this->load->view('app/resources/meta'); ?>
<style>
    /*Now the CSS*/
    * {margin: 0; padding: 0;}

    .tree ul {
        padding-top: 20px; position: relative;

        transition: all 0.5s;
        -webkit-transition: all 0.5s;
        -moz-transition: all 0.5s;
    }

    .tree li {
        float: left; text-align: center;
        list-style-type: none;
        position: relative;
        padding: 20px 5px 0 5px;

        transition: all 0.5s;
        -webkit-transition: all 0.5s;
        -moz-transition: all 0.5s;
    }

    /*We will use ::before and ::after to draw the connectors*/

    .tree li::before, .tree li::after{
        content: '';
        position: absolute; top: 0; right: 50%;
        border-top: 1px solid #ccc;
        width: 50%; height: 20px;
    }
    .tree li::after{
        right: auto; left: 50%;
        border-left: 1px solid #ccc;
    }

    /*We need to remove left-right connectors from elements without
    any siblings*/
    .tree li:only-child::after, .tree li:only-child::before {
        display: none;
    }

    /*Remove space from the top of single children*/
    .tree li:only-child{ padding-top: 0;}

    /*Remove left connector from first child and
    right connector from last child*/
    .tree li:first-child::before, .tree li:last-child::after{
        border: 0 none;
    }
    /*Adding back the vertical connector to the last nodes*/
    .tree li:last-child::before{
        border-right: 1px solid #ccc;
        border-radius: 0 5px 0 0;
        -webkit-border-radius: 0 5px 0 0;
        -moz-border-radius: 0 5px 0 0;
    }
    .tree li:first-child::after{
        border-radius: 5px 0 0 0;
        -webkit-border-radius: 5px 0 0 0;
        -moz-border-radius: 5px 0 0 0;
    }

    /*Time to add downward connectors from parents*/
    .tree ul ul::before{
        content: '';
        position: absolute; top: 0; left: 50%;
        border-left: 1px solid #ccc;
        width: 0; height: 20px;
    }

    .tree li a{
        border: 1px solid #ccc;
        padding: 5px 10px;
        text-decoration: none;
        color: #666;
        font-family: arial, verdana, tahoma;
        font-size: 11px;
        display: inline-block;

        border-radius: 5px;
        -webkit-border-radius: 5px;
        -moz-border-radius: 5px;

        transition: all 0.5s;
        -webkit-transition: all 0.5s;
        -moz-transition: all 0.5s;
    }

    /*Time for some hover effects*/
    /*We will apply the hover effect the the lineage of the element also*/
    .tree li a:hover, .tree li a:hover+ul li a {
        background: #c8e4f8; color: #000; border: 1px solid #94a0b4;
    }
    /*Connector styles on hover*/
    .tree li a:hover+ul li::after,
    .tree li a:hover+ul li::before,
    .tree li a:hover+ul::before,
    .tree li a:hover+ul ul::before{
        border-color:  #94a0b4;
    }
</style>
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">
                    <div class="col-md-12">
                        <!-- Chart Box-->
                        <?php $this->load->view('msg_view'); ?>
                        <div class="mb-3 card">
                            <div class="card-header">
                                Referral Commission Plan
                            </div>
                            <div class="card-body">
                                <?php $this->load->view('confirm_upgrade'); ?>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th rowspan="2">LEVELS</th>
                                                <th colspan="7" class="text-center">
                                                    REFERAL BONUSES IN PERCENTAGE
                                                </th>
                                            </tr>
                                            <tr>
                                                <th>
                                                    DIRECT REFERAL
                                                </th>
                                                <th>
                                                    2ND GENERATION
                                                </th>
                                                <th>
                                                    3RD GENERATION
                                                </th>
                                                <th>
                                                    4TH GENERATION
                                                </th>
                                                <th>
                                                    5TH GENERATION
                                                </th>
                                                <th>
                                                    UPGRADE PRICE(N)
                                                </th>
                                                <th>
                                                    UPGRADE
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td class="text-center">DIAMOND</td>
                                                <td class="text-center">25%</td>
                                                <td class="text-center">7%</td>
                                                <td class="text-center">5%</td>
                                                <td class="text-center">2%</td>
                                                <td class="text-center">1%</td>
                                                <td class="text-center"><?= ngn(10000); ?></td>
                                                <?php if( $user->membership_type == 'diamond') : ?>
                                                    <td class="text-center"><button class="btn btn-sm btn-success">You're Here</button></td>
                                                <?php else : ?>
                                                    <td class="text-center"><button class="btn btn-sm btn-danger upgrade" data-type="Diamond"
                                                                                    data-amount="10000">Upgrade</button></td>
                                                <?php endif; ?>
                                            </tr>
                                            <tr>
                                                <td class="text-center">GOLD</td>
                                                <td class="text-center">20%</td>
                                                <td class="text-center">7%</td>
                                                <td class="text-center">5%</td>
                                                <td class="text-center">2%</td>
                                                <td class="text-center">-</td>
                                                <td class="text-center"><?= ngn(5000); ?></td>
                                                <?php if( $user->membership_type == 'gold') :  ?>
                                                    <td class="text-center"><button class="btn btn-sm btn-success">You're Here</button></td>
                                                <?php else: ?>
                                                    <td class="text-center"><button class="btn btn-sm btn-danger <?php if(!in_array( $user->membership_type, array('diamond'))) echo 'upgrade'; ?>"
                                                                                    data-type="Gold"
                                                                                    data-amount="5000"
                                                        >Upgrade</button></td>
                                                <?php endif; ?>
                                            </tr>
                                            <tr>
                                                <td class="text-center">SILVER</td>
                                                <td class="text-center">15%</td>
                                                <td class="text-center">7%</td>
                                                <td class="text-center">5%</td>
                                                <td class="text-center">-</td>
                                                <td class="text-center">-</td>
                                                <td class="text-center"><?= ngn(2000); ?></td>
                                                <?php if( $user->membership_type == 'silver') :  ?>
                                                    <td class="text-center"><button class="btn btn-sm btn-success">You're Here</button></td>
                                                <?php else: ?>

                                                    <td class="text-center">
                                                        <button class="btn btn-sm btn-danger <?php if(!in_array( $user->membership_type, array('gold,diamond'))) echo 'upgrade'; ?>"
                                                                                    data-type="Silver"
                                                                                    data-amount="2000"
                                                        >Upgrade</button>
                                                    </td>
                                                <?php endif; ?>
                                            </tr>
                                            <tr>
                                                <td class="text-center">BRONZE</td>
                                                <td class="text-center">10%</td>
                                                <td class="text-center">-</td>
                                                <td class="text-center">-</td>
                                                <td class="text-center">-</td>
                                                <td class="text-center">-</td>
                                                <td class="text-center"></td>
                                                <?php if( $user->membership_type == 'bronze') :  ?>
                                                    <td class="text-center"><button class="btn btn-sm btn-success">You're Here</button></td>
                                                <?php else : ?>
                                                    <td class="text-center">
                                                        <button class="btn btn-sm btn-danger">FREE</button>
                                                    </td>
                                                <?php endif; ?>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="mt-2 px-4">
                                <p>Enjoy this benefit by sharing your referral link</p>
                                <a target="_blank" href="http://www.facebook.com/sharer.php?u=<?= base_url().'page/create/?ref='.$user->user_code;?>" class="btn btn-circle btn-secondary"><i class="fab fa-facebook-f"></i></a>
                                <a target="_blank" href="https://twitter.com/share?url=<?= base_url().'page/create/?ref='.$user->user_code;?>&amp;text=VTU+airtime+,+Reseller+data+plans+for+all+network+Visit&amp;hashtags=Payscribe.ng" class="btn btn-circle btn-secondary"><i class="fab fa-twitter"></i></a>
                                <a target="_blank" href="whatsapp://send?text=Buy Airtime and Data for MTN, Glo, Etisalat, Airtel. Make payment for DSTV, GOTV, PHCN other services. Visit <?= base_url().'page/create/?ref='.$user->user_code;?>" class="btn btn-circle btn-secondary"><i class="fab fa-whatsapp"></i></a>
                                <a target="_blank" href="tg://msg_url?url=<?= base_url().'page/create/?ref='.$user->user_code;?>&text=VTU+airtime+,+Reseller+data+plans+for+all+network++Visit+<?= base_url().'page/create/?ref='.$user->user_code;?>" class="btn btn-circle btn-secondary"><i class="fab fa-telegram"></i></a>
                                &nbsp;&nbsp;&nbsp;<a href="<?= base_url('page/create/?ref=' . $user->user_code); ?>"></a>
                                <form>
                                    <div class="form-group">
                                        <label for="referral_link">Referral Link</label>
                                        <input type="text" id="referral" class="form-control" value="<?= base_url('page/create/?ref=' . $user->user_code); ?>">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 mt-2">
                        <div class="main-card mb-3 card">
                            <div class="card-header">Referral Tree</div>

                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-1"></div>
                                    <div class="col-md-10 col-auto">
                                        <div class="tree">
                                            <ul>
                                                <li>
                                                    <a href="#"><?= ucwords($user->name)?> (Me)</a>
                                                    <ul>
                                                        <?php if( $downlines ) : foreach( $downlines as $downline ) : ?>
                                                            <li>
                                                                <a href="#"><?= ucwords($downline->name); ?></a>
                                                                <ul>
                                                                    <ul>
                                                                        <?php
                                                                            // Second Generation
                                                                            $second_generation = $this->site->my_downlines( $downline->user_code );
                                                                            if( $second_generation ): foreach ( $second_generation as $second ):
                                                                        ?>
                                                                        <li>
                                                                            <a href="#"><?= ucwords( $second->name); ?></a>
                                                                            <ul>
                                                                                <?php
                                                                                    // Third Generation
                                                                                    $third_generation = $this->site->my_downlines( $second->user_code );
                                                                                    if( $third_generation ): foreach ( $third_generation as $third ):
                                                                                ?>
                                                                                    <li>
                                                                                        <a href="#"><?= ucwords($third->name); ?></a>
                                                                                        <ul>
                                                                                            <?php
                                                                                            // Fourth Generation
                                                                                            $fourth_generation = $this->site->my_downlines( $third->user_code );
                                                                                            if( $fourth_generation ): foreach ( $fourth_generation as $fourth ):
                                                                                            ?>
                                                                                                <li>
                                                                                                    <a href="#"><?= ucwords( $fourth->name ); ?></a>
                                                                                                    <ul>
                                                                                                        <?php
                                                                                                        // Fourth Generation
                                                                                                        $fifth_generation = $this->site->my_downlines( $fourth->user_code );
                                                                                                        if( $fifth_generation ): foreach ( $fifth_generation as $fifth ):
                                                                                                        ?>
                                                                                                            <li>
                                                                                                                <a href="#"><?= ucwords($fifth->name); ?></a>
                                                                                                            </li>
                                                                                                        <?php endforeach; endif; ?>
                                                                                                    </ul>
                                                                                                </li>
                                                                                            <?php endforeach; endif; ?>
                                                                                        </ul>
                                                                                    </li>
                                                                                <?php endforeach; endif; ?>
                                                                            </ul>
                                                                        </li>
                                                                        <?php endforeach; endif; ?>
                                                                    </ul>
                                                                </ul>
                                                            </li>
                                                        <?php endforeach; else: ?>
                                                            <li>
                                                                <a href="#">You don't have any downline yet</a>
                                                                <ul>
                                                                    <ul>
                                                                        <li>
                                                                            <a href="#">No Downline</a>
                                                                            <ul>
                                                                                <li>
                                                                                    <a href="#">No downline</a>
                                                                                </li>
                                                                                <li>
                                                                                    <a href="#">No downline</a>
                                                                                </li>
                                                                            </ul>
                                                                        </li>
                                                                        <li>
                                                                            <a href="#">No downline</a>
                                                                        </li>
                                                                    </ul>
                                                                </ul>
                                                            </li>
                                                        <?php endif; ?>
                                                    </ul>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="col-md-1"></div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
</body>
</html>
