<?php
$this->load->view('app/resources/meta');
?>
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div id="panel-body" class="panel-body">
                    <img src="<?= base_url('assets/567_logo.png'); ?>" alt="567 Services" />
                    <h3 class="mt0">Invoice <?= $transaction->trans_id?></h3>
                    <hr>
                    <div class="row mb-lg">
                        <div class="col-lg-4 col-xs-6 br pv">
                            <div class="row">
                                <div class="col-md-10">
                                    <h4><?= ucwords($user->name);?></h4>
                                    <address><?= $user->email; ?></address>
                                </div>
                            </div>
                        </div>

                        <div class="clearfix hidden-md hidden-lg">
                            <hr>
                        </div>
                        <div class="col-lg-4 col-xs-12 pv">
                            <div class="clearfix">
                                <p class="pull-left"><strong>INVOICE NO.</strong></p>
                                <p class=""><?= $transaction->trans_id?></p>
                            </div>
                            <div class="clearfix">
                                <p class="pull-left"><strong>Date</strong></p>
                                <p class=""><?= neatDate( $transaction->date_initiated); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-4 col-xs-12 pv">
                            <div class="clearfix">
                                <p class="pull-left"><strong>Status</strong></p>
                                <p class="pull-right"><b><?= statusLabel($transaction->status); ?></b></p>
                            </div>
                        </div>


                    </div>
                    <div class="table-responsive table-bordered mb-lg">
                        <table class="table">
                            <thead>
                            <tr>
                                <th>Description</th>
                                <th>Unit Price</th>
                                <th class="text-right">Total</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td><?= $transaction->description; ?>
                                    <?php if(!empty($transaction->details)) :  
                                        $details = json_decode( $transaction->details);
                                        foreach($details as $k => $v ) :?>
                                        <span><strong><?=$k?></strong>: <?=$v?></span><br/>
                                    <?php endforeach; endif;?>
                                
                                </td>
                                <td><?= ngn($transaction->amount)?></td>
                                <td class="text-right"><?= ngn($transaction->amount)?></td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <hr class="hidden-print">
                    <div class="clearfix">
                        <button class="btn btn-primary pull-right" type="button" onclick="print()" >PRINT</button>

                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>

<?php $this->load->view('app/resources/script');?>
<script>
    function print(){
        let content = document.getElementById("panel-body").innerHTML;

        let a = window.open('', '', 'height="100%", width="100%"');
        a.document.write(`<html><body>${content}</body></html>`)
        a.document.close();
        a.print();
    }
</script>
</body>
</html>