<?php $this->load->view('app/resources/meta'); ?>
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">
                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-header">Pay Electricity Bill</div>
                            <?= form_open(''); ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-3"></div>
                                    <div class="col-md-6">
                                        <?php $this->load->view('msg_view'); ?>
                                        <div class="form-group">
                                            <label class="label" for="Network">Electricity</label>
                                            <select required class="form-control" id="network" name="network">
                                                <?php foreach ( $electricity as $plan ):?>
                                                    <?php $service_message = explode('|', $plan->message); ?>
                                                    <option <?php if( $service_message[0] == $electricity_channel ) echo 'selected'?>
                                                            value="<?= $service_message[0] .'|1'; ?>">
                                                        <?= ucwords($plan->title);?>
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>

                                            <?= form_error('electricity_name'); ?>
                                        </div>
                                        <div class="form-group">
                                            <label for="iuc-number">Meter Number</label>
                                            <input type="text" name="meter_number" value="<?= set_value('meter_number', $meter_number)?>"  class="form-control" required placeholder="Meter Number">
                                            <?= form_error('meter_number'); ?>
                                        </div>
                                        <div class="form-group">
                                            <label for="meter_type">Meter Type</label>
                                            <select class="form-control" name="meter_type" id="meter_type" required>
                                                <option value="" selected> -- Select Meter Type -- </option>
                                                <option value="prepaid" <?php if( $meter_type == 'prepaid') echo 'selected'; ?>>Prepaid</option>
                                                <option value="postpaid" <?php if( $meter_type == 'postpaid') echo 'selected'; ?>>Postpaid</option>
                                            </select>
                                            <?= form_error('meter_type'); ?>
                                        </div>

                                        <div class="form-group">
                                            <label for="registered-number">Phone Number</label>
                                            <input type="tel" name="phone_number" id="phone_number" value="<?=$user->phone?>"  class="form-control number" required placeholder="Phone Number">
                                        </div>

                                        <div class="form-group">
                                            <label for="registered_name">Amount</label>
                                            <input type="text" name="amount" id="amount" value="<?= $amount?>" readonly class="form-control number" required placeholder="How much will you like to pay?">
                                            <?= form_error('amount'); ?>
                                        </div>

                                        <div class="form-group">
                                            <label for="registered-number">Customer Name</label>
                                            <input type="text" name="customer_name" readonly value="<?= $customer_name;?>" id="customer_name" class="form-control" required >
                                        </div>

                                        <div class="form-group">
                                            <label for="registered-number">Customer Info</label>
                                            <input type="text" name="address" readonly value="<?= $address;?>" id="address" class="form-control" required >
                                        </div>
                                        <input type="hidden" name="product_code" id="product_code" value="<?= $product_code?>" />
                                    </div>
                                    <div class="col-md-3"></div>
                                </div>
                            </div>
                            <div class="d-block text-center card-footer">
                                <button class="btn-wide btn btn-success" type="submit">Pay Now</button>
                            </div>
                            <?= form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
</body>
</html>
