<?php
$this->load->view('app/resources/meta');
?>
</head>
<body>
<div class="wrapper">
    <!-- top navbar-->
    <header class="topnavbar-wrapper">
        <!-- START Top Navbar-->
        <nav class="navbar topnavbar" role="navigation">
            <!-- START navbar header-->
            <div class="navbar-header">
                <a class="navbar-brand" href="<?= base_url();?>">
                    <div class="brand-logo">
                        <img class="img-responsive" src="<?= base_url('assets/app/img/logo.png')?>" alt="App Logo">
                    </div>
                    <div class="brand-logo-collapsed">
                        <img class="img-responsive" src="<?= base_url('assets/app/img/logo-single.png')?>" alt="App Logo">
                    </div>
                </a>
            </div>
            <!-- END navbar header-->
            <!-- START Nav wrapper-->
            <div class="nav-wrapper">
                <!-- START Left navbar-->
                <ul class="nav navbar-nav">
                    <li>
                        <!-- Button used to collapse the left sidebar. Only visible on tablet and desktops-->
                        <a class="hidden-xs" href="#" data-trigger-resize="" data-toggle-state="aside-collapsed">
                            <em class="fas fa-bars"></em>
                        </a>
                        <!-- Button to show/hide the sidebar on mobile. Visible on mobile only.-->
                        <a class="visible-xs sidebar-toggle" href="#" data-toggle-state="aside-toggled" data-no-persist="true">
                            <em class="fas fa-bars"></em>
                        </a>
                    </li>
                </ul>
                <!-- END Left navbar-->
                <!-- START Right Navbar-->
                <ul class="nav navbar-nav navbar-right">
                    <!-- Fullscreen (only desktops)-->
                    <li class="visible-lg">
                        <a href="#" data-toggle-fullscreen="">
                            <em class="fas fa-expand"></em>
                        </a>
                    </li>
                </ul>
                <!-- END Right Navbar-->
            </div>
            <!-- END Nav wrapper-->
        </nav>
        <!-- END Top Navbar-->
    </header>
    <!-- sidebar-->
        <?php $this->load->view('app/resources/aside'); ?>
    <!-- Main section-->
    <section>
        <!-- Page content-->
        <div class="content-wrapper">
            <div class="content-heading">
                <!-- START Language list-->
                <div class="pull-right">
                    <div class="btn-group">
                        <button class="btn btn-default" type="button" data-toggle="dropdown">Wallet: <?=ngn($user->wallet);?></button>
                        <ul class="dropdown-menu dropdown-menu-right animated fadeInUpShort" role="menu">
                            <li>
                                <a href="<?= base_url('dashboard/wallet/')?>">Fund Wallet</a>
                            </li>
                            <li>
                                <a href="<?= base_url('dashboard/transactions/')?>">My Transactions</a>
                            </li>
                        </ul>
                    </div>
                </div>
                <!-- END Language list-->Dashboard
                <small data-localize="dashboard.DASHBOARD"></small>
            </div>
            <!-- START widgets box-->
            <div class="row">
                <div class="col-lg-3 col-sm-6">
                    <!-- START widget-->
                    <div class="panel widget bg-gray">
                        <div class="row row-table">
                            <div class="col-xs-4 text-center bg-gray-dark pv-lg">
                                <em class="fas fa-network-wired fa-3x"></em>
                            </div>
                            <div class="col-xs-8 pv-lg">
                                <a href="<?= base_url('dashboard/data/')?>" title="Buy Data" style="color: #3a3f51; text-decoration: none;">
                                    <div class="h2 mt0">Buy Data</div>
                                    <div class="text-uppercase">MTN, GLO, 9MOBILE, AIRTEL</div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-sm-6">
                    <!-- START widget-->
                    <div class="panel widget bg-gray">
                        <div class="row row-table">
                            <div class="col-xs-4 text-center bg-gray-dark pv-lg">
                                <em class="fas fa-sim-card fa-3x"></em>
                            </div>
                            <div class="col-xs-8 pv-lg">
                                <a href="<?= base_url('dashboard/airtime/')?>" title="Buy Airtime" style="color: #3a3f51; text-decoration: none;">
                                    <div class="h2 mt0">Buy Airtime</div>
                                    <div class="text-uppercase">MTN, GLO, 9MOBILE, AIRTEL</div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-sm-6">
                    <!-- START widget-->
                    <div class="panel widget bg-gray">
                        <div class="row row-table">
                            <div class="col-xs-4 text-center bg-gray-dark pv-lg">
                                <em class="fas fa-tv fa-3x"></em>
                            </div>
                            <div class="col-xs-8 pv-lg">
                                <a href="<?= base_url('dashboard/tv_subscription/')?>" title="Pay For TV Subscription" style="color: #3a3f51; text-decoration: none;">
                                    <div class="h2 mt0">Pay TV</div>
                                    <div class="text-uppercase">DSTV, GOTV, STARTIMES, SMILE</div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-sm-6">
                    <!-- START widget-->
                    <div class="panel widget bg-gray">
                        <div class="row row-table">
                            <div class="col-xs-4 text-center bg-gray-dark pv-lg">
                                <em class="fas fa-lightbulb fa-3x"></em>
                            </div>
                            <div class="col-xs-8 pv-lg">
                                <a href="<?= base_url('dashboard/electricity/')?>" title="Pay Electricity Bills" style="color: #3a3f51; text-decoration: none;">
                                    <div class="h2 mt0">Electricity</div>
                                    <div class="text-uppercase">EKDC, ENUGU, IKEJA ELECTRICITY...</div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Second row -->
            <div class="row">

                <div class="col-lg-3 col-sm-6">
                    <!-- START widget-->
                    <div class="panel widget bg-gray">
                        <div class="row row-table">
                            <div class="col-xs-4 text-center bg-gray-dark pv-lg">
                                <em class="fas fa-network-wired fa-3x"></em>
                            </div>
                            <div class="col-xs-8 pv-lg">
                                <div class="h2 mt0">Subscription</div>
                                <div class="text-uppercase">Internet Subscription</div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-sm-6">
                    <!-- START widget-->
                    <div class="panel widget bg-gray">
                        <div class="row row-table">
                            <div class="col-xs-4 text-center bg-gray-dark pv-lg">
                                <em class="fas fa-sim-card fa-3x"></em>
                            </div>
                            <div class="col-xs-8 pv-lg">
                                <div class="h2 mt0">Scratch Card</div>
                                <div class="text-uppercase">Waec,Neco</div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-sm-6">
                    <!-- START widget-->
                    <div class="panel widget bg-gray">
                        <div class="row row-table">
                            <div class="col-xs-4 text-center bg-gray-dark pv-lg">
                                <em class="fas fa-sms fa-3x"></em>
                            </div>
                            <div class="col-xs-8 pv-lg">
                                <div class="h2 mt0">SMS</div>
                                <div class="text-uppercase">Send Bulk SMS</div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-sm-6">
                    <!-- START widget-->
                    <div class="panel widget bg-gray">
                        <div class="row row-table">
                            <div class="col-xs-4 text-center bg-gray-dark pv-lg">
                                <em class="fas fa-money-bill-alt fa-3x"></em>
                            </div>
                            <div class="col-xs-8 pv-lg">
                                <div class="h2 mt0">Funds</div>
                                <div class="text-uppercase">Transfer Money</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
    <!-- Page footer-->
    <footer>
        <span><?= lang('copyright'); ?></span>
    </footer>
</div>
<?php $this->load->view('app/resources/script');?>
</body>
</html>