<?php $this->load->view('app/resources/meta'); ?>
<style>
    /*Now the CSS*/
    * {margin: 0; padding: 0;}

    .tree ul {
        padding-top: 20px; position: relative;

        transition: all 0.5s;
        -webkit-transition: all 0.5s;
        -moz-transition: all 0.5s;
    }

    .tree li {
        float: left; text-align: center;
        list-style-type: none;
        position: relative;
        padding: 20px 5px 0 5px;

        transition: all 0.5s;
        -webkit-transition: all 0.5s;
        -moz-transition: all 0.5s;
    }

    /*We will use ::before and ::after to draw the connectors*/

    .tree li::before, .tree li::after{
        content: '';
        position: absolute; top: 0; right: 50%;
        border-top: 1px solid #ccc;
        width: 50%; height: 20px;
    }
    .tree li::after{
        right: auto; left: 50%;
        border-left: 1px solid #ccc;
    }

    /*We need to remove left-right connectors from elements without
    any siblings*/
    .tree li:only-child::after, .tree li:only-child::before {
        display: none;
    }

    /*Remove space from the top of single children*/
    .tree li:only-child{ padding-top: 0;}

    /*Remove left connector from first child and
    right connector from last child*/
    .tree li:first-child::before, .tree li:last-child::after{
        border: 0 none;
    }
    /*Adding back the vertical connector to the last nodes*/
    .tree li:last-child::before{
        border-right: 1px solid #ccc;
        border-radius: 0 5px 0 0;
        -webkit-border-radius: 0 5px 0 0;
        -moz-border-radius: 0 5px 0 0;
    }
    .tree li:first-child::after{
        border-radius: 5px 0 0 0;
        -webkit-border-radius: 5px 0 0 0;
        -moz-border-radius: 5px 0 0 0;
    }

    /*Time to add downward connectors from parents*/
    .tree ul ul::before{
        content: '';
        position: absolute; top: 0; left: 50%;
        border-left: 1px solid #ccc;
        width: 0; height: 20px;
    }

    .tree li a{
        border: 1px solid #ccc;
        padding: 5px 10px;
        text-decoration: none;
        color: #666;
        font-family: arial, verdana, tahoma;
        font-size: 11px;
        display: inline-block;

        border-radius: 5px;
        -webkit-border-radius: 5px;
        -moz-border-radius: 5px;

        transition: all 0.5s;
        -webkit-transition: all 0.5s;
        -moz-transition: all 0.5s;
    }

    /*Time for some hover effects*/
    /*We will apply the hover effect the the lineage of the element also*/
    .tree li a:hover, .tree li a:hover+ul li a {
        background: #c8e4f8; color: #000; border: 1px solid #94a0b4;
    }
    /*Connector styles on hover*/
    .tree li a:hover+ul li::after,
    .tree li a:hover+ul li::before,
    .tree li a:hover+ul::before,
    .tree li a:hover+ul ul::before{
        border-color:  #94a0b4;
    }
</style>
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">
                    <?php $this->load->view('confirm_upgrade'); ?>
                    <div class="col-sm-12">
                        <div class="alert alert-info">
                            <?php if($notifications) : ?>
                                <ul>
                                    <?php foreach ( $notifications as $notification ) :?>
                                        <li>
                                            <p>
                                                <?= $notification->message; ?><br />
                                                <small class="text-left text-danger">Posted On <?= neatDate($notification->date_posted) . ' ' . neatTime($notification->date_posted)?></small>
                                            </p>
                                        </li>
                                    <?php endforeach;?>
                                </ul>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="col-md-12 col-xl-12">
                        <div class="card mb-3">
                            <div class="card-header">
                                <h3>Your Info</h3>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <p>
                                            Your Level: <a href="<?= base_url('dashboard/wallet/'); ?>" ><?= ucwords($user->membership_type); ?> Level</a>
                                        </p>
                                        <p>
                                            Your Balance: <a href="<?= base_url('dashboard/wallet/'); ?>"> <?= ngn($user->wallet); ?></a>
                                        </p>
                                        <p>
                                            Referral Bonus: <a href="<?= base_url('dashboard/referrals/'); ?>"> <?= ngn($user->referral_bonus); ?></a>
                                        </p>
                                    </div>
                                    <div class="col-6">
                                        <div class="alert alert-info">

                                            <?php if( $user->providus == '' ) : ?>
                                                <p class="card-text">
                                                    <small class="text-info">Auto Funding Account Details: Send money to the account details below. - Instant Wallet Funding</small><br/>
                                                    <button class="btn btn-primary getMonnify">Generate Account Details</button>
                                                </p>
                                                <?php else :
                                                $providus = json_decode($user->providus, true);
                                                    if( is_array( $providus )) : 
                                                        foreach( $providus as $p ): ?>
                                                        <p class="card-text">
                                                            <small class="text-info">Auto Funding Account Details:</small><br/>
                                                            <b>Bank Name:</b> <?= @$providus['bankName']; ?><br />
                                                            <b>Account Name:</b> 567 Service <?= ucwords($user->name)?><br />
                                                            <b>Account Number:</b> <?= @$providus['accountNumber']; ?><br />
                                                        </p>
                                                <?php endforeach; else :   ?>
                                                    <p class="card-text">
                                                        <small class="text-info">Auto Funding Account Details:</small><br/>
                                                        <b>Bank Name:</b> <?= @$providus->bankName; ?><br />
                                                        <b>Account Name:</b> <?= @$providus->acctName; ?><br />
                                                        <b>Account Number:</b> <?= @$providus->accountNumber; ?><br />
                                                    </p>
                                                <?php   endif; endif;?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-xl-4">
                        <div class="card mb-3 widget-content">
                            <div class="widget-content-outer">
                                <div class="widget-content-wrapper">
                                    <div class="widget-content-left">
                                        <div class="widget-heading">Buy Airtime</div>
                                        <div class="widget-subheading"><?= anchor('dashboard/airtime/','GLO, MTN,AIRTEL,9MOBILE')?></div>
                                    </div>
                                    <div class="widget-content-right">
                                        <div class="widget-numbers text-success"><i class="fas fa-sd-card"></i></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-xl-4">
                        <div class="card mb-3 widget-content">
                            <div class="widget-content-outer">
                                <div class="widget-content-wrapper">
                                    <div class="widget-content-left">
                                        <div class="widget-heading">Buy Data</div>
                                        <div class="widget-subheading"><?= anchor('dashboard/data/','GLO, MTN,AIRTEL,9MOBILE')?></div>
                                    </div>
                                    <div class="widget-content-right">
                                        <div class="widget-numbers text-warning"><i class="fas fa-network-wired"></i></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-xl-4">
                        <div class="card mb-3 widget-content">
                            <div class="widget-content-outer">
                                <div class="widget-content-wrapper">
                                    <div class="widget-content-left">
                                        <div class="widget-heading">Pay Cable TV</div>
                                        <div class="widget-subheading"><?= anchor('dashboard/verify_tv/', 'GOTV, DSTV'); ?></div>
                                    </div>
                                    <div class="widget-content-right">
                                        <div class="widget-numbers text-danger"><i class="fas fa-tv"></i></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-xl-4">
                        <div class="card mb-3 widget-content">
                            <div class="widget-content-outer">
                                <div class="widget-content-wrapper">
                                    <div class="widget-content-left">
                                        <div class="widget-heading">Electricity Bills</div>
                                        <div class="widget-subheading"><?= anchor('dashboard/verify_meter/', 'PHED, IE, EEDC ...'); ?></div>
                                    </div>
                                    <div class="widget-content-right">
                                        <div class="widget-numbers text-danger"><i class="fas fa-lightbulb"></i></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 col-xl-4">
                        <div class="card mb-3 widget-content">
                            <div class="widget-content-outer">
                                <div class="widget-content-wrapper">
                                    <div class="widget-content-left">
                                        <div class="widget-heading">Fund Your Wallet</div>
                                        <div class="widget-subheading"><?= anchor('dashboard/wallet/', 'To Start Vending')?></div>
                                    </div>
                                    <div class="widget-content-right">
                                        <div class="widget-numbers text-warning"><i class="fas fa-money-check"></i></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 col-xl-4">
                        <div class="card mb-3 widget-content">
                            <div class="widget-content-outer">
                                <div class="widget-content-wrapper">
                                    <div class="widget-content-left">
                                        <div class="widget-heading">Your Referrals/ Downlines</div>
                                        <div class="widget-subheading"><?= anchor('dashboard/referrals/', 'See Your Downlines & Earnings')?></div>
                                    </div>
                                    <div class="widget-content-right">
                                        <div class="widget-numbers text-info"><i class="fas fa-users"></i></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">

                    <div class="col-md-12 mt-2">
                        <div class="main-card mb-3 card">
                            <div class="card-header">Referral Tree</div>

                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-1"></div>
                                    <div class="col-md-10 col-auto">
                                        <div class="tree">
                                            <ul>
                                                <li>
                                                    <a href="#"><?= ucwords($user->name)?> (Me)</a>
                                                    <ul>
                                                        <?php if( $downlines ) : foreach( $downlines as $downline ) : ?>
                                                            <li>
                                                                <a href="#"><?= ucwords($downline->name); ?></a>
                                                                <ul>
                                                                    <ul>
                                                                        <?php
                                                                        // Second Generation
                                                                        $second_generation = $this->site->my_downlines( $downline->user_code );
                                                                        if( $second_generation ): foreach ( $second_generation as $second ):
                                                                            ?>
                                                                            <li>
                                                                                <a href="#"><?= ucwords( $second->name); ?></a>
                                                                                <ul>
                                                                                    <?php
                                                                                    // Third Generation
                                                                                    $third_generation = $this->site->my_downlines( $second->user_code );
                                                                                    if( $third_generation ): foreach ( $third_generation as $third ):
                                                                                        ?>
                                                                                        <li>
                                                                                            <a href="#"><?= ucwords($third->name); ?></a>
                                                                                            <ul>
                                                                                                <?php
                                                                                                // Fourth Generation
                                                                                                $fourth_generation = $this->site->my_downlines( $third->user_code );
                                                                                                if( $fourth_generation ): foreach ( $fourth_generation as $fourth ):
                                                                                                    ?>
                                                                                                    <li>
                                                                                                        <a href="#"><?= ucwords( $fourth->name ); ?></a>
                                                                                                        <ul>
                                                                                                            <?php
                                                                                                            // Fourth Generation
                                                                                                            $fifth_generation = $this->site->my_downlines( $fourth->user_code );
                                                                                                            if( $fifth_generation ): foreach ( $fifth_generation as $fifth ):
                                                                                                                ?>
                                                                                                                <li>
                                                                                                                    <a href="#"><?= ucwords($fifth->name); ?></a>
                                                                                                                </li>
                                                                                                            <?php endforeach; endif; ?>
                                                                                                        </ul>
                                                                                                    </li>
                                                                                                <?php endforeach; endif; ?>
                                                                                            </ul>
                                                                                        </li>
                                                                                    <?php endforeach; endif; ?>
                                                                                </ul>
                                                                            </li>
                                                                        <?php endforeach; endif; ?>
                                                                    </ul>
                                                                </ul>
                                                            </li>
                                                        <?php endforeach; else: ?>
                                                            <li>
                                                                <a href="#">You don't have any downline yet</a>
                                                                <ul>
                                                                    <ul>
                                                                        <li>
                                                                            <a href="#">No Downline</a>
                                                                            <ul>
                                                                                <li>
                                                                                    <a href="#">No downline</a>
                                                                                </li>
                                                                                <li>
                                                                                    <a href="#">No downline</a>
                                                                                </li>
                                                                            </ul>
                                                                        </li>
                                                                        <li>
                                                                            <a href="#">No downline</a>
                                                                        </li>
                                                                    </ul>
                                                                </ul>
                                                            </li>
                                                        <?php endif; ?>
                                                    </ul>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="col-md-1"></div>
                                </div>
                            </div>

                        </div>
                    </div>


                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-header">10 Recent Transactions
                            </div>
                            <div class="table-responsive">
                                <table class="table align-middle mb-0 table table-borderless table-striped table-hover">
                                    <thead>
                                    <tr>
                                        <th class="text-center">#</th>
                                        <th>Description</th>
                                        <th class="text-center">Amount</th>
                                        <th class="text-center">Status</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        if( $transactions) :
                                            foreach( $transactions as $transaction ):
                                        ?>
                                            <tr>
                                                <td class="text-center text-muted">
                                                    <a href="<?= base_url('dashboard/invoice/' . $transaction->trans_id); ?>">
                                                        #<?= $transaction->trans_id?>
                                                    </a>
                                                </td>
                                                <td>
                                                    <?= $transaction->description; ?>
                                                </td>
                                                <td class="text-center"><?= ngn($transaction->amount); ?></td>
                                                <td class="text-center">
                                                    <?= statusLabel($transaction->status ); ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; else:?>
                                            <tr>
                                                <td rowspan="4" class="text-center">No Transaction In The System</td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                                <?php if( $transactions) : ?>
                                <div class="d-block text-center card-footer">
                                    <?= anchor('dashboard/transactions/', 'View More Transactions', 'class="btn-wide btn btn-success"'); ?>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
</body>
</html>
