<?php
$this->load->view('app/resources/meta');
?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">
</head>
<body>
<div class="wrapper">
    <!-- top navbar-->
    <?php $this->load->view('app/resources/header'); ?>
    <!-- sidebar-->
        <?php $this->load->view('app/resources/aside'); ?>
    <!-- Main section-->
    <section>
        <!-- Page content-->
        <div class="content-wrapper">
            <div class="content-heading">
                <!-- START Language list-->
                <div class="pull-right">
                    <div class="btn-group">
                        <button class="btn btn-default" type="button" data-toggle="dropdown">Wallet: <?=ngn($user->wallet);?></button>
                        <ul class="dropdown-menu dropdown-menu-right animated fadeInUpShort" role="menu">
                            <li>
                                <a href="<?= base_url('dashboard/wallet/')?>">Fund Wallet</a>
                            </li>
                            <li>
                                <a href="<?= base_url('dashboard/transactions/')?>">My Transactions</a>
                            </li>
                        </ul>
                    </div>
                </div>
                <!-- END Language list-->Contacts
                <small data-localize="dashboard.CONTACTS"></small>
            </div>
            <!-- START widgets box-->

            <div class="row">
                <div class="col-md-12">
                    <div class="panel panel-default" style="padding: 20px;">
                        <div class="panel-heading">
                            List of your saved contact,
                        </div>
                        <div class="panel-body">
                            <div class="py-7" style="padding-top: 40px;">
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">

                                    <thead>
                                    <tr>
                                        <th style="display: none;">ID</th>
                                        <th>S/N</th>
                                        <th>Name</th>
                                        <th>Phone Number</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $x =1; foreach($contacts as $contact ) : ?>
                                        <tr>
                                            <td style="display: none;"><?= $contact->id; ?></td>
                                            <td><?= $x; ?></td>
                                            <td><?= ucwords($contact->name); ?></td>
                                            <td><?= $contact->phone?></td>
                                            <td>
                                                <a class="btn btn-sm btn-success" href="<?= base_url('dashboard/airtime/?msisdn='.$contact->phone)?>">Buy Airtime</a> |
                                                <a class="btn btn-sm btn-info" href="<?= base_url('dashboard/data/?msisdn='.$contact->phone)?>">Buy Data</a> |
                                                <button class="btn btn-sm btn-danger del-contact" data-id="<?= $contact->id; ?>">Delete Contact</button>
                                            </td>
                                        </tr>
                                    <?php $x++; endforeach;?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
    <!-- Page footer-->
    <footer>
        <span><?= lang('copyright'); ?></span>
    </footer>
</div>
<?php $this->load->view('app/resources/script');?>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>

</body>
</html>