<?php $this->load->view('app/resources/meta'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header fixed-footer">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">
                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-header">Confirm Upgrade Payment</div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-3"></div>
                                    <div class="col-md-6">
                                        <?php $this->load->view('msg_view'); ?>
                                        <?= form_open_multipart( base_url('dashboard/confirm_upgrade/') , 'role="form"'); ?>
                                        <div class="form-group">
                                            <label for="Deposit Amount">Amount To Pay</label>
                                            <input type="text" name="amount" id="amount" readonly class="form-control number" value="<?= set_value('amount', $row->amount)?>" required >
                                        </div>
                                        <div class="form-group" id="bank-details">
                                            <label for="bank-details">Please select bank</label>
                                            <select name="bank" id="bank" class="form-control" required>
                                                <option value="" selected>--Please select the bank you paid into--</option>
                                                <?php
                                                $banks = explode('|', lang('company_banks'));
                                                foreach ( $banks as $bank ) :
                                                    ?>
                                                    <option value="<?= $bank; ?>" <?= set_select('bank', $bank ); ?> ><?= $bank; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="pop">Screenshot</label>
                                            <input type="file" name="pop" required accept="image/*">
                                        </div>
                                        <div class="form-group">
                                            <label for="comment">Comment</label>
                                            <textarea name="remark" required class="form-control" placeholder="Payment remark/comment."><?= set_value('comment',''); ?></textarea>
                                        </div>
                                        <input type="hidden" name="tid" value="<?=$row->id;?>">
                                        <input type="hidden" name="membership_type" value="<?= $row->type; ?>" />
                                        <button class="btn btn-sm btn-success mr-2 mb" type="submit">SUBMIT</button>
                                        <a href="<?= base_url('dashboard/referral/')?>" class="btn btn-sm btn-danger mr-2 mb">CANCEL</a>
                                        <?= form_close(); ?>
                                    </div>
                                    <div class="col-md-3"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
</body>
</html>
