<?php
$this->load->view('app/resources/meta');
?>
</head>
<body>
<div class="wrapper">
    <!-- top navbar-->
    <?php $this->load->view('app/resources/header'); ?>
    <!-- sidebar-->
        <?php $this->load->view('app/resources/aside'); ?>
    <!-- Main section-->
    <section>
        <!-- Page content-->
        <div class="content-wrapper">
            <div class="content-heading">
                <!-- START Language list-->
                <div class="pull-right">
                    <div class="btn-group">
                        <button class="btn btn-default" type="button" data-toggle="dropdown">Wallet: <?=ngn($user->wallet);?></button>
                        <ul class="dropdown-menu dropdown-menu-right animated fadeInUpShort" role="menu">
                            <li>
                                <a href="<?= base_url('dashboard/wallet/')?>">Fund Wallet</a>
                            </li>
                            <li>
                                <a href="<?= base_url('dashboard/transactions/')?>">My Transactions</a>
                            </li>
                        </ul>
                    </div>
                </div>
                <!-- END Language list-->Airtime To Wallet
                <small data-localize="dashboard.AIRTIME_TO_WALLET"></small>
            </div>
            <!-- START widgets box-->

            <div class="row">
                <div class="col-md-6 col-md-offset-3">
                    <div class="panel panel-default" style="padding: 20px;">

                        <div class="panel-heading">
                            Airtime To Wallet
                            <?php if( empty($row) ) : ?>
                                <div class="pull-right text-center text-danger">
                                    <img id="service-img" class="img-thumbnail img-circle img-responsive thumb48" src="<?= base_url('assets/img/payscribe-logo-single.png')?>" alt="Payscribe">
                                </div>
                            <?php endif;?>
                        </div>
                        <div class="panel-body">
                            <?php $this->load->view('msg_view'); ?>
                            <?php if( $row && !empty($row) ) : ?>
                                <div class="col-12 alert alert-info">
                                    <p><?= $row->details; ?></p>
                                </div>
                                <p>
                                    <b>Amount Initiated</b> : <?= ngn($row->incoming); ?>
                                </p>
                                <p>
                                    <b>Amount To Receive</b> : <?= ngn($row->outgoing); ?>
                                </p>
                                <p>
                                    <b>Network</b> : <?= strtoupper($row->network); ?>
                                </p>
                                <p>
                                    <b>Date Initiated</b> : <?= neatDate($row->datetime) . ' ' . neatTime($row->datetime); ?>
                                </p>
                                <p>
                                    <a class="btn btn-sm btn-primary btn-sm col-sm-4" href="<?= base_url('dashboard/airtime_to_wallet/?proceed=true')?>" >Submit</a>

                                    <a class="btn btn-sm btn-danger btn-sm col-sm-4 pull-right" href="<?= base_url('dashboard/airtime_to_wallet/?proceed=false')?>" >Cancel</a>
                                </p>


                            <?php else : ?>
                                <div class="lead">
                                    <p>Transfer airtime to payscribe.ng and the calculated price value will be funded to your wallet.</p>
                                </div>
                                    <?= form_open('dashboard/airtime_transfer', 'role="form"')?>

                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label for="Network">Select network <span class="text-danger">*</span></label>
                                                <select class="form-control" name="airtime_pin_network" required id="airtime_pin_network">
                                                    <option value="" selected data-discount="" data-icon-url="<?= base_url('assets/img/payscribe-logo-single.png')?>"> -- Select Network -- </option>
                                                    <?php foreach ( $networks as $network ) : ?>
                                                        <option value="<?= $network->network_name; ?>" data-discount="<?= $network->discount;?>" data-icon-url="<?= CLOUDINARY_IMG_URL . $network->image; ?>"><?= strtoupper($network->title); ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label for="amount">Enter the amount you're sending <span class="text-danger">*</span></label>
                                                <input type="text" name="amount" id="pin_amount" class="form-control number">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label for="sender">Enter the number you're sending it from <span class="text-danger">*</span></label>
                                                <input type="text" name="sender" class="form-control number">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <div class="alert alert-info amount_to_earn" style="display: none;">
                                            <span class="to_receive"></span>
                                        </div>
                                    </div>

                                    <br />
                                    <input type="hidden" name="amount_earned" id="amount_earned" value="" />
                                    <input type="hidden" name="post_type" value="airtime_transfer" />
                                    <button class="btn btn-sm btn-primary col-sm-12" type="submit">PROCEED</button>



                                    <?= form_close(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
    <!-- Page footer-->
    <footer>
        <span><?= lang('copyright'); ?></span>
    </footer>
</div>
<?php $this->load->view('app/resources/script');?>
</body>
</html>