<?php $this->load->view('app/resources/meta'); ?>
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">

                    <?php $this->load->view('confirm_upgrade'); ?>

                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-header">Buy Airtime</div>
                            <?= form_open(''); ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-3"></div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="network">Select Network</label>
                                            <select class="form-control" name="network" required id="airtime-network">
                                                <option value="" selected data-percent=""> -- Select Network -- </option>
                                                <?php foreach ( $networks as $network ) : ?>
                                                    <option value="<?= $network->id; ?>" data-percent="<?= $network->discount;?>"><?= strtoupper($network->title); ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label>Phone Number</label>
                                            <input class="form-control" type="text" name="phone" value="<?= $msisdn; ?>" id="phone" autocomplete="off" required placeholder="Enter Phone Number">
                                        </div>
                                        <div class="form-group">
                                            <label>Amount</label>
                                            <input class="form-control number" type="text" name="amount" id="amount" min="100" placeholder="Enter The Amount">
                                        </div>

                                        <div class="form-group">
                                            <label class="form-check-label">
                                                Bypass Phone Number Validation
                                                <input class="form-check-inline" type="checkbox" name="bypass" id="bypass" />
                                            </label>
                                        </div>
                                        <div class="alert-notification"></div>
                                    </div>
                                    <div class="col-md-3"></div>
                                </div>
                            </div>

                            <div class="d-block text-center card-footer">
                                <button class="mr-2 btn-icon btn-icon-only btn btn-outline-danger" type="reset">Reset Form</button>
                                <button class="btn-wide btn btn-success airtime-proceed" type="button">Proceed</button>
                            </div>
                            <?= form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
</body>
</html>
