<?php
$user_id = $this->session->userdata('logged_id');
$pending_wallet = $this->site->count_row('transactions', array('status' => 'pending', 'payment_method' => 1, 'product_id' => 6));
$pending_upgrade = $this->site->count_row('upgrade', " ( status = 'pending' OR status = 'processing')");
?>
<div class="app-sidebar sidebar-shadow">
    <div class="app-header__logo">
        <div class="logo-src">
            <img src="<?= base_url('assets/app/images/logo-invese.png')?>" alt="567Services">
        </div>
        <div class="header__pane ml-auto">
            <div>
                <button type="button" class="hamburger close-sidebar-btn hamburger--elastic" data-class="closed-sidebar">
                    <span class="hamburger-box">
                        <span class="hamburger-inner"></span>
                    </span>
                </button>
            </div>
        </div>
    </div>

    <div class="app-header__mobile-menu">
        <div>
            <button type="button" class="hamburger hamburger--elastic mobile-toggle-nav">
                <span class="hamburger-box">
                    <span class="hamburger-inner"></span>
                </span>
            </button>
        </div>
    </div>
    <div class="app-header__menu">
        <span>
            <button type="button" class="btn-icon btn-icon-only btn btn-primary btn-sm mobile-toggle-header-nav">
                <span class="btn-icon-wrapper">
                    <i class="fa fa-ellipsis-v fa-w-6"></i>
                </span>
            </button>
        </span>
    </div>
    <div class="scrollbar-sidebar">
        <div class="app-sidebar__inner">
            <ul class="vertical-nav-menu">
                <li class="app-sidebar__heading">Dashboards</li>
                <li>
                    <a href="<?= base_url('admin/')?>" <?php if( $page =='dashboard') echo 'class="mm-active"'; ?>>
                        <i class="fas fa-home"></i>&nbsp;
                        Dashboard
                    </a>
                </li>

                <li class="app-sidebar__heading">Services</li>
                <li>
                    <a href="<?= base_url('admin/services/'); ?>" <?php if( $page =='services') echo 'class="mm-active"'; ?>>
                        <i class="fas fa-cog"></i>&nbsp;
                        Manage Services
                    </a>
                </li>

                <li class="app-sidebar__heading">Funds Approval</li>
                <li>
                    <a href="<?= base_url('admin/funds/'); ?>" <?php if( $page =='funds') echo 'class="mm-active"'; ?>>
                        <i class="fas fa-money-check"></i>&nbsp;
                        Funds <?php if( $pending_wallet > 0) : ?><span class="pull-right badge badge-info"><?= $pending_wallet; ?></span><?php endif;?>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('admin/upgrade_request/'); ?>" <?php if( $page =='upgrade') echo 'class="mm-active"'; ?>>
                        <i class="fas fa-money-check"></i>&nbsp;
                        Upgrade <?php if( $pending_upgrade > 0) : ?><span class="pull-right badge badge-info"><?= $pending_upgrade; ?></span><?php endif;?>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('admin/commission_request/'); ?>" <?php if( $page =='commission_request') echo 'class="mm-active"'; ?>>
                        <i class="fas fa-money-check"></i>&nbsp;
                        Commission Request <span class="pull-right badge badge-info"></span>
                    </a>
                </li>

                <li class="app-sidebar__heading">Transactions</li>
                <li>
                    <a href="<?= base_url('admin/transactions/')?>" <?php if( $page =='transactions') echo 'class="mm-active"'; ?> >
                        <i class="fab fa-buromobelexperte">&nbsp;
                        </i>Transactions
                    </a>
                </li>

                <li class="app-sidebar__heading">Users</li>
                <li>
                    <a href="<?= base_url('admin/users/')?>" >
                        <i class="fas fa-users">&nbsp;
                        </i>Manage Users
                    </a>
                </li>

                <li class="app-sidebar__heading">Settings</li>
                <li>
                    <a href="<?= base_url('admin/notification/'); ?>" <?php if( $page =='notifications') echo 'class="mm-active"'; ?>>
                        <i class="fas fa-cog"></i>&nbsp;
                        Notifications
                    </a>
                    <a href="<?= base_url('admin/emailsms/'); ?>" <?php if( $page =='emailsms') echo 'class="mm-active"'; ?>>
                        <i class="fas fa-inbox"></i>&nbsp;
                        Email & SMS
                    </a>
                    <a href="<?= base_url('admin/settings/'); ?>" <?php if( $page =='profile') echo 'class="mm-active"'; ?>>
                        <i class="fas fa-users"></i>&nbsp;
                        Profile
                    </a>
                </li>

                <li class="app-sidebar__heading">Logout</li>

                <li>
                    <a href="<?= base_url('logout/'); ?>">
                        <i class="fas fa-key"></i>&nbsp;
                        Logout
                    </a>
                </li>
            </ul>
        </div>
    </div>
</div>
