<?php $this->load->view('app/resources/meta'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header fixed-footer">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/admin_aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">
                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-header">List of all users in the system</div>
                            <?= form_open(''); ?>
                            <div class="card-body">
                                <div class="row">

                                    <div class="col-md-12">
                                        <?php $this->load->view('msg_view'); ?>
                                        <div style="margin-top: 20px" class="table-responsive">
                                            <table class="table table-striped" id="table">
                                                <thead>
                                                <tr>
                                                    <th style="display: none;"></th>
                                                    <th>User ID</th>
                                                    <th>Membership Type</th>
                                                    <th>Name</th>
                                                    <th>Email/Phone</th>
                                                    <th>Wallet</th>
                                                    <th>Last Login</th>
                                                    <th>Status</th>
                                                    <th>Action</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php foreach( $users as $user ): ?>
                                                    <tr>
                                                        <td style="display: none"><?= $user->id; ?></td>
                                                        <td><?= $user->user_code; ?></td>
                                                        <td><?= $user->membership_type; ?></td>
                                                        <td>
                                                            <a title="User Transactions" href="<?= base_url('admin/user/?uid='. $user->id.'&name='.$user->name)?>">
                                                                <?= $user->name; ?>
                                                            </a>
                                                        </td>


                                                        <td><?= $user->email . ' ' . $user->phone; ?></td>
                                                        <td>&#8358;
                                                            <form action="<?= base_url('admin/update_wallet/'); ?>" method="post" id="<?= $user->id;?>">
                                                                <div class="form-group">
                                                                    <input type="text" class="form-control number" name="wallet" value="<?= $user->wallet;?>" >
                                                                </div>
                                                                <input type="hidden" name="user" value="<?= $user->name; ?>">
                                                                <input type="hidden" name="user_id" value="<?= $user->id; ?>">
                                                                <input type="hidden" name="post_type" value="wallet">
                                                                <button type="button" data-wid="<?= $user->id; ?>" class="btn btn-sm btn-danger update-wallet">Update Wallet</button>
                                                            </form>
                                                            <form action="<?= base_url('admin/update_wallet/'); ?>" method="post" id="<?= $user->id;?>">
                                                                <div class="form-group">
                                                                    <input type="text" class="form-control number" name="wallet" value="<?= $user->referral_bonus;?>" >
                                                                </div>
                                                                <input type="hidden" name="user" value="<?= $user->name; ?>">
                                                                <input type="hidden" name="user_id" value="<?= $user->id; ?>">
                                                                <input type="hidden" name="post_type" value="referral">
                                                                <button type="submit" onclick="confirm('Are you sure')" data-wid="<?= $user->id; ?>" class="btn btn-sm btn-danger">Update Referral</button>
                                                            </form>
                                                        </td>
                                                        <td><?= neatDate($user->last_login) . ' ' . neatTime($user->last_login); ?></td>
                                                        <td><?= statusLabel($user->status); ?></td>
                                                        <td>
                                                            <div class="btn-group mb-sm">
                                                                <button class="btn dropdown-toggle btn-danger" type="button" data-toggle="dropdown" aria-expanded="false">Action
                                                                    <span class="caret"></span>
                                                                </button>
                                                                <ul class="dropdown-menu" role="menu">
                                                                    <li>
                                                                        <a class="dropdown-item" href="<?= base_url('admin/user_action/active/' . $user->id); ?>">Unblock</a>
                                                                    </li>
                                                                    <li>
                                                                        <a class="dropdown-item" href="<?= base_url('admin/user_action/block/' . $user->id); ?>">Block</a>
                                                                    </li>
                                                                    <li>
                                                                        <a class="dropdown-item" href="<?= base_url('admin/user_action/delete/' . $user->id); ?>">Delete</a>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <?= form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
</body>
</html>
