<?php $this->load->view('app/resources/meta'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">
<style>
    /*Now the CSS*/
    * {margin: 0; padding: 0;}

    .tree ul {
        padding-top: 20px; position: relative;

        transition: all 0.5s;
        -webkit-transition: all 0.5s;
        -moz-transition: all 0.5s;
    }

    .tree li {
        float: left; text-align: center;
        list-style-type: none;
        position: relative;
        padding: 20px 5px 0 5px;

        transition: all 0.5s;
        -webkit-transition: all 0.5s;
        -moz-transition: all 0.5s;
    }

    /*We will use ::before and ::after to draw the connectors*/

    .tree li::before, .tree li::after{
        content: '';
        position: absolute; top: 0; right: 50%;
        border-top: 1px solid #ccc;
        width: 50%; height: 20px;
    }
    .tree li::after{
        right: auto; left: 50%;
        border-left: 1px solid #ccc;
    }

    /*We need to remove left-right connectors from elements without
    any siblings*/
    .tree li:only-child::after, .tree li:only-child::before {
        display: none;
    }

    /*Remove space from the top of single children*/
    .tree li:only-child{ padding-top: 0;}

    /*Remove left connector from first child and
    right connector from last child*/
    .tree li:first-child::before, .tree li:last-child::after{
        border: 0 none;
    }
    /*Adding back the vertical connector to the last nodes*/
    .tree li:last-child::before{
        border-right: 1px solid #ccc;
        border-radius: 0 5px 0 0;
        -webkit-border-radius: 0 5px 0 0;
        -moz-border-radius: 0 5px 0 0;
    }
    .tree li:first-child::after{
        border-radius: 5px 0 0 0;
        -webkit-border-radius: 5px 0 0 0;
        -moz-border-radius: 5px 0 0 0;
    }

    /*Time to add downward connectors from parents*/
    .tree ul ul::before{
        content: '';
        position: absolute; top: 0; left: 50%;
        border-left: 1px solid #ccc;
        width: 0; height: 20px;
    }

    .tree li a{
        border: 1px solid #ccc;
        padding: 5px 10px;
        text-decoration: none;
        color: #666;
        font-family: arial, verdana, tahoma;
        font-size: 11px;
        display: inline-block;

        border-radius: 5px;
        -webkit-border-radius: 5px;
        -moz-border-radius: 5px;

        transition: all 0.5s;
        -webkit-transition: all 0.5s;
        -moz-transition: all 0.5s;
    }

    /*Time for some hover effects*/
    /*We will apply the hover effect the the lineage of the element also*/
    .tree li a:hover, .tree li a:hover+ul li a {
        background: #c8e4f8; color: #000; border: 1px solid #94a0b4;
    }
    /*Connector styles on hover*/
    .tree li a:hover+ul li::after,
    .tree li a:hover+ul li::before,
    .tree li a:hover+ul::before,
    .tree li a:hover+ul ul::before{
        border-color:  #94a0b4;
    }
</style>
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header fixed-footer">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/admin_aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">
                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-header">
                                <h3>Manage <?= ucwords($user->name)?>'s Account</h3>
                            </div>
                            <div class="card-body">
                                    <div class="row">

                                        <div class="col-md-12">
                                            <?php $this->load->view('msg_view'); ?>
                                        </div>
                                        <div class="col-md-6">
                                            <p class="text-danger">
                                                <b>User ID:</b> <?=$user->user_code; ?> |
                                                <b>Reg. Date:</b> <?= neatDate( $user->date_registered) . ' ' . neatTime( $user->date_registered); ?> |
                                                <b>Last Login: </b> <?= neatDate( $user->last_login) . ' ' . neatTime( $user->last_login); ?>
                                            </p>
                                            <?= form_open(); ?>
                                                <div class="row">
                                                    <div class="col-6 form-group">
                                                        <label for="phone_number">Phone number</label>
                                                        <input type="tel" name="phone" class="form-control" value="<?= $user->phone;?>" />
                                                    </div>
                                                    <div class="col-6 form-group">
                                                        <label for="email">Email</label>
                                                        <input type="email" name="email" class="form-control" value="<?= $user->email;?>" />
                                                    </div>

                                                    <div class="col-6 form-group">
                                                        <label for="membership_type">Membership type</label>
                                                        <input type="text" name="membership_type" class="form-control" value="<?= $user->membership_type;?>" />
                                                    </div>

                                                    <div class="col-6 form-group">
                                                        <label for="wallet">Wallet</label>
                                                        <input type="text" name="wallet" class="form-control" value="<?= $user->wallet;?>" />
                                                    </div>

                                                </div>
                                                <div class="my-3">
                                                    <input type="hidden" name="uid" class="form-control" value="<?= $user->id;?>" />
                                                    <input type="hidden" name="name" class="form-control" value="<?= $user->name;?>" />
                                                    <button type="submit" class="btn btn-success">Update</button>
                                                </div>
                                            <?= form_close(); ?>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="tree">
                                                <ul>
                                                    <li>
                                                        <a href="#"><?= ucwords($user->name)?></a>
                                                        <ul>
                                                            <?php if( $downlines ) : foreach( $downlines as $downline ) : ?>
                                                                <li>
                                                                    <a href="#"><?= ucwords($downline->name); ?></a>
                                                                    <ul>
                                                                        <ul>
                                                                            <?php
                                                                            // Second Generation
                                                                            $second_generation = $this->site->my_downlines( $downline->user_code );
                                                                            if( $second_generation ): foreach ( $second_generation as $second ):
                                                                                ?>
                                                                                <li>
                                                                                    <a href="#"><?= ucwords( $second->name); ?></a>
                                                                                    <ul>
                                                                                        <?php
                                                                                        // Third Generation
                                                                                        $third_generation = $this->site->my_downlines( $second->user_code );
                                                                                        if( $third_generation ): foreach ( $third_generation as $third ):
                                                                                            ?>
                                                                                            <li>
                                                                                                <a href="#"><?= ucwords($third->name); ?></a>
                                                                                                <ul>
                                                                                                    <?php
                                                                                                    // Fourth Generation
                                                                                                    $fourth_generation = $this->site->my_downlines( $third->user_code );
                                                                                                    if( $fourth_generation ): foreach ( $fourth_generation as $fourth ):
                                                                                                        ?>
                                                                                                        <li>
                                                                                                            <a href="#"><?= ucwords( $fourth->name ); ?></a>
                                                                                                            <ul>
                                                                                                                <?php
                                                                                                                // Fourth Generation
                                                                                                                $fifth_generation = $this->site->my_downlines( $fourth->user_code );
                                                                                                                if( $fifth_generation ): foreach ( $fifth_generation as $fifth ):
                                                                                                                    ?>
                                                                                                                    <li>
                                                                                                                        <a href="#"><?= ucwords($fifth->name); ?></a>
                                                                                                                    </li>
                                                                                                                <?php endforeach; endif; ?>
                                                                                                            </ul>
                                                                                                        </li>
                                                                                                    <?php endforeach; endif; ?>
                                                                                                </ul>
                                                                                            </li>
                                                                                        <?php endforeach; endif; ?>
                                                                                    </ul>
                                                                                </li>
                                                                            <?php endforeach; endif; ?>
                                                                        </ul>
                                                                    </ul>
                                                                </li>
                                                            <?php endforeach; else: ?>
                                                                <li>
                                                                    <a href="#">You user have any downline yet</a>
                                                                    <ul>
                                                                        <ul>
                                                                            <li>
                                                                                <a href="#">No Downline</a>
                                                                                <ul>
                                                                                    <li>
                                                                                        <a href="#">No downline</a>
                                                                                    </li>
                                                                                    <li>
                                                                                        <a href="#">No downline</a>
                                                                                    </li>
                                                                                </ul>
                                                                            </li>
                                                                            <li>
                                                                                <a href="#">No downline</a>
                                                                            </li>
                                                                        </ul>
                                                                    </ul>
                                                                </li>
                                                            <?php endif; ?>
                                                        </ul>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div style="margin-top: 20px" class="table-responsive">
                                                <table class="table table-striped" id="table">
                                                    <thead>
                                                    <tr>
                                                        <th style="display: none"></th>
                                                        <th>Transaction ID</th>
                                                        <th>Amount</th>
                                                        <th>Balance</th>
                                                        <th>Date & Time</th>
                                                        <th>Type</th>
                                                        <th>Description</th>
                                                        <th>Status</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php foreach( $transactions as $transaction ): ?>
                                                        <tr>
                                                            <td style="display:none;"><?= $transaction->id; ?></td>
                                                            <td><a href="<?= base_url('admin/resolution/?trans_id=' . $transaction->trans_id )?>" title="Resolution"><?= $transaction->trans_id; ?></a></td>
                                                            <td><?= ngn($transaction->amount)?></td>
                                                            <td><?= ngn($transaction->balance)?></td>
                                                            <td><?= neatDate( $transaction->date_initiated) . ' ' . neatTime( $transaction->date_initiated); ?></td>
                                                            <td><?= product_name($transaction->product_id); ?></td>
                                                            <td><?= payment_id_replacer($transaction->description); ?></td>
                                                            <td><?= statusLabel( $transaction->status);?></td>
                                                        </tr>
                                                    <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
</body>
</html>
