<?php
$this->load->view('app/resources/meta');
?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">
</head>
<body>
<div class="wrapper">
    <!-- top navbar-->
    <?php $this->load->view('app/resources/header'); ?>
    <!-- sidebar-->
    <?php $this->load->view('app/resources/admin_aside'); ?>
    <!-- Main section-->
    <section>
        <!-- Page content-->
        <div class="content-wrapper">
            <div class="container-md">
                <div class="row">
                    <div class="col-md-3">
                        <div class="panel b">
                            <div class="panel-heading bg-gray-lighter text-bold">Site Administration</div>
                            <div class="list-group">
                                <a class="list-group-item" href="#tabSetting1" data-toggle="tab">Airtime To Cash</a>
                                <a class="list-group-item" href="#tabSetting2" data-toggle="tab">User Notification</a>
                                <a class="list-group-item" href="#tabSetting3" data-toggle="tab">Notifications</a>
                                <a class="list-group-item" href="#tabSetting4" data-toggle="tab">Applications</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <?php $this->load->view('msg_view'); ?>
                        <div class="tab-content p0 b0">
                            <div class="tab-pane active" id="tabSetting1">
                                <div class="panel b">
                                    <div class="panel-heading bg-gray-lighter text-bold">Airtime To Cash</div>
                                    <div class="panel-body">
                                        <?= form_open('/admin/site_settings_process/', 'role="form"'); ?>
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <label for="network">Network</label>
                                                        <select name="network" required class="form-control">
                                                            <option value="">-- Select Network -- </option>
                                                            <option value="glo">GLO NETWORK</option>
                                                            <option value="mtn">MTN NETWORK</option>
                                                            <option value="9mobile">9MOBILE NETWORK</option>
                                                            <option value="airtel">AIRTEL NETWORK</option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <label for="phone_no">Receive Phone</label>
                                                        <input type="tel" name="phone_no" class="form-control" required min="11" />
                                                    </div>
                                                </div>

                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <label for="percentage">Percentage</label>
                                                        <select name="percentage" class="form-control" required>
                                                            <option value=""> -- Select Percentage -- </option>
                                                            <?php for($x = 10;  $x <= 100 ; $x += 5 ) : ?>
                                                                <option value="<?= $x; ?>"> <?= $x; ?>% Percentage </option>
                                                            <?php endfor;?>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <label for="availability">Availability</label>
                                                        <select name="active">
                                                            <option value="1">Available</option>
                                                            <option value="0">Not Available</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <input type="hidden" name="post_type" value="airtime_to_cash">
                                            <button class="btn btn-info" type="submit">ADD AIRTIME TO CASH NETWORK</button>
                                        <?= form_close(); ?>

                                        <?php $y = 1;
                                            foreach($airtimes as $airtime ) : ?>
                                                <?= form_open('/admin/site_settings_process/', 'role="form"'); ?>
                                                <h3 class="text-bold">Network #<?=$y; ?></h3>
                                                <div class="row">
                                                    <div class="col-sm-3">
                                                        <div class="form-group">
                                                            <label for="network">Network</label>
                                                            <select name="network" required class="form-control">
                                                                <option value="">-- Select Network -- </option>
                                                                <option value="glo" <?php if( $airtime->network == 'glo') echo 'selected'?> >GLO NETWORK</option>
                                                                <option value="mtn" <?php if( $airtime->network == 'mtn') echo 'selected'?>  >MTN NETWORK</option>
                                                                <option value="9mobile" <?php if( $airtime->network == '9mobile') echo 'selected'?>  >9MOBILE NETWORK</option>
                                                                <option value="airtel" <?php if( $airtime->network == 'airtel') echo 'selected'?>  >AIRTEL NETWORK</option>
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="col-sm-3">
                                                        <div class="form-group">
                                                            <label for="phone_no">Receive Phone</label>
                                                            <input type="tel" name="phone_no" class="form-control" value="<?= set_value('phone_no', $airtime->phone_no); ?>" required min="11" />
                                                        </div>
                                                    </div>

                                                    <div class="col-sm-3">
                                                        <div class="form-group">
                                                            <label for="percentage">Percentage</label>
                                                            <select name="percentage" class="form-control" required>
                                                                <option value=""> -- Select Percentage -- </option>
                                                                <?php for($x = 10;  $x <= 100 ; $x += 5 ) : ?>
                                                                    <option value="<?= $x; ?>" <?php if( $airtime->percentage == $x ) echo 'selected'?>  >
                                                                        <?= $x; ?>% Percentage
                                                                    </option>
                                                                <?php endfor;?>
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="col-sm-3">
                                                        <div class="form-group">
                                                            <label for="availability">Availability</label>
                                                            <select name="active">
                                                                <option value="1" <?php if( $airtime->active == 1 ) echo 'selected'?> >Available</option>
                                                                <option value="0" <?php if( $airtime->active == 0 ) echo 'selected'?>>Not Available</option>
                                                            </select>
                                                        </div>
                                                    </div>

                                                </div>
                                                <input type="hidden" name="post_type" value="airtime_to_cash">
                                                <button class="btn btn-danger" type="submit">UPDATE <?= strtoupper($airtime->network); ?></button>
                                                <?= form_close(); ?>
                                                <hr />
                                         <?php $y++; endforeach; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tabSetting2">
                                <div class="panel b">
                                    <div class="panel-heading bg-gray-lighter text-bold">User Notification</div>
                                    <div class="panel-body">
                                        <?= form_open('admin/site_settings_process', 'role="form"'); ?>
                                        <div class="form-group">
                                            <label for="receiver">Receiver</label>
                                            <select class="form-control" name="receiver" required>
                                                <option value="">-- Select Receiver --</option>
                                                <option value="all">All User Using <?= lang('app_name'); ?></option>
                                                <option value="user">Normal Users</option>
                                                <option value="affiliate">Affiliate Users</option>
                                            </select>
                                            <span class="text-danger">Who should receive this notification message?</span>
                                        </div>

                                        <div class="form-group">
                                            <label for="message">Message</label>
                                            <textarea name="message" class="form-control" required placeholder="Type in the message"></textarea>
                                        </div>

                                        <input type="hidden" name="post_type" value="notification">
                                        <button class="btn btn-info" type="submit">SEND MESSAGE</button>
                                        <?= form_close(); ?>
                                    </div>
                                </div>
                                <div class="panel b">
                                    <div class="panel-heading bg-danger text-bold">Notification Box</div>
                                    <div class="panel-body bt">
                                        <p>You will be asked for confirmation before delete account.</p>
                                        <div class="table-responsive">
                                            <table class="table table-striped table-hover">
                                                <thead>
                                                <tr>
                                                    <th>S/N</th>
                                                    <th>Receiver</th>
                                                    <th>Message</th>
                                                    <th>Action</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php foreach($notifications as $notif ) : ?>
                                                    <tr>
                                                        <td><?= $notif->id;?></td>
                                                        <td><?= ucfirst( $notif->receiver );?></td>
                                                        <td><?= word_limiter($notif->message, 50) ?></td>
                                                        <td>
                                                            <button class="btn btn-primary btn-sm btn-success viewMessage"
                                                                    type="button"
                                                                    data-toggle="modal"
                                                                    data-target="#openModal"
                                                                    data-message="<?= $notif->message; ?>"
                                                                    data-id="<?= $notif->id; ?>"
                                                            >View Message</button>
                                                            <button class="btn btn-default del-notification" type="button" data-id="<?= $notif->id;?>">
                                                                <span class="text-danger">Delete account</span>
                                                            </button>
                                                        </td>
                                                    </tr>
                                                <?php endforeach;?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tabSetting3">
                                <?= form_open('admin/profile_setting', 'role="form"'); ?>
                                <div class="panel b">
                                    <div class="panel-heading bg-gray-lighter text-bold">Notifications</div>
                                </div>
                                <?= form_close(); ?>
                            </div>
                            <div class="tab-pane" id="tabSetting4">
                                <div class="panel b">
                                    <div class="panel-heading bg-gray-lighter text-bold">Applications</div>
                                    <div class="panel-body">
                                        <div class="alert alert-danger">
                                            <p>Coming Soon For Developers</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Page footer-->
    <footer>
        <span><?= lang('copyright'); ?></span>
    </footer>
</div>
<?php $this->load->view('app/resources/script');?>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
<div id="openModal" tabindex="-1" role="dialog" aria-labelledby="openModalLabel" aria-hidden="true" style="display: none;" class="modal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
                <h4 class="modal-title" id="openModalLabel">Message</h4>
            </div>
            <div class="modal-body">
                <form id="notificationForm" action="<?= base_url('admin/site_settings_process')?>" method="post">
                    <div class="form-group">
                        <label for="message">Message</label>
                        <textarea class="form-control" name="message" id="messageContent"></textarea>
                    </div>
                    <input type="hidden" name="id" id="notif_id" value="">
                    <input type="hidden" name="update_notification" value="update">
                    <input type="hidden" name="post_type" value="notification">
                </form>
            </div>
            <div class="modal-footer">
                <button class="btn btn-default" type="button" data-dismiss="modal">Close</button>
                <button class="btn btn-primary update-notification" type="button">Save changes</button>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function () {
        $('.viewMessage').on('click', function(){
            let _this = $(this);
            $('#messageContent').html(_this.data('message'));
            $('#notif_id').val(_this.data('id'));
        });

        $('.update-notification').on('click', function () {
            $('#notificationForm').submit();
        });
    });
</script>
</body>
</html>