<?php $this->load->view('app/resources/meta'); ?>
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header fixed-footer">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/admin_aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">
                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-header">Profile</div>

                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-1"></div>
                                    <div class="col-md-10">
                                        <div class="mb-3 card">
                                            <div class="card-header">
                                                <ul class="nav nav-justified">
                                                    <li class="nav-item"><a data-toggle="tab" href="#tab-eg7-0" class="active nav-link">Profile Settings</a></li>
                                                    <li class="nav-item"><a data-toggle="tab" href="#tab-eg7-1" class="nav-link">Password Settings</a></li>
                                                </ul>
                                            </div>
                                            <div class="card-body">
                                                <div class="tab-content">
                                                    <?php $this->load->view('msg_view'); ?>
                                                    <div class="tab-pane active" id="tab-eg7-0" role="tabpanel">
                                                        <?= form_open('admin/profile_setting', 'role="form"'); ?>
                                                        <div class="form-group">
                                                            <label for="name">Name</label>
                                                            <input class="form-control" type="text" name="name" value="<?= set_value('name', $user->name); ?>">
                                                            <?= form_error('name')?>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="name">Account Name</label>
                                                            <input class="form-control" type="text" name="account_name" value="<?= set_value('account_name', $user->account_name); ?>">
                                                            <?= form_error('account_name')?>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="name">Account Number</label>
                                                            <input class="form-control" type="text" name="account_number" value="<?= set_value('account_number', $user->account_number); ?>">
                                                            <?= form_error('account_number')?>
                                                        </div>

                                                        <div class="form-group">
                                                            <label for="account_type">Account Type</label>
                                                            <select class="form-control" name="account_type">
                                                                <option value="current" <?php if($user->account_type == 'current') echo 'selected'; ?>>Current Account</option>
                                                                <option value="savings" <?php if($user->account_type == 'savings') echo 'selected'; ?>>Savings Account</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="bank_name">Bank Name</label>
                                                            <select name="bank_name" class="form-control">
                                                                <option value="">-- Select Bank Name --</option>
                                                                <?php
                                                                $banks = explode(',', lang('banks'));
                                                                foreach ( $banks as $bank ) : ?>
                                                                    <option value="<?= trim($bank); ?>" <?php if( $user->bank_name == trim($bank) ) echo 'selected'; ?> ><?= trim($bank); ?></option>
                                                                <?php endforeach;
                                                                ?>
                                                            </select>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="password">Confirm Password</label>
                                                            <input type="password" name="confirm_password" id="confirm_password" class="form-control" required placeholder="Please enter your password for confirmation">
                                                        </div>
                                                        <input type="hidden" name="post_type" value="account">
                                                        <button class="btn btn-info" type="submit">Update settings</button>
                                                        <?= form_close(); ?>
                                                    </div>
                                                    <div class="tab-pane" id="tab-eg7-1" role="tabpanel">
                                                        <?= form_open('admin/profile_setting', 'role="form"'); ?>
                                                        <div class="form-group">
                                                            <label>Current password</label>
                                                            <input class="form-control" type="password" name="current_password">
                                                            <?= form_error('password'); ?>
                                                        </div>
                                                        <div class="form-group">
                                                            <label>New password</label>
                                                            <input class="form-control" type="password" name="new_password">
                                                            <?= form_error('new_password'); ?>
                                                        </div>
                                                        <div class="form-group">
                                                            <label>Confirm new password</label>
                                                            <input class="form-control" type="password" name="confirm_password">
                                                            <?= form_error('confirm_password'); ?>
                                                        </div>
                                                        <input type="hidden" name="post_type" value="password_change">
                                                        <button class="btn btn-info" type="submit">Update password</button>
                                                        <?= form_close(); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-1"></div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
</body>
</html>
