<?php $this->load->view('app/resources/meta'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/admin_aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">
                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-header">Create / Manage Services</div>

                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-1"></div>
                                    <div class="col-md-10">
                                        <?php $this->load->view('msg_view'); ?>
                                        <?= form_open_multipart('admin/services/'); ?>
                                            <div class="row">
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="Service Type">Service Category</label>
                                                    <select class="form-control" name="product_id" required>
                                                        <option value="" selected>-- Select Service Category--</option>
                                                        <?php foreach($products as $product) :?>
                                                            <option value="<?= $product->id ?>"><?= ucwords($product->title); ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="Starting From">Service Title</label>
                                                    <input type="text" class="form-control" required name="title" placeholder="Eg : Glo airtime">
                                                </div>
                                            </div>

                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="Discount">Service Discount</label>
                                                    <select class="form-control" name="discount" required>
                                                        <option value="0" selected> 0% Discount </option>
                                                        <?php for( $x = 1; $x <= 10;  $x++ ) : ?>
                                                            <option value="<?= $x;?>"><?= $x; ?>% Discount</option>
                                                        <?php endfor; ?>
                                                    </select>
                                                    <span class="text-danger">Leave as 0 if you're not giving discount</span>
                                                </div>
                                            </div>

                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="Discount">Discount should work for?</label>
                                                    <span class="text-danger">Ignore This !!!</span>
                                                    <select class="form-control" name="discount_type">
                                                        <option value="all" selected>All Buyer</option>
                                                        <option value="bronze"> Bronze User</option>
                                                        <option value="silver"> Silver User</option>
                                                        <option value="gold"> Gold User</option>
                                                        <option value="diamond"> Diamond User</option>
                                                    </select>
                                                    <span class="text-danger">Leave as general, if no exception</span>
                                                </div>
                                            </div>

                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="Network Name">Network Name</label>
                                                    <select class="form-control" name="network_name">
                                                        <option value="">-- Please select the appropriate --</option>
                                                        <option value="glo">Glo</option>
                                                        <option value="9mobile">9mobile</option>
                                                        <option value="mtn">MTN</option>
                                                        <option value="airtel">Airtel</option>
                                                        <option value="gotv">GoTV</option>
                                                        <option value="dstv">DSTV</option>
                                                        <option value="startimes">STARTIMES</option>
                                                        <option value="electricity">Electricity</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="Starting From">Availability</label>
                                                    <select class="form-control" name="availability">
                                                        <option value="1" selected>Make Available</option>
                                                        <option value="0">Not Available</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <label for="message">Service Message</label> <span class="text-danger">Give a detailed information about this service, if available</span>
                                                    <textarea class="form-control text-area" rows="3" name="message"></textarea>
                                                </div>
                                            </div>

                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <label for="service icon">Service Image Icon</label>
                                                    <input type="file" name="image_icon" accept="image/*">
                                                </div>
                                            </div>

                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <label for="message">Code To Check Balance</label> <span class="text-danger">Basically for Data Service</span>
                                                    <input type="text" name="check_balance" placeholder="Code" class="form-control">
                                                </div>
                                            </div>

                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <label for="message">SEO (Search Engine Optimization)</label> <span class="text-danger">The keywords you'll like the user to search for in getting this item</span>
                                                    <textarea class="form-control text-area" rows="3" name="seo" placeholder="Search Engine Optimization"></textarea>
                                                </div>
                                            </div>

                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <label>
                                                        <input type="checkbox" name="has_plans" class="has_plans" >&nbsp;
                                                        <strong>Does this service has plans?</strong>
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                <div id="options" style="display: none;">
                                                    <table class="table table-bordered table-hover plan_table">
                                                        <thead>
                                                        <tr>
                                                            <th>Name</th>
                                                            <th>Value</th>
                                                            <th>Variation</th>
                                                            <th>Ref</th>
                                                            <th></th>
                                                        </tr>
                                                        </thead>
                                                        <tbody class="variation_body">
                                                        <tr data-row-id="1">
                                                            <td>
                                                                <div class="form-group">
                                                                    <label for="name">Name</label>
                                                                    <input type="text" class="form-control" placeholder="EG: 2GB" name="plan_name[]">
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="form-group">
                                                                    <label for="value">Value</label>
                                                                    <input type="text" class="form-control number" placeholder="Eg: 3000" name="plan_value[]">
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="form-group">
                                                                    <label for="variation">Variation</label>
                                                                    <input type="text" class="form-control" placeholder="EG: *127*13*{phone_number}#" name="plan_variation[]">
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="form-group">
                                                                    <label for="value">Ref ID</label>
                                                                    <input type="text" class="form-control" placeholder="Eg: 3000" name="ref_id[]">
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <button class="btn btn-sm btn-primary add_row" type="button"><i class="fas fa-crosshairs"></i> Add</button>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>

                                            <div class="col-sm-12 col-md-4 offset-4">
                                                <button class="btn btn-primary btn-sm col-sm-12" type="submit" >CREATE</button>
                                            </div>

                                        </div>
                                        <?= form_close() ; ?>
                                        <div class="py-7" style="padding-top: 40px;">
                                            <div class="table-responsive">
                                                <table class="table table-striped table-hover">
                                                    <thead>
                                                    <tr>
                                                        <th>S/N</th>
                                                        <th>Category</th>
                                                        <th>Service Name</th>
                                                        <th>Access To</th>
                                                        <th>Discount</th>
                                                        <th>Action</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php foreach ( $services as $service ) : ?>
                                                        <tr>
                                                            <td><?= $service->id; ?></td>
                                                            <td><?= ucwords($service->category);?> Category</td>
                                                            <td><?= $service->title;?></td>
                                                            <td><?= ucwords($service->discount_type);?></td>
                                                            <td><?= $service->discount; ?>%</td>
                                                            <td>
                                                                <a href="<?= base_url('admin/plan/?sid=' . $service->id)?>" class="btn btn-sm btn-primary">Edit Plan</a>
                                                                <a href="<?= base_url('admin/edit_service/?sid=' . $service->id)?>" class="btn btn-sm btn-info">Edit Service</a>
                                                                <button class="btn btn-sm btn-danger delete-service" data-id="<?= $service->id; ?>">Delete Service</button>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-1"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
<script type="text/javascript">
    $.fn.rowCount = function () {
        return $('tr', $(this).find('tbody')).length;
    };

    $('.add_row').on('click', add_new_row);

    $(document).ready(function () {

        $('.has_plans').change(function () {
            if (this.checked) {
                $('#options').fadeIn('slow');
                $('#plans').attr('required', true);
            } else {
                $('#options').fadeOut('slow');
                $('#plans').attr('required', false);
            }
        });

        $('.delete_row').on('click', function () {
            let target = $(this).data('target');
            $(`#${target}`).remove();
        });
    });

    function add_new_row(){
        // Add new row
        let row_id = $('.plan_table').rowCount() * 1;
        let new_id = row_id + 1;
        $('.plan_table tbody').append(`<tr id="${new_id}_row">
                <td>
                    <div class="form-group">
                        <input type="hidden" name="plan_id[]" value="new" />
                        <label for="name">Name</label>
                        <input type="text" class="form-control" required placeholder="EG: 2GB" name="plan_name[]">
                    </div>
                </td>
                <td>
                    <div class="form-group">
                        <label for="value">Value</label>
                        <input type="text" class="form-control number" required placeholder="Eg: 3000" name="plan_value[]">
                    </div>
                </td>
                <td>
                    <div class="form-group">
                        <label for="variation">Variation</label>
                        <input type="text" class="form-control" placeholder="EG: *127*13*{phone_number}#" name="plan_variation[]">
                    </div>
                </td>
                <td>
                    <div class="form-group">
                        <label for="variation">Ref ID</label>
                        <input type="text" class="form-control" placeholder="11" name="ref_id[]">
                    </div>
                </td>
                <td>
                    <a class="btn btn-sm btn-primary add_row" href="javascript:void(0);" onclick="add_new_row()"> <i class="fas fa-crosshairs"></i>  Add New Row</a>
                    <a class="btn btn-sm btn-danger" href="javascript:void(0);" onclick="delete_row('${new_id}_row');" data-target="${new_id}_row"> <i class="fas fa-crosshairs"></i> Remove Row</a>
                </td>
            </tr>`);
    }

    function delete_row( target ){
        $(`#${target}`).remove();
    }
    $('.delete_row').on('click', function () {
        let target = $(this).data('target');
        $(`#${target}`).remove();
    });


</script>
</body>
</html>
