<?php
$this->load->view('app/resources/meta');

?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">
</head>
<body>
<div class="wrapper">
    <!-- top navbar-->
    <?php $this->load->view('app/resources/header'); ?>
    <!-- sidebar-->
        <?php $this->load->view('app/resources/admin_aside'); ?>
    <!-- Main section-->
    <section>
        <!-- Page content-->
        <div class="content-wrapper">
            <div class="content-heading">
                <!-- START Language list-->
                <!-- END Language list-->Funds
                <small data-localize="dashboard.FUNDS"></small>
            </div>
            <!-- START widgets box-->

            <div class="row">
                <div class="col-md-12">
                    <div class="panel panel-default" style="padding: 20px;">
                        <div class="panel-heading">
                            Reseller Awaiting Approval
                        </div>
                        <div class="panel-body">
                            <div class="py-7" style="padding-top: 40px;">
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover">
                                        <thead>
                                        <tr>
                                            <th>S/N</th>
                                            <th>Transaction Id</th>
                                            <th>User</th>
                                            <th>Amount</th>
                                            <th>Image</th>
                                            <th>Date Initiated</th>
                                            <th>Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $x = 1;  foreach($transactions as $transaction) : ?>
                                            <tr>
                                                <td><?= $x; ?></td>
                                                <td><a href="<?= base_url('admin/resolution/?trans_id=' . $transaction->trans_id )?>" title="Resolution"><?= $transaction->trans_id; ?></a></td>
                                                <td><a href="<?= base_url('admin/user/?uid=' . $transaction->uid.'&name=' . $transaction->name)?>"><?= ucwords( $transaction->name)?></a></td>
                                                <td><?= ngn( $transaction->amount); ?></td>

                                                <td>
                                                    <?php if( isset( $transaction->image ) ) : ?>
                                                    <a href="<?= CLOUDINARY_IMG_URL . $transaction->image; ?>" title="Proof of payment">
                                                        <img src="<?= CLOUDINARY_IMG_URL . $transaction->image; ?>" style="width: 80px;">
                                                    </a>
                                                    <?php else:  ?>
                                                        No Image Set
                                                    <?php endif; ?>
                                                </td>

                                                <td><?= neatDate($transaction->date_initiated) . ' ' . neatTime( $transaction->date_initiated); ?></td>
                                                <td>
                                                    <button class="btn btn-sm btn-primary confirm-reseller-transaction"
                                                            data-user_id="<?= $transaction->user_id; ?>"
                                                            data-tid="<?= $transaction->id; ?>"
                                                    >Approve Transaction</button>
                                                    <button class="btn btn-sm btn-danger del-transaction" data-tid="<?= $transaction->id; ?>">Delete Transaction</button>
                                                </td>
                                            </tr>
                                        <?php $x++;endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="row">
                <div class="col-md-12">
                    <div class="panel panel-default" style="padding: 20px;">
                        <div class="panel-heading">
                            Reseller In The System
                        </div>
                        <div class="panel-body">
                            <div class="py-7" style="padding-top: 40px;">
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover">
                                        <thead>
                                        <tr>
                                            <th style="display: none;"></th>
                                            <th>S/N</th>
                                            <th>User Id</th>
                                            <th>User</th>
                                            <th>Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $x = 1;  foreach($resellers as $reseller) : ?>
                                            <tr>
                                                <td style="display: none;"><?= $reseller->id; ?></td>
                                                <td><?= $x; ?></td>
                                                <td><a href="<?= base_url('admin/user/?uid=' . $reseller->id.'&name=' . $reseller->name)?>"><?= ucwords( $reseller->user_code)?></a></td>
                                                <td><?= ucwords($reseller->name)?> / <?= $reseller->phone;?></td>
                                                <td>
                                                    <button class="btn btn-sm btn-primary confirm-reseller-transaction"
                                                            data-user_id="<?= $reseller->id; ?>">Denounce</button>
                                                </td>
                                            </tr>
                                            <?php $x++;endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </section>


    <!-- Page footer-->
    <footer>
        <span><?= lang('copyright'); ?></span>
    </footer>
</div>
<?php $this->load->view('app/resources/script');?>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
<div id="openPOP" tabindex="-1" role="dialog" aria-labelledby="openPOPLabel" aria-hidden="true" style="display: none;" class="modal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
                <h4 class="modal-title" id="openPOPLabel">User' Uploaded POP</h4>
            </div>
            <div class="modal-body">
                <p>
                    <b>Bank Name:</b> <span id="pop_bank"></span>
                </p>
                <p>
                    <b>Comment:</b> <span id="pop_comment"></span>
                </p>
                <p>
                    <b>POP:</b> <img id="pop_image" src="abc.jpg" alt="Pop Image" />
                </p>
            </div>
            <div class="modal-footer">
                <button class="btn btn-default" type="button" data-dismiss="modal">Close</button>
                <button class="btn btn-primary" type="button">Save changes</button>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function () {
        $('.viewpop').on('click', function(){
            let _this = $(this);
            $('#pop_bank').html(_this.data('bank'));
            $('#pop_comment').html(_this.data('comment'));
            $('#pop_image').attr('src', _this.data('image'));

        });
    });
</script>
</body>
</html>