<?php $this->load->view('app/resources/meta'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/admin_aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">
                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-header">Create / Manage Notifications</div>
                            <?= form_open(''); ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-1"></div>
                                    <div class="col-md-10">
                                        <?php $this->load->view('msg_view'); ?>
                                        <?= form_open(); ?>
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label for="content">Content</label> <span class="text-danger">Kindly make it short and precise</span>
                                                <textarea class="form-control" rows="3" name="content"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-4 offset-4">
                                            <button class="btn btn-primary btn-sm col-sm-12" type="submit">Post</button>
                                        </div>
                                        <?= form_close(); ?>
                                        <div class="py-7" style="padding-top: 40px;">
                                            <div class="table-responsive">
                                                <table class="table table-striped" id="table">
                                                    <thead>
                                                    <tr>
                                                        <th>Id</th>
                                                        <th>Message Content</th>
                                                        <th>Action</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php foreach( $notifications as $notification ) :?>
                                                        <tr>
                                                            <td><?= $notification->id; ?></td>
                                                            <td><?= $notification->message; ?></td>
                                                            <td>
                                                                <?php if( $notification->status == 1 ) : ?>
                                                                    <a href="<?= base_url('admin/notification/?action=disable&id=' . $notification->id); ?>" class="btn btn-primary btn-sm">Disable</a>
                                                                <?php else :?>
                                                                    <a href="<?= base_url('admin/notification/?action=enable&id=' . $notification->id); ?>" class="btn btn-secondary btn-sm">Enable</a>
                                                                <?php endif; ?>
                                                                <a href="<?= base_url('admin/notification/?action=delete&id=' . $notification->id); ?>" class="btn btn-secondary btn-sm">Delete</a>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-1"></div>
                                </div>
                            </div>
                            <?= form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
</body>
</html>
