<?php $this->load->view('app/resources/meta'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header fixed-footer">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/admin_aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">
                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-header">Funds Awaiting Approval</div>
                            <?= form_open(''); ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-1"></div>
                                    <div class="col-md-10">
                                        <?php $this->load->view('msg_view'); ?>
                                        <div class="table-responsive">
                                            <table class="table table-striped table-hover">
                                                <thead>
                                                <tr>
                                                    <th>S/N</th>
                                                    <th>Transaction Id</th>
                                                    <th>User</th>
                                                    <th>Amount</th>
                                                    <th>Image</th>
                                                    <th>Description</th>
                                                    <th>Date Initiated</th>
                                                    <th>Action</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php $x = 1;  foreach($transactions as $transaction) : ?>
                                                    <tr>
                                                        <td><?= $x; ?></td>
                                                        <td><a href="<?= base_url('admin/resolution/?trans_id=' . $transaction->trans_id )?>" title="Resolution"><?= $transaction->trans_id; ?></a></td>
                                                        <td><a href="<?= base_url('admin/user/?uid=' . $transaction->uid.'&name=' . $transaction->name)?>"><?= ucwords( $transaction->name)?></a></td>
                                                        <td><?= ngn( $transaction->amount); ?></td>

                                                        <td>
                                                            <?php if( isset( $transaction->image ) ) : ?>
                                                                <a href="<?= base_url('assets/img/' . $transaction->image); ?>" title="Proof of payment">
                                                                    <img src="<?= base_url('assets/img/' . $transaction->image); ?>" style="width: 80px;">
                                                                </a>
                                                            <?php else:  ?>
                                                                No Image Set
                                                            <?php endif; ?>
                                                        </td>
                                                        <td><?= payment_id_replacer($transaction->description); ?></td>
                                                        <td><?= neatDate($transaction->date_initiated) . ' ' . neatTime( $transaction->date_initiated); ?></td>
                                                        <td>
                                                            <button class="btn btn-sm btn-primary confirm-transaction"
                                                                    data-amount="<?= $transaction->amount; ?>"
                                                                    data-tid="<?= $transaction->id?>"
                                                                    data-user_id="<?= $transaction->user_id; ?>"
                                                            >Approve Transaction</button>
                                                            <button class="btn btn-sm btn-danger del-transaction" data-tid="<?= $transaction->id; ?>">Delete Transaction</button>
                                                        </td>
                                                    </tr>
                                                    <?php $x++;endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="col-md-1"></div>
                                </div>
                            </div>
                            <?= form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
</body>
</html>
