<?php $this->load->view('app/resources/meta'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header fixed-footer">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/admin_aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">
                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-header">
                                Scrap the users details
                            </div>

                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <?php $this->load->view('msg_view'); ?>
                                        <div style="margin-top: 20px" class="table-responsive">
                                            <table class="tables table-striped" id="dataTable">
                                                <thead>
                                                <tr>
                                                    <th style="display: none;"></th>
                                                    <th>User ID</th>
                                                    <th>Name</th>
                                                    <th>Email/Phone</th>
                                                    <th>Referral</th>
                                                    <th>Trans Count</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php foreach( $users as $user ):
                                                    $transaction_count = $this->site->count_row('transactions', array('user_id' => $user->id,
                                                        'status' => 'success'));
                                                    ?>
                                                    <tr>
                                                        <td style="display: none"><?= $user->id; ?></td>
                                                        <td><?= $user->user_code; ?></td>
                                                        <td><?= $user->name; ?></td>
                                                        <td><?= $user->email .'/'. $user->phone; ?></td>
                                                        <td><?= base_url('page/create?ref=' . $user->user_code); ?></td>
                                                        <td><?= $transaction_count; ?></td>
                                                    </tr>
                                                <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.html5.min.js"></script>
<script type="text/javascript">
    $(document).ready(function () {
        $("#dataTable").dataTable({
            "order": [[ 0, "desc" ]],
            dom: 'Bfrtip',
            buttons: [
                'copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5'
            ]
        });
    });
</script>
</body>
</html>
