<?php $this->load->view('app/resources/meta'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/admin_aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">
                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-header">Edit / Manage Services</div>
                            <?= form_open(''); ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-1"></div>
                                    <div class="col-md-10">
                                        <?php $this->load->view('msg_view'); ?>
                                        <?= form_open_multipart(base_url('admin/edit_service/')); ?>
                                            <div class="row">
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="Service Type">Service Category</label>
                                                    <select class="form-control" name="product_id" required>
                                                        <option value="" selected>-- Select Service Category--</option>
                                                        <?php foreach($products as $product) :?>
                                                            <option value="<?= $product->id ?>"
                                                                <?php if($product->id == $row->product_id) echo 'selected'; ?>
                                                                <?= set_select('product_id',  $row->product_id); ?>>
                                                                <?= ucwords($product->title); ?>
                                                            </option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="Starting From">Service Title</label>
                                                    <input type="text" class="form-control" value="<?= set_value('title', $row->title)?>" required name="title">
                                                </div>
                                            </div>

                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="Discount">Service Discount</label>
                                                    <select class="form-control" name="discount" required>
                                                        <option value="0"> 0% Discount </option>
                                                        <?php for( $x = 1; $x <= 10;  $x++ ) : ?>
                                                            <option value="<?= $x;?>"
                                                                <?php if($x == $row->discount) echo 'selected'; ?>
                                                                <?= set_select('discount',  $row->discount); ?> >
                                                                <?= $x; ?> % Discount
                                                            </option>
                                                        <?php endfor; ?>
                                                    </select>
                                                    <span class="text-danger">Leave as 0 if you're not giving discount</span>
                                                </div>
                                            </div>


                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="Discount">Discount should work for?</label>
                                                    <span class="text-danger">Ignore This !!!</span>
                                                    <select class="form-control" name="discount_type">
                                                        <option value="all" <?php if($row->discount_type =='all') echo 'selected'; ?> <?= set_select('discount_type', 'all')?> >All Buyer</option>
                                                        <option value="bronze" <?php if($row->discount_type =='bronze') echo 'selected'; ?> <?= set_select('discount_type', 'bronze')?> > Bronze User</option>
                                                        <option value="silver" <?php if($row->discount_type =='silver') echo 'selected'; ?> <?= set_select('discount_type', 'silver')?> > Silver User</option>
                                                        <option value="gold" <?php if($row->discount_type =='gold') echo 'selected'; ?> <?= set_select('discount_type', 'gold')?> > Gold User</option>
                                                        <option value="diamond" <?php if($row->discount_type =='diamond') echo 'selected'; ?> <?= set_select('discount_type', 'diamond')?> > Diamond User</option>
                                                    </select>
                                                    <span class="text-danger">Leave as general, if no exception</span>
                                                </div>
                                            </div>

                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="Network Name">Network Name</label>

                                                    <select class="form-control" name="network_name">
                                                        <option value="">-- Please select the appropriate --</option>
                                                        <option value="glo" <?php if($row->network_name =='glo') echo 'selected'; ?> <?= set_select('network_name', 'glo')?> >Glo</option>
                                                        <option value="9mobile" <?php if($row->network_name =='9mobile') echo 'selected'; ?> <?= set_select('network_name', '9mobile')?> >9mobile</option>
                                                        <option value="mtn" <?php if($row->network_name =='mtn') echo 'selected'; ?> <?= set_select('network_name', 'mtn')?> >MTN</option>
                                                        <option value="airtel" <?php if($row->network_name =='airtel') echo 'selected'; ?> <?= set_select('network_name', 'airtel')?>>Airtel</option>
                                                        <option value="gotv" <?php if($row->network_name =='gotv') echo 'selected'; ?> <?= set_select('network_name', 'gotv')?> >GoTV</option>
                                                        <option value="dstv" <?php if($row->network_name =='dstv') echo 'selected'; ?> <?= set_select('network_name', 'dstv')?> >DSTV</option>
                                                        <option value="startimes" <?php if($row->network_name =='startimes') echo 'selected'; ?> <?= set_select('network_name', 'startimes')?> >STARTIMES</option>
                                                        <option value="electricity" <?php if($row->network_name =='electricity') echo 'selected'; ?> <?= set_select('network_name', 'electricity')?>>Electricity</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="Starting From">Availability</label>
                                                    <select class="form-control" name="availability">
                                                        <option value="1" <?php if($row->availability =='glo') echo 'selected'; ?> <?= set_select('availability', '1')?>>Make Available</option>
                                                        <option value="0" <?php if($row->availability =='glo') echo 'selected'; ?> <?= set_select('availability', '0')?> >Not Available</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <label for="message">Service Message</label> <span class="text-danger">Give a detailed information about this service, if available</span>
                                                    <textarea class="form-control text-area" rows="3" name="message"><?= set_value('message', $row->message)?></textarea>
                                                </div>
                                            </div>

                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <label for="service icon">Service Image Icon</label>
                                                    <img src="<?= CLOUDINARY_IMG_URL . $row->image?>" alt="Service Image Icon">
                                                </div>
                                            </div>

                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <label for="service icon">Check Balance</label>
                                                    <input type="text" name="check_balance" value="<?= $row->check_balance; ?>" placeholder="Code" class="form-control">
                                                </div>
                                            </div>

                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <label for="message">SEO (Search Engine Optimization)</label> <span class="text-danger">The keywords you'll like the user to search for in getting this item</span>
                                                    <textarea class="form-control text-area" rows="3" name="seo" placeholder="Search Engine Optimization"><?= set_value('seo', $row->seo)?></textarea>
                                                </div>
                                            </div>
                                            <?php
                                            $plans = $this->site->get_result('plans', '*', array('sid' => $row->id));
                                            ?>
                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <label>
                                                        <input type="checkbox" name="has_plans" <?php if($plans) echo 'checked'; ?> class="has_plans" />&nbsp;
                                                        <strong>Does this service has plans?</strong>
                                                    </label>
                                                </div>
                                            </div>

                                            <div id="options" style="display: <?= ($plans) ? 'block' : 'none';?>;">

                                                <table class="table table-bordered table-hover plan_table">
                                                    <thead>
                                                    <tr>
                                                        <th>Name</th>
                                                        <th>Value</th>
                                                        <th>Variation</th>
                                                        <th>Ref ID</th>
                                                        <th></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody class="variation_body">
                                                    <?php if( $plans ) :
                                                        foreach( $plans as $plan ) :
                                                            ?>
                                                            <tr id="<?= $plan->id; ?>" data-row-id="<?= $plan->id; ?>">
                                                                <td>
                                                                    <div class="form-group">
                                                                        <label for="name">Name</label>
                                                                        <input type="hidden" value="<?= $plan->id; ?>" name="plan_id[]" />
                                                                        <input type="text" class="form-control" value="<?= $plan->name; ?>" required placeholder="EG: 2GB" name="plan_name[]">
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group">
                                                                        <label for="value">Value</label>
                                                                        <input type="text" class="form-control number" value="<?= $plan->amount; ?>" required placeholder="Eg: 3000" name="plan_value[]">
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group">
                                                                        <label for="variation">Variation</label>
                                                                        <input type="text" class="form-control" value="<?= $plan->variation?>" placeholder="EG: *127*13*{phone_number}#" name="plan_variation[]">
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="form-group">
                                                                        <label for="variation">Ref ID</label>
                                                                        <input type="text" class="form-control" value="<?= $plan->ref_id?>" placeholder="11" name="ref_id[]">
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <button class="btn btn-sm btn-primary add_row" type="button"><i class="fas fa-crosshairs"></i> Add</button>
                                                                    <a class="btn btn-sm btn-danger delete-plan" href="javascript:void(0);" data-id="<?= $plan->id;?>"> <i class="fas fa-crosshairs"></i> Remove Row</a>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; endif; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                            <input type="hidden" name="sid" value="<?= $row->id; ?>">
                                            <div class="col-sm-12 col-md-4 offset-4">
                                                <button class="btn btn-primary btn-sm col-sm-12" type="submit" >UPDATE</button>
                                            </div>

                                        </div>
                                        <?= form_close() ; ?>
                                    </div>
                                    <div class="col-md-1"></div>
                                </div>
                            </div>
                            <?= form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
<script>
    $(document).ready(function () {
        $('.has_plans').change(function () {
            if (this.checked) {
                $('#options').fadeIn('slow');
                $('#plans').attr('required', true);
            } else {
                $('#options').fadeOut('slow');
                $('#plans').attr('required', false);
            }
        });
    });
</script>

<script type="text/javascript">
    $.fn.rowCount = function () {
        return $('tr', $(this).find('tbody')).length;
    };

    $('.add_row').on('click', add_new_row);

    function add_new_row(){
        // Add new row
        let row_id = $('.plan_table').rowCount() * 1;
        let new_id = row_id + 1;
        $('.plan_table tbody').append(`<tr id="${new_id}_row">
                <td>
                    <div class="form-group">
                        <label for="name">Name</label>
                        <input type="hidden" value="new" name="plan_id[]" />
                        <input type="text" class="form-control" required placeholder="EG: 2GB" name="plan_name[]">
                    </div>
                </td>
                <td>
                    <div class="form-group">
                        <label for="value">Value</label>
                        <input type="text" class="form-control number" required placeholder="Eg: 3000" name="plan_value[]">
                    </div>
                </td>
                <td>
                    <div class="form-group">
                        <label for="variation">Variation</label>
                        <input type="text" class="form-control" placeholder="EG: *127*13*{phone_number}#" name="plan_variation[]">
                    </div>
                </td>
                <td>
                    <div class="form-group">
                        <label for="variation">Ref ID</label>
                        <input type="text" class="form-control" placeholder="11" name="ref_id[]">
                        </div>
                    </td>
                <td>
                    <a class="btn btn-sm btn-primary add_row" href="javascript:void(0);" onclick="add_new_row()"> <i class="fas fa-crosshairs"></i>  Add New Row</a>
                    <a class="btn btn-sm btn-danger" href="javascript:void(0);" onclick="delete_row('${new_id}_row');" data-target="${new_id}_row"> <i class="fas fa-crosshairs"></i> Remove Row</a>
                </td>
            </tr>`);
    }

    function delete_row( target ){
        $(`#${target}`).remove();
    }
    $('.delete_row').on('click', function () {
        // fire ajax
        let target = $(this).data('target');
        $(`#${target}`).remove();
    });


</script>
</body>
</html>
