<?php $this->load->view('app/resources/meta'); ?>
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header fixed-footer">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/admin_aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">
                    <div class="col-md-6 col-xl-4">
                        <div class="card mb-3 widget-content">
                            <div class="widget-content-outer">
                                <div class="widget-content-wrapper">
                                    <div class="widget-content-left">
                                        <div class="widget-heading">Today Sales</div>
                                        <div class="widget-subheading"><?= ngn( $today); ?></div>
                                    </div>
                                    <div class="widget-content-right">
                                        <div class="widget-numbers text-success"><i class="fas fa-money-check"></i></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-xl-4">
                        <div class="card mb-3 widget-content">
                            <div class="widget-content-outer">
                                <div class="widget-content-wrapper">
                                    <div class="widget-content-left">
                                        <div class="widget-heading">This Week</div>
                                        <div class="widget-subheading"><?= ngn( $week); ?></div>
                                    </div>
                                    <div class="widget-content-right">
                                        <div class="widget-numbers text-warning"><i class="fas fa-money-check"></i></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-xl-4">
                        <div class="card mb-3 widget-content">
                            <div class="widget-content-outer">
                                <div class="widget-content-wrapper">
                                    <div class="widget-content-left">
                                        <div class="widget-heading">This Month</div>
                                        <div class="widget-subheading"><?= ngn( $month); ?></div>
                                    </div>
                                    <div class="widget-content-right">
                                        <div class="widget-numbers text-danger"><i class="fas fa-money-check"></i></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-xl-4">
                        <div class="card mb-3 widget-content">
                            <div class="widget-content-outer">
                                <div class="widget-content-wrapper">
                                    <div class="widget-content-left">
                                        <div class="widget-heading">Users' Money</div>
                                        <div class="widget-subheading"><?= ngn( $users_money ); ?></div>
                                    </div>
                                    <div class="widget-content-right">
                                        <div class="widget-numbers text-danger"><i class="fas fa-money-check"></i></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-xl-4">
                        <div class="card mb-3 widget-content">
                            <div class="widget-content-outer">
                                <div class="widget-content-wrapper">
                                    <div class="widget-content-left">
                                        <div class="widget-heading">Referral' Money</div>
                                        <div class="widget-subheading"><?= ngn( $referral_money); ?></div>
                                    </div>
                                    <div class="widget-content-right">
                                        <div class="widget-numbers text-danger"><i class="fas fa-money-check"></i></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">

                        <div class="main-card mb-3 card">
                            <div class="card-header">20 Recent Transactions
                            </div>

                            <div class="table-responsive">
                                <table class="table align-middle mb-0 table table-borderless table-striped table-hover">
                                    <thead>
                                    <tr>
                                        <th class="text-center">#</th>
                                        <th>Description</th>
                                        <th class="text-center">Amount</th>
                                        <th class="text-center">Status</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach( $transactions as $transaction ):
                                        ?>
                                        <tr>
                                            <td class="text-center text-muted">#
                                                <a href="<?= base_url('admin/resolution/?trans_id=' . $transaction->trans_id)?>"><?= $transaction->trans_id; ?></a>
                                            </td>
                                            <td>
                                                <?= payment_id_replacer($transaction->description); ?>
                                            </td>
                                            <td class="text-center"><?= ngn($transaction->amount); ?></td>
                                            <td class="text-center">
                                                <?= statusLabel($transaction->status ); ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                    </tbody>
                                </table>
                                <?php if( $transactions) : ?>
                                    <div class="d-block text-center card-footer">
                                        <?= anchor('admin/transactions/', 'View More Transactions', 'class="btn-wide btn btn-success"'); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<script type="text/javascript" src="<?= base_url('assets/app/scripts/main.js'); ?>"></script>
</body>
</html>
