<?php $this->load->view('app/resources/meta'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header fixed-footer">
    <?php $this->load->view('app/resources/nav'); ?>
    <div class="app-main">
        <?php $this->load->view('app/resources/admin_aside'); ?>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <div class="row">
                    <div class="col-md-12">
                        <div class="main-card mb-3 card">
                            <div class="card-header">Transactions</div>
                            <?= form_open(''); ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-1"></div>
                                    <div class="col-md-10">
                                        <?php $this->load->view('msg_view'); ?>
                                        <div class="py-7" style="padding-top: 40px;">
                                            <div class="table-responsive">
                                                <table class="table table-striped table-hover">
                                                    <thead>
                                                    <tr>
                                                        <th style="display: none">ID</th>
                                                        <th>Date</th>
                                                        <th>Detail</th>
                                                        <th>Amount Initiated</th>
                                                        <th>Amount to pay</th>
                                                        <th>Action</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php foreach( $airtime_to_cash_pin as $cash ): ?>
                                                        <tr>
                                                            <td style="display:none;"><?= $cash->id; ?></td>
                                                            <td><?= neatDate($cash->datetime) .' '. neatTime($cash->datetime)?></td>
                                                            <td><?= $cash->details; ?></td>
                                                            <td><?= ngn($cash->incoming)?></td>
                                                            <td><?= ngn($cash->outgoing)?></td>
                                                            <td>
                                                                <form class="form-inline" method="post" action="<?= base_url('admin/airtime/')?>" id="<?= $cash->id?>">
                                                                    <div class="form-group mx-sm-3 mb-2">
                                                                        <label for="action" class="sr-only">Action</label>
                                                                        <select class="form-control-sm" name="action" required>
                                                                            <option value=""> -- Select action --</option>
                                                                            <option value="approve"> Approve </option>
                                                                            <option value="decline"> Decline </option>
                                                                        </select>
                                                                        <input type="hidden" name="transaction_type" value="<?= $cash->type;?>">
                                                                        <input type="hidden" name="txn_id" value="<?= $cash->tid; ?>" />
                                                                        <input type="hidden" name="user_id" value="<?= $cash->uid; ?>" />
                                                                        <input type="hidden" name="amount" value="<?= $cash->outgoing; ?>" />
                                                                        <button type="submit" class="btn btn-sm btn-success mb-2 btn-sm">Submit</button>
                                                                    </div>
                                                                </form>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-1"></div>
                                </div>
                            </div>
                            <?= form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php $this->load->view('app/resources/footer'); ?>
        </div>
    </div>
</div>
<?php $this->load->view('app/resources/script'); ?>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
</body>
</html>
