<?php
/**
 * Created by PhpStorm.
 * User: phillip
 * Date: 2/28/19
 * Time: 10:57 PM
 */

class Site_model extends CI_Model
{

    /**
     * @param string $slug
     * @return CI_DB_row
     */
    function check_slug($slug, $table = 'services')
    {
        do {
            $count = 0;
            $this->db->where('slug', $slug);
            $this->db->from($table);
            if ($this->db->count_all_results() >= 1) {
                $number = random_string('nozero', 6);
                $slug = $slug . '-' . $number;
                $this->db->where('slug', $slug);
                $this->db->from( $table);
                $count = $this->db->count_all_results();
            } else {
                $count = 0;
            }
        } while ($count >= 1);
        return $slug;
    }

    function get_result($table, $select = '', $condition = ''){
        if( $select != '' ){
            $this->db->select($select);
        }
        if( $condition != '' ){
            $this->db->where( $condition );
        }
        return $this->db->get( $table )->result();
    }

    function get_row($table = "users", $select = "", $condition = "" ){
        if( $select != '' ){
            $this->db->select($select);
        }
        if( $condition != '' ){
            $this->db->where( $condition );
        }
        return $this->db->get( $table )->row();
    }


        /**
     * @param array $data
     * @param string $table_name
     * @return int|string
     */
    function insert_data($table_name = 'users', $data = array())
    {
        if (!empty($data)) {
            try {
                $this->db->insert($table_name, $data);
                $result = $this->db->insert_id();
            } catch (Exception $e) {
                $result = $e->getMessage();
            }
            return $result;
        }
    }

    /*
     * Insert batch
     * */
    function insert_batch( $table_name = 'plans', $data = array() ){
        if( !empty($data)) {
            try {
                return $this->db->insert_batch($table_name, $data);
            } catch (Exception $e ) {
                return $e->getMessage();
            }
        }
    }


    function delete( $table, $where ){
        $this->db->where( $where );
        return $this->db->delete( $table );
    }

    // Delete service from admin
    function delete_service( $id ){
        if( $this->delete(array('sid' => $id), 'plans') ){
            return $this->delete(array('id' => $id ), 'services' );
        }
    }

    // Generate code
    //generate_code('transactions', 'trans_id');
    function generate_code($table = 'transactions', $label = 'trans_id')
    {
        do {
            $number = random_string('nozero', 8 );
            $this->db->where($label, $number);
            $this->db->from($table);
            $count = $this->db->count_all_results();
        } while ($count >= 1);
        return $number;
    }

    function find_username($table = 'contacts', $contact = '' )
    {
        if( $this->get_row('contacts', 'id', array('name' => $contact )) ){
            do {
                $random = random_string('nozero', 5);
                $this->db->where($contact, $random);
                $this->db->from($table);
                $count = $this->db->count_all_results();
            } while ($count >= 1);
            return 'PS-'.$random;
        }else{
            return $contact;
        }
    }

    // General SQL query

    function run_sql( $query ){
        return $this->db->query( $query );
    }

    // Change Password
    function change_password($password, $access = '', $table = 'users')
    {
        $salt = salt(50);
        $password = shaPassword($password, $salt);
        $data = array(
            'password' => $password,
            'salt' => $salt
        );
        $this->db->where('id', $access);
        return $this->db->update($table, $data);
    }



    /*
     * Update
     * */

    function update($table = 'users', $data = array(), $condition){
        $this->db->where( $condition );
        return $this->db->update($table, $data);
    }


    function set_field( $table, $field, $set, $where ){
        $this->db->where($where);
        $this->db->set($field, $set, false);
        return $this->db->update($table);
    }

    function auto_version($file = '')
    {
        if (!file_exists($file)):
            return $file;
        else:
            $mtime = filemtime($file);
            return base_url() . $file . '?' . $mtime;
        endif;
    }


    function count_row( $table, $where = array() ){
        $this->db->where( $where );
        $this->db->from( $table );
        return $this->db->count_all_results();
    }

    function check_transaction( $data = array()){
        $query = "SELECT * FROM `transactions`
        WHERE user_id = '" . $data['user_id']. "' 
        AND product_id = '" .$data['product_id']. "'ORDER BY id DESC LIMIT 1";
        $result = $this->db->query( $query )->row();
        return $result;
    }



    function get_downlines( $user_code ) : array{
        $GLOBALS['array_var'] = array();
        $query = $this->db->query("SELECT id, name, user_code FROM users WHERE user_code = ? ", array( $user_code));
        if( $query->num_rows() >= 1 ){
            $new_array = array();
            foreach( $query->result() as $result ){
                $ref_code = $result->user_code;
                $this->recurssive( $ref_code );
                $array = array_filter( $GLOBALS['array_var']);
                $it = new RecursiveIteratorIterator(new RecursiveArrayIterator($array));
                foreach( $it as $v ){
                    array_push( $new_array, $v);
                }
            }
            var_dump($GLOBALS['array_var']);exit;
            return $new_array;
        }else{
            return $GLOBALS['array_var'];
        }
    }

    function recurssive( $ref_code ){
        $user_code = $ref_code;
        $total_users = $this->db->get('users')->result_array();
        $count = count( $total_users );
        $data = $in_array =  array();
        $y = 1;
//        die( $ref_code );
        for ($i=0; $i < $count; $i++) {
            if( $total_users[$i]['referral'] == $user_code ){
                $in_array['level'] = $y;
                $in_array['user_id'] = $total_users[$i]['id'];
                $in_array['name'] = $total_users[$i]['name'];
                $in_array['ref_code'] = $total_users[$i]['user_code'];
                array_push( $data , $in_array );
                $y++;
            }
        }

//        var_dump($data);exit;
        array_push( $GLOBALS['array_var'], $data);
        foreach ($data as $key => $value) {
            $this->recurssive($value['ref_code']);
        }
    }

    function my_downlines( $user_code ){
        $this->db->select('user_code, name, id');
        $this->db->where( 'referral', $user_code );
        return $this->db->get('users')->result();
    }


    /*
        Return an object (name, slug, description, specifications) of all the parent of a category
    */

    function uplines($referral_code)
    {
        // Select category
        $GLOBALS['array_variable'] = array();
        $select_category = "SELECT id, referral FROM users WHERE referral = {$referral_code}";
        $result = $this->db->query($select_category);
        if ($result->num_rows() >= 1) {
            $referral = $result->row()->referral;
            $this->uplines_recussive($referral);
            $array = array_filter($GLOBALS['array_variable']);
            $it = new RecursiveIteratorIterator(new RecursiveArrayIterator($array));
            $new_array = array();
            foreach ($it as $v) {
                array_push($new_array, $v);
            }
//            array_push($new_array, $id); // Lets push its own ID also
            return $new_array;
        } else {
            return $GLOBALS['array_variable'];
        }

    }
    /*
    *Called by the parent_slug top, helps to generate the parent id
    */

    function uplines_recussive($referral)
    {

        $total_categories = $this->db->get('users')->result_array();
        $count = count($total_categories);
        $data = array();
        for ($i = 0; $i < $count; $i++) {
            if ($total_categories[$i]['referral'] == $referral) {
                array_push($data, $total_categories[$i]['referral']);
            }
        }
        array_push($GLOBALS['array_variable'], $data);
        foreach ($data as $key => $value) {
            $this->uplines_recussive($value);
        }
    }

}