<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Email_model extends CI_Model {


    function reset_password( $data ){
        $post = array(
            'subject' => 'Reset Password Confirmation',
            'to' => $data['email'],
            'template' => 'UserPasswordReset',
            'merge_reset_link' => $data['reset_link'],
            'isTransactional' => false
        );
        return $this->send_now($post);
    }

    function welcome_user( $data ){
        $post = array(
            'subject' => 'Welcome to Onitshamarket Seller Center',
            'to' => $data['email'],
            'template' => 'WelcomeSellerUser',
            'merge_recipent' => $data['recipent'],
            'merge_subject' => 'Welcome to Onitshamarket Seller Center',
            'isTransactional' => false
        );
        return $this->send_now($post);
    }

    // Welcome user for new account creates
    function welcome_buyer( $data ){
        $post = array(
            'subject' => 'Welcome to Onitshamarket' ,
            'to' => $data['email'],
            'from' => 'info@onitshamarket.com',
            'template' => 'WelcomeNewUser',
            'merge_recipent' => $data['recipent'],
            'isTransactional' => false
        );
        return $this->send_now($post);
    }


    // Payment request
    function payment_request( $data ){
        $post = array(
            'subject' => 'Payment Request Initiated',
            'to' => $data['email'],
            'from' => 'seller.payment@onitshamarket.com',
            'template' => 'PaymentRequest',
            'merge_recipent' => $data['recipent'],
            'merge_link' => $data['link'],
            'isTransactional' => false
        );
        return $this->send_now($post);
    }


    // Bill Receipt
    function bill_receipt($data){
        $post = array(
            'subject' => 'Receipt for ' . $data['product_name'] ,
            'to' => $data['email'],
            'from' => 'no-reply@payscribe.ng',
            'template' => 'ElectricityMultichoiceReceipt',
            'merge_recipent' => $data['firstname'],
            'merge_product_name' => $data['product_name'],
            'merge_transaction_id' => $data['transaction_id'],
            'merge_date_initiated' => $data['date_initiated'],
            'merge_amount' => $data['amount'],
            'merge_accountaddress' => $data['email'],
            'isTransactional' => false
        );
        return $this->send_now($post);
    }

    // Curl function to send
    function send_now($post){
        $url = 'https://api.elasticemail.com/v2/email/send';
        try{
            $post['merge_base_url'] = base_url();
            $post['fromName'] = 'Payscribe.ng';
            $post['apikey'] = ELASTIC_EMAIL_API;
            $ch = curl_init();
            curl_setopt_array($ch, array(
                CURLOPT_URL => $url,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => $post,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_HEADER => false,
                CURLOPT_SSL_VERIFYPEER => false
            ));
            $result = curl_exec($ch);
            curl_close ($ch);
            return $result;
        }catch(Exception $ex){
            $this->session->set_flashdata('error_msg',$ex->getMessage());
            return false;
        }
    }

    //Server email
    function do_email($msg=NULL, $sub=NULL, $to=NULL, $from=NULL){
        $config = array();
        $config['useragent']	= "CodeIgniter";
//        $config['mailpath']		= "/usr/bin/sendmail"; // or "/usr/sbin/sendmail"
        $config['protocol']		= "smtp";
        $config['smtp_host']	= "localhost";
        $config['smtp_port']	= "25";
        $config['mailtype']		= 'html';
        $config['charset']		= 'utf-8';
        $config['newline']		= "\r\n";
        $config['wordwrap']		= TRUE;
        $this->load->library('email');
        $this->email->clear();
        $this->email->initialize($config);
        $system_name	=	lang('app_name');
        if($from == NULL)
            $from		=	'noreply@onitshamarket.com';
        $this->email->from($from, $system_name);
        $this->email->to($to);
        $this->email->subject($sub);
        $this->email->message($msg);
        if( $this->email->send()){return true;}else{return false;}
    }
}