<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Multichoice {
    public function __construct(){
        $this->CI =& get_instance();
    }

    // Multichoice validation

    public function multichoice_validation( $array ){
//        var_dump( $array ); exit;
        // Get the Authorization
        $key = ORGANIZATION_KEY;
        $organization_code = ORGANIZATION_CODE;
        $username = ORGANIZATION_USERNAME;
        $date = "2018-05-01 1:52 PM";
        $request_body = array(
            "wallet" => PAYVICE_TERMINAL_ID,
            "username" => PAYVICE_USERNAME,
            "type" => $array['multichoice_type'],
            "channel" => "WEB",
            "account" => $array['smart_card_number'],
            "pin" => PAYVICE_PIN
        );

        $hashed_utf_encoded_string = hash('sha512', utf8_encode(json_encode( $request_body )));
        $key_username = $key . $username;
        $token = base64_encode($key_username);
        $signature = hash_hmac('sha256', $hashed_utf_encoded_string, $token, true);
        $authorization = strtoupper($username)."-".base64_encode($signature . $date . $organization_code);
        $ch = curl_init();
        $encoded_requestBody = utf8_encode(json_encode($request_body));
        curl_setopt($ch, CURLOPT_URL, PAYVICE_BASE_URL."/vas/multichoice/validation");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_requestBody);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: " .$authorization,
            "Date: 2018-05-01 1:52 PM",
            "Username: " .ORGANIZATION_USERNAME,
            "OrganisationCode: ".ORGANIZATION_CODE,
            "Vend-Type: B2B"
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if ($err) {
            return array('status' => false);
        } else {
            $response = json_decode( $response );
            if( $response->error ){
                return array('status' => false, 'message' => $response);
            }else{
                return(array('status' => true, 'customer_smart_card_name' => $response->name, 'bouquets' => $response->bouquets, 'productCode' => $response->productCode));
            }
        }
    }


    // Multichoice payment
    public function multichoice_payment( $data ){
        // Get the Authorization
        $key = ORGANIZATION_KEY;
        $organization_code = ORGANIZATION_CODE;
        $username = ORGANIZATION_USERNAME;
        $date = "2018-05-01 1:52 PM";
        $request_body = array(
            "wallet" => PAYVICE_TERMINAL_ID,
            "username" => PAYVICE_USERNAME,
            "password" => PAYVICE_PWD,
            "pin" => PAYVICE_PIN,
            "type" => "{$data['multichoice_type']}",
            'code' => "{$data['product_code']}",
            "channel" => "WEB",
            "account" => "{$data['smart_card_number']}",
            "amount" => $data['amount'] * 100,
            "phone" => "{$data['phone_number']}",
            "productCode" => "{$data['productCode']}",
            "customerName" => "{$data['customer_name']}",
            "paymentMethod" => "cash",
            "clientReference" => $data['transaction_id'],
            'pfm' => array(
                'state' => array(
                    'serial' => '323-890-383',
                    'ctime' => '',
                    'bl'    => 43,
                    'cs'    => 'NotCharging',
                    'ps'    => 'PrinterOk',
                    'tid'   => '20351K59',
                    'coms'  => 'EGPRS',
                    'sim'   => '',
                    'cloc'  => '',
                    'ss'    => '67',
                    'tmn'   => 'VX5202',
                    'tmanu' => 'Verizone',
                    'hb'    => 'true',
                    'sv'    => '7.8.13',
                    'ITxnAT'    => get_now(),
                    'pads'  => '',
                    'customField' => ''
                ),
                'journal' => array(
                    "stan" => "",
                    "mPan" => "",
                    "rrn" => "",
                    "acode" => "",
                    "amount" => $data['amount'] * 100,
                    "timestamp" => get_now(),
                    "mti" => "0200",
                    "ps" => "001000",
                    "resp" => "",
                    "tap" => "true",
                    "rep" => "",
                    "vm" => "OfflinePin",
                    "ostan" => "",
                    "orrn" => "",
                    "oacode" => "",
                    "mid" => "",
                    "vasCategory" => "{$data['multichoice_type']}",
                    "vasProduct" => "Sub Product Type",
                    "mcc" => "",
                    "transMethod" =>  "cash",
                    "customField" => ""
                )
            )
        );

        $hashed_utf_encoded_string = hash('sha512', utf8_encode(json_encode( $request_body )));
        $key_username = $key . $username;
        $token = base64_encode($key_username);
        $signature = hash_hmac('sha256', $hashed_utf_encoded_string, $token, true);
        $authorization = strtoupper($username)."-".base64_encode($signature . $date . $organization_code);
        $ch = curl_init();
        $encoded_requestBody = utf8_encode(json_encode($request_body));
        curl_setopt($ch, CURLOPT_URL, PAYVICE_BASE_URL."/vas/multichoice/payment");

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_requestBody);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: " .$authorization,
            "Date: 2018-05-01 1:52 PM",
            "Username: ". ORGANIZATION_USERNAME,
            "OrganisationCode: ". ORGANIZATION_CODE,
            "Vend-Type: B2B"
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if ($err) {
            return array('status' => false, 'message' => $err);
        } else {
            $response = json_decode( $response );
            if( $response->error ){
                $return_data = array(
                    'status' => false
                );
            }else{
                $return_data = array(
                    'status' => true,
                    'message' => $response->message,
                    'reference_id' => $response->reference
                );
            }
//            var_dump( $response );exit;
            return( $return_data );
        }

    }
}
