<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Electricity {
    public function __construct(){
        $this->CI =& get_instance();
    }


    // Ikeja validate
    public function ikeja_validate( $meter_number ){
        // Get the Authorization
        $key = ORGANIZATION_KEY;
        $organization_code = ORGANIZATION_CODE;
        $username = ORGANIZATION_USERNAME;
        $date = "2018-05-01 1:52 PM";
        $request_body = array(
            "terminal_id" => PAYVICE_TERMINAL_ID,
            "terminal" => PAYVICE_TERMINAL_ID,
            "user_id" => PAYVICE_USERNAME,
            "password" => PAYVICE_PWD,
            "account" => "{$meter_number}",
            "type" => "getcus",
            "service_type" => "pay",
            "service" => "postpaid",
            'pfm' => array(
                'state' => array(
                    'serial' => '323-890-383',
                    'ctime' => '',
                    'bl'    => 43,
                    'cs'    => 'NotCharging',
                    'ps'    => 'PrinterOk',
                    'tid'   => '20351K59',
                    'coms'  => 'EGPRS',
                    'sim'   => '',
                    'cloc'  => '',
                    'ss'    => '67',
                    'tmn'   => 'VX5202',
                    'tmanu' => 'Verizone',
                    'hb'    => 'true',
                    'sv'    => '7.8.13',
                    'ITxnAT'    => get_now(),
                    'pads'  => '',
                    'customField' => 'Validation For Ikeja ELectricity...'
                ),
                'journal' => array(
                    "stan" => "194238",
                    "mPan" => "439983XXXXXX4686",
                    "rrn" => "000019856870",
                    "acode" => "083849",
                    "amount" => 8,
                    "timestamp" => "",
                    "mti" => "0200",
                    "ps" => "001000",
                    "resp" => "00",
                    "tap" => "true",
                    "rep" => "",
                    "vm" => "OfflinePin",
                    "ostan" => "",
                    "orrn" => "",
                    "oacode" => "",
                    "mid" => "2082RI000606212",
                    "vasCategory" => "IKEDC",
                    "vasProduct" => "Sub Product Type",
                    "mcc" => "5555",
                    "transMethod" =>  "cash",
                    "customField" => ""
                )
            )
        );
        $hashed_utf_encoded_string = hash('sha512', utf8_encode(json_encode( $request_body )));
        $key_username = $key . $username;
        $token = base64_encode($key_username);
        $signature = hash_hmac('sha256', $hashed_utf_encoded_string, $token, true);
        $authorization = strtoupper($username)."-".base64_encode($signature . $date . $organization_code);
        $ch = curl_init();
        $encoded_requestBody = utf8_encode(json_encode($request_body));
        curl_setopt($ch, CURLOPT_URL, PAYVICE_BASE_URL."/vas/ie/validate");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_requestBody);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: " .$authorization,
            "Date: 2018-05-01 1:52 PM",
            "Username: ".ORGANIZATION_USERNAME,
            "OrganisationCode: ". ORGANIZATION_CODE,
            "Vend-Type: B2B"
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if ($err) {
            return($err);
        } else {
            $response = json_decode( $response );
            if( $response->error ){
                return false;
            }else{
                return($response->name);
            }
        }
    }
    // Payment for Ikeja Prepaid Electricity

    public function ikeja_prepaid_payment( $data = array()){
        // Get the Authorization
        $key = ORGANIZATION_KEY;
        $organization_code = ORGANIZATION_CODE;
        $username = ORGANIZATION_USERNAME;
        $date = "2018-05-01 1:52 PM";
        $request_body = array(
            "terminal_id" => PAYVICE_TERMINAL_ID,
            "terminal" => PAYVICE_TERMINAL_ID,
            "user_id" => PAYVICE_USERNAME,
            "password" => PAYVICE_PWD,
            "phone" => "{$data['phone_number']}",
            "amount" => "{$data['amount']}",
            "pin" => "",
            "account" => "{$data['meter_number']}", // Prepaid Meter number
            "type" => "getcus",
            "service_type" => "vend",
            "service" => "token",
            "channel" => "WEB",
            "clientReference" => "{$data['transaction_id']}",
            'pfm' => array(
                'state' => array(
                    'serial' => '323-890-383',
                    'ctime' => '',
                    'bl'    => 43,
                    'cs'    => 'NotCharging',
                    'ps'    => 'PrinterOk',
                    'tid'   => '20351K59',
                    'coms'  => 'EGPRS',
                    'sim'   => '',
                    'cloc'  => '',
                    'ss'    => '67',
                    'tmn'   => 'VX5202',
                    'tmanu' => 'Verizone',
                    'hb'    => 'true',
                    'sv'    => '7.8.13',
                    'ITxnAT'    => get_now(),
                    'pads'  => '',
                    'customField' => 'Payment for Electricity Bill...'
                ),
                'journal' => array(
                    "stan" => "",
                    "mPan" => "",
                    "rrn" => "",
                    "acode" => "",
                    "amount" => "{$data['amount']}",
                    "timestamp" => get_now(),
                    "mti" => "0200",
                    "ps" => "001000",
                    "resp" => "",
                    "tap" => "true",
                    "rep" => "",
                    "vm" => "OfflinePin",
                    "ostan" => "",
                    "orrn" => "",
                    "oacode" => "",
                    "mid" => "",
                    "vasCategory" => "IKEDC",
                    "vasProduct" => "Sub Product Type",
                    "mcc" => "",
                    "transMethod" =>  "cash",
                    "customField" => ""
                )
            )
        );
        $hashed_utf_encoded_string = hash('sha512', utf8_encode(json_encode( $request_body )));
        $key_username = $key . $username;
        $token = base64_encode($key_username);
        $signature = hash_hmac('sha256', $hashed_utf_encoded_string, $token, true);
        $authorization = strtoupper($username)."-".base64_encode($signature . $date . $organization_code);
        $ch = curl_init();
        $encoded_requestBody = utf8_encode(json_encode($request_body));
        curl_setopt($ch, CURLOPT_URL, PAYVICE_BASE_URL."/vas/ie/purchase");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_requestBody);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: " .$authorization,
            "Date: 2018-05-01 1:52 PM",
            "Username: ".ORGANIZATION_USERNAME,
            "OrganisationCode: ". ORGANIZATION_CODE,
            "Vend-Type: B2B"
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if ($err) {
            //return "cURL Error #:" . $err;
            return($err);
        } else {
            $response = json_decode( $response );
            if( $response->error ){
                $return_data = array(
                    'status' => false,
                );
            }else{
                $return_data = array(
                    'status' => true,
                    'message' => $response->message ." with reference number: " . $response->ref
                );
            }
            return( $return_data );
        }
    }


    // Payment for POST PAID Electricity
    public function ikeja_postpaid_payment( $data = array() ){
        // Get the Authorization
        $key = ORGANIZATION_KEY;
        $organization_code = ORGANIZATION_CODE;
        $username = ORGANIZATION_USERNAME;
        $date = "2018-05-01 1:52 PM";
        $request_body = array(
            "terminal_id" => PAYVICE_TERMINAL_ID,
            "terminal" => PAYVICE_TERMINAL_ID,
            "user_id" => PAYVICE_USERNAME,
            "password" => PAYVICE_PWD,
            "phone" => "{$data['phone_number']}",
            "amount" => "{$data['amount']}",
            "channel" => "WEB",
            "pin" => PAYVICE_PIN,
            "account" => "{$data['meter_number']}", // Postpaid number
            "type" => "getcus",
            "service_type" => "pay",
            "service" => "postpaid",
            "clientReference" => "{$data['transaction_id']}",
            'pfm' => array(
                'state' => array(
                    'serial' => '323-890-383',
                    'ctime' => '',
                    'bl'    => 43,
                    'cs'    => 'NotCharging',
                    'ps'    => 'PrinterOk',
                    'tid'   => '20351K59',
                    'coms'  => 'EGPRS',
                    'sim'   => '',
                    'cloc'  => '',
                    'ss'    => '67',
                    'tmn'   => 'VX5202',
                    'tmanu' => 'Verizone',
                    'hb'    => 'true',
                    'sv'    => '7.8.13',
                    'ITxnAT'    => get_now(),
                    'pads'  => '',
                    'customField' => 'Payment for Electricity Bill...'
                ),
                'journal' => array(
                    "stan" => "",
                    "mPan" => "",
                    "rrn" => "",
                    "acode" => "",
                    "amount" => "{$data['amount']}",
                    "timestamp" => get_now(),
                    "mti" => "0200",
                    "ps" => "001000",
                    "resp" => "",
                    "tap" => "true",
                    "rep" => "",
                    "vm" => "OfflinePin",
                    "ostan" => "",
                    "orrn" => "",
                    "oacode" => "",
                    "mid" => "",
                    "vasCategory" => "IKEDC",
                    "vasProduct" => "Sub Product Type",
                    "mcc" => "",
                    "transMethod" =>  "cash",
                    "customField" => ""
                )
            )
        );
        $hashed_utf_encoded_string = hash('sha512', utf8_encode(json_encode( $request_body )));
        $key_username = $key . $username;
        $token = base64_encode($key_username);
        $signature = hash_hmac('sha256', $hashed_utf_encoded_string, $token, true);
        $authorization = strtoupper($username)."-".base64_encode($signature . $date . $organization_code);
        $ch = curl_init();
        $encoded_requestBody = utf8_encode(json_encode($request_body));
        curl_setopt($ch, CURLOPT_URL, PAYVICE_BASE_URL."/vas/ie/purchase");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_requestBody);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: " .$authorization,
            "Date: 2018-05-01 1:52 PM",
            "Username: ".ORGANIZATION_USERNAME,
            "OrganisationCode: ". ORGANIZATION_CODE,
            "Vend-Type: B2B"
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if ($err) {
            return array('status' => false);
        } else {
            $response = json_decode( $response );
            if( $response->error ){
                $return_data = array(
                    'status' => false,
                );
            }else{
                $return_data = array(
                    'status' => true,
                    'message' => $response->message . " with reference number: " . $response->ref
                );
            }
            return( $return_data );
        }
    }


    // EKO VALIDATE

    public function eko_validate( $meter_number){
        // Get the Authorization
        $key = ORGANIZATION_KEY;
        $organization_code = ORGANIZATION_CODE;
        $username = ORGANIZATION_USERNAME;
        $date = "2018-05-01 1:52 PM";
        $request_body = array(
            "terminal_id" => PAYVICE_TERMINAL_ID,
            "terminal" => PAYVICE_TERMINAL_ID,
            "user_id" => PAYVICE_USERNAME,
            "password" => PAYVICE_PWD,
            "meter" => "{$meter_number}",
            "type" => "getcus",
            "service_type" => "pay",
            "service" => "postpaid",
            'pfm' => array(
                'state' => array(
                    'serial' => '323-890-383',
                    'ctime' => '',
                    'bl'    => 43,
                    'cs'    => 'NotCharging',
                    'ps'    => 'PrinterOk',
                    'tid'   => '20351K59',
                    'coms'  => 'EGPRS',
                    'sim'   => '',
                    'cloc'  => '',
                    'ss'    => '67',
                    'tmn'   => 'VX5202',
                    'tmanu' => 'Verizone',
                    'hb'    => 'true',
                    'sv'    => '7.8.13',
                    'ITxnAT'    => get_now(),
                    'pads'  => '',
                    'customField' => 'Payment for Electricity Bill...'
                ),
                'journal' => array(
                    "stan" => "194238",
                    "mPan" => "439983XXXXXX4686",
                    "rrn" => "000019856870",
                    "acode" => "083849",
                    "amount" => 8,
                    "timestamp" => "",
                    "mti" => "0200",
                    "ps" => "001000",
                    "resp" => "00",
                    "tap" => "true",
                    "rep" => "",
                    "vm" => "OfflinePin",
                    "ostan" => "",
                    "orrn" => "",
                    "oacode" => "",
                    "mid" => "2082RI000606212",
                    "vasCategory" => "IKEDC",
                    "vasProduct" => "Sub Product Type",
                    "mcc" => "5555",
                    "transMethod" =>  "cash",
                    "customField" => ""
                )
            )
        );
        $hashed_utf_encoded_string = hash('sha512', utf8_encode(json_encode( $request_body )));
        $key_username = $key . $username;
        $token = base64_encode($key_username);
        $signature = hash_hmac('sha256', $hashed_utf_encoded_string, $token, true);
        $authorization = strtoupper($username)."-".base64_encode($signature . $date . $organization_code);
        $ch = curl_init();
        $encoded_requestBody = utf8_encode(json_encode($request_body));
        curl_setopt($ch, CURLOPT_URL, PAYVICE_BASE_URL."/ekedc/vas/validate");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_requestBody);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: " .$authorization,
            "Date: 2018-05-01 1:52 PM",
            "Username: ".ORGANIZATION_USERNAME,
            "OrganisationCode: ". ORGANIZATION_CODE,
            "Vend-Type: B2B"
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if ($err) {
            return false;
        } else {
            $response = json_decode( $response );
            if( $response->error ){
                return false;
            }else{
                return($response->name);
            }
        }
    }


    // EKO PREPAID PAYMENT
    public function eko_prepaid_payment( $data = array() ){
        // Get the Authorization
        $key = ORGANIZATION_KEY;
        $organization_code = ORGANIZATION_CODE;
        $username = ORGANIZATION_USERNAME;
        $date = "2018-05-01 1:52 PM";
        $request_body = array(
            "terminal_id" => PAYVICE_TERMINAL_ID,
            "terminal" => PAYVICE_TERMINAL_ID,
            "user_id" => PAYVICE_USERNAME,
            "password" => PAYVICE_PWD,
            "phone" => "{$data['phone_number']}",
            "amount" => "{$data['amount']}",
            "pin" => PAYVICE_PIN,
            "channel" => "WEB",
            "meter" => "{$data['meter_number']}", // Prepaid Meter number
            "clientReference" => "{$data['transaction_id']}",
            'pfm' => array(
                'state' => array(
                    'serial' => '323-890-383',
                    'ctime' => '',
                    'bl'    => 43,
                    'cs'    => 'NotCharging',
                    'ps'    => 'PrinterOk',
                    'tid'   => '20351K59',
                    'coms'  => 'EGPRS',
                    'sim'   => '',
                    'cloc'  => '',
                    'ss'    => '67',
                    'tmn'   => 'VX5202',
                    'tmanu' => 'Verizone',
                    'hb'    => 'true',
                    'sv'    => '7.8.13',
                    'ITxnAT'    => get_now(),
                    'pads'  => '',
                    'customField' => 'Payment for Eko Electricity Bill...'
                ),
                'journal' => array(
                    "stan" => "",
                    "mPan" => "",
                    "rrn" => "",
                    "acode" => "",
                    "amount" => "{$data['amount']}",
                    "timestamp" => get_now(),
                    "mti" => "0200",
                    "ps" => "001000",
                    "resp" => "",
                    "tap" => "true",
                    "rep" => "",
                    "vm" => "OfflinePin",
                    "ostan" => "",
                    "orrn" => "",
                    "oacode" => "",
                    "mid" => "",
                    "vasCategory" => "EKO",
                    "vasProduct" => "Sub Product Type",
                    "mcc" => "",
                    "transMethod" =>  "cash",
                    "customField" => ""
                )
            )
        );

        $hashed_utf_encoded_string = hash('sha512', utf8_encode(json_encode( $request_body )));
        $key_username = $key . $username;
        $token = base64_encode($key_username);
        $signature = hash_hmac('sha256', $hashed_utf_encoded_string, $token, true);
        $authorization = strtoupper($username)."-".base64_encode($signature . $date . $organization_code);
        $ch = curl_init();
        $encoded_requestBody = utf8_encode(json_encode($request_body));
        curl_setopt($ch, CURLOPT_URL, PAYVICE_BASE_URL."/ekedc/vas/payment/process");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_requestBody);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: " .$authorization,
            "Date: 2018-05-01 1:52 PM",
            "Username: ".ORGANIZATION_USERNAME,
            "OrganisationCode: ". ORGANIZATION_CODE,
            "Vend-Type: B2B"
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if ($err) {
            return array('status' => false);
        } else {
            $response = json_decode( $response );
            if( $response->error ){
                $return_data = array(
                    'status' => false,
                );
            }else{
                $return_data = array(
                    'status' => true,
                    'message' => $response->message ." With reference number: " . $response->ref
                );
            }
            return( $return_data );
        }
    }


    // EKO POSTPAID

    public function eko_postpaid_payment( $data = array()){
        // Get the Authorization
        $key = ORGANIZATION_KEY;
        $organization_code = ORGANIZATION_CODE;
        $username = ORGANIZATION_USERNAME;
        $date = "2018-05-01 1:52 PM";
        $request_body = array(
            "meter" => "024619013401",
            "accountType" => "postpaid",
            "amount" => "{$data['amount']}",
            "terminal_id" => PAYVICE_TERMINAL_ID,
            "phone" => "{$data['phone_number']}",
            "user_id" => PAYVICE_USERNAME,
            "type" => "cash",
            "password" => PAYVICE_PWD,
            "pin" => PAYVICE_PIN,
            "channel" => "WEB",
            "clientReference" => "{$data['transaction_id']}",
            'pfm' => array(
                'state' => array(
                    'serial' => '323-890-383',
                    'ctime' => '',
                    'bl'    => 43,
                    'cs'    => 'NotCharging',
                    'ps'    => 'PrinterOk',
                    'tid'   => '20351K59',
                    'coms'  => 'EGPRS',
                    'sim'   => '',
                    'cloc'  => '',
                    'ss'    => '67',
                    'tmn'   => 'VX5202',
                    'tmanu' => 'Verizone',
                    'hb'    => 'true',
                    'sv'    => '7.8.13',
                    'ITxnAT'    => get_now(),
                    'pads'  => '',
                    'customField' => 'Payment for Electricity Bill...'
                ),
                'journal' => array(
                    "stan" => "",
                    "mPan" => "",
                    "rrn" => "",
                    "acode" => "",
                    "amount" => "{$data['amount']}",
                    "timestamp" => get_now(),
                    "mti" => "0200",
                    "ps" => "001000",
                    "resp" => "",
                    "tap" => "true",
                    "rep" => "",
                    "vm" => "OfflinePin",
                    "ostan" => "",
                    "orrn" => "",
                    "oacode" => "",
                    "mid" => "",
                    "vasCategory" => "EKO",
                    "vasProduct" => "Sub Product Type",
                    "mcc" => "",
                    "transMethod" =>  "cash",
                    "customField" => ""
                )
            )
        );
        $hashed_utf_encoded_string = hash('sha512', utf8_encode(json_encode( $request_body )));
        $key_username = $key . $username;
        $token = base64_encode($key_username);
        $signature = hash_hmac('sha256', $hashed_utf_encoded_string, $token, true);
        $authorization = strtoupper($username)."-".base64_encode($signature . $date . $organization_code);
        $ch = curl_init();
        $encoded_requestBody = utf8_encode(json_encode($request_body));
        curl_setopt($ch, CURLOPT_URL, PAYVICE_BASE_URL."/ekedc/vas/payment/process");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_requestBody);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: " .$authorization,
            "Date: 2018-05-01 1:52 PM",
            "Username: ".ORGANIZATION_USERNAME,
            "OrganisationCode: ". ORGANIZATION_CODE,
            "Vend-Type: B2B"
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if ($err) {
            //return "cURL Error #:" . $err;
            return array('status' => false, 'message' => $err);
        } else {
            $response = json_decode( $response );
            if( $response->error ){
                $return_data = array(
                    'status' => false,
                );
            }else{
                $return_data = array(
                    'status' => true,
                    'message' => $response->message . " with reference number: " . $response->ref
                );
            }
            return( $return_data );
        }
    }


    // ENUGU PREPAID VALIDATION
    public function enugu_prepaid_validate( $meter_number ){
        // Get the Authorization
        $key = ORGANIZATION_KEY;
        $organization_code = ORGANIZATION_CODE;
        $username = ORGANIZATION_USERNAME;
        $date = "2018-05-01 1:52 PM";
        $request_body = array(
//            "terminal_id" => PAYVICE_TERMINAL_ID",
            "wallet" => PAYVICE_WALLET_ID,
            "username" => "27613263",
            "user_id" => PAYVICE_USERNAME,
            "password" => PAYVICE_PWD,
            "account" => "{$meter_number}",
            "channel" => "WEB",
            "type" => "prepaid",
            'pfm' => array(
                'state' => array(
                    'serial' => '323-890-383',
                    'ctime' => '',
                    'bl'    => 43,
                    'cs'    => 'NotCharging',
                    'ps'    => 'PrinterOk',
                    'tid'   => '20351K59',
                    'coms'  => 'EGPRS',
                    'sim'   => '',
                    'cloc'  => '',
                    'ss'    => '67',
                    'tmn'   => 'VX5202',
                    'tmanu' => 'Verizone',
                    'hb'    => 'true',
                    'sv'    => '7.8.13',
                    'ITxnAT'    => get_now(),
                    'pads'  => '',
                    'customField' => 'Validation for Enugu Electricity Bill...'
                ),
                'journal' => array(
                    "stan" => "194238",
                    "mPan" => "439983XXXXXX4686",
                    "rrn" => "000019856870",
                    "acode" => "083849",
                    "amount" => 8,
                    "timestamp" => "",
                    "mti" => "0200",
                    "ps" => "001000",
                    "resp" => "00",
                    "tap" => "true",
                    "rep" => "",
                    "vm" => "OfflinePin",
                    "ostan" => "",
                    "orrn" => "",
                    "oacode" => "",
                    "mid" => "2082RI000606212",
                    "vasCategory" => "ENUGU VALIDATION",
                    "vasProduct" => "Sub Product Type",
                    "mcc" => "5555",
                    "transMethod" =>  "cash",
                    "customField" => ""
                )
            )
        );

        $hashed_utf_encoded_string = hash('sha512', utf8_encode(json_encode( $request_body )));
        $key_username = $key . $username;
        $token = base64_encode($key_username);
        $signature = hash_hmac('sha256', $hashed_utf_encoded_string, $token, true);
        $authorization = strtoupper($username)."-".base64_encode($signature . $date . $organization_code);
        $ch = curl_init();
        $encoded_requestBody = utf8_encode(json_encode($request_body));
        curl_setopt($ch, CURLOPT_URL, PAYVICE_BASE_URL."/vas/eedc/validation");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_requestBody);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: " .$authorization,
            "Date: 2018-05-01 1:52 PM",
            "Username: ".ORGANIZATION_USERNAME,
            "OrganisationCode: ". ORGANIZATION_CODE,
            "Vend-Type: B2B"
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if ($err) {
            return array('status' => false, 'message' => $err);
        } else {
            $response = json_decode( $response );
            if( $response->error ){
                return false;
            }else{
                $this->CI->session->set_userdata(array('product_code' => $response->productCode) );
                return($response->name);
            }
        }
    }

    // ENUGU POSTPAID VALIDATION

    public function enugu_postpaid_validate( $meter_number){
        // Get the Authorization
        $key = ORGANIZATION_KEY;
        $organization_code = ORGANIZATION_CODE;
        $username = ORGANIZATION_USERNAME;
        $date = "2018-05-01 1:52 PM";
        $request_body = array(
            "wallet" => PAYVICE_WALLET_ID,
            "username" => "27613263",
            "user_id" => PAYVICE_USERNAME,
            "password" => PAYVICE_PWD,
            "account" => "{$meter_number}",
            "channel" => "WEB",
            "type" => "postpaid",
            'pfm' => array(
                'state' => array(
                    'serial' => '323-890-383',
                    'ctime' => '',
                    'bl'    => 43,
                    'cs'    => 'NotCharging',
                    'ps'    => 'PrinterOk',
                    'tid'   => '20351K59',
                    'coms'  => 'EGPRS',
                    'sim'   => '',
                    'cloc'  => '',
                    'ss'    => '67',
                    'tmn'   => 'VX5202',
                    'tmanu' => 'Verizone',
                    'hb'    => 'true',
                    'sv'    => '7.8.13',
                    'ITxnAT'    => get_now(),
                    'pads'  => '',
                    'customField' => 'Payment for Electricity Bill...'
                ),
                'journal' => array(
                    "stan" => "194238",
                    "mPan" => "439983XXXXXX4686",
                    "rrn" => "000019856870",
                    "acode" => "083849",
                    "amount" => 8,
                    "timestamp" => "",
                    "mti" => "0200",
                    "ps" => "001000",
                    "resp" => "00",
                    "tap" => "true",
                    "rep" => "",
                    "vm" => "OfflinePin",
                    "ostan" => "",
                    "orrn" => "",
                    "oacode" => "",
                    "mid" => "2082RI000606212",
                    "vasCategory" => "ENUGU VALIDATION",
                    "vasProduct" => "Sub Product Type",
                    "mcc" => "5555",
                    "transMethod" =>  "cash",
                    "customField" => ""
                )
            )
        );
        $hashed_utf_encoded_string = hash('sha512', utf8_encode(json_encode( $request_body )));
        $key_username = $key . $username;
        $token = base64_encode($key_username);
        $signature = hash_hmac('sha256', $hashed_utf_encoded_string, $token, true);
        $authorization = strtoupper($username)."-".base64_encode($signature . $date . $organization_code);
        $ch = curl_init();
        $encoded_requestBody = utf8_encode(json_encode($request_body));
        curl_setopt($ch, CURLOPT_URL, PAYVICE_BASE_URL."/vas/eedc/validation");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_requestBody);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: " .$authorization,
            "Date: 2018-05-01 1:52 PM",
            "Username: ".ORGANIZATION_USERNAME,
            "OrganisationCode: ". ORGANIZATION_CODE,
            "Vend-Type: B2B"
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if ($err) {
            return array('status' => false, 'message' => $err);
        } else {
            $response = json_decode( $response );
            if( $response->error ){
                return false;
            }else{
                $this->CI->session->set_userdata(array('product_code' => $response->productCode) );
                return($response->name);
            }
        }
    }


    // ENUGU PREPAID PAYMENT
    public function enugu_prepaid_payment( $data = array()){
        // Get the Authorization
        $key = ORGANIZATION_KEY;
        $organization_code = ORGANIZATION_CODE;
        $username = ORGANIZATION_USERNAME;
        $date = "2018-05-01 1:52 PM";
        $request_body = array(
            "wallet" => PAYVICE_WALLET_ID,
            "username" => PAYVICE_USERNAME,
            "password" =>  PAYVICE_PWD,
            "type" =>  "prepaid",
            "channel" =>  "WEB",
            "account" =>  "{$data['meter_number']}",
            "amount" =>  $data['amount'],
            "phone" =>  "{$data['phone_number']}",
            "productCode" =>  $this->session->userdata('product_code'),
            "customerName" =>  "{$data['customer_name']}",
            "paymentMethod" =>  "cash",
            "pin" => PAYVICE_PIN,

            'pfm' => array(
                'state' => array(
                    'serial' => '323-890-383',
                    'ctime' => '',
                    'bl'    => 43,
                    'cs'    => 'NotCharging',
                    'ps'    => 'PrinterOk',
                    'tid'   => '20351K59',
                    'coms'  => 'EGPRS',
                    'sim'   => '',
                    'cloc'  => '',
                    'ss'    => '67',
                    'tmn'   => 'VX5202',
                    'tmanu' => 'Verizone',
                    'hb'    => 'true',
                    'sv'    => '7.8.13',
                    'ITxnAT'    => get_now(),
                    'pads'  => '',
                    'customField' => 'Payment for Electricity Bill...'
                ),
                'journal' => array(
                    "stan" => "",
                    "mPan" => "",
                    "rrn" => "",
                    "acode" => "",
                    "amount" => $data['amount'],
                    "timestamp" => get_now(),
                    "mti" => "0200",
                    "ps" => "001000",
                    "resp" => "",
                    "tap" => "true",
                    "rep" => "",
                    "vm" => "OfflinePin",
                    "ostan" => "",
                    "orrn" => "",
                    "oacode" => "",
                    "mid" => "",
                    "vasCategory" => "EKO",
                    "vasProduct" => "Sub Product Type",
                    "mcc" => "",
                    "transMethod" =>  "cash",
                    "customField" => ""
                )
            )
        );


        $hashed_utf_encoded_string = hash('sha512', utf8_encode(json_encode( $request_body )));
        $key_username = $key . $username;
        $token = base64_encode($key_username);
        $signature = hash_hmac('sha256', $hashed_utf_encoded_string, $token, true);
        $authorization = strtoupper($username)."-".base64_encode($signature . $date . $organization_code);
        $ch = curl_init();
        $encoded_requestBody = utf8_encode(json_encode($request_body));
        curl_setopt($ch, CURLOPT_URL, PAYVICE_BASE_URL."/vas/eedc/payment");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_requestBody);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: " .$authorization,
            "Date: 2018-05-01 1:52 PM",
            "Username: ".ORGANIZATION_USERNAME,
            "OrganisationCode: ". ORGANIZATION_CODE,
            "Vend-Type: B2B"
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if ($err) {
            return array('status' => false, 'message' => $err);
        } else {
            $response = json_decode( $response );
            if( $response->error ){
                $return_data = array(
                    'status' => false,
                );
            }else{
                $return_data = array(
                    'status' => true,
                    'message' => $response->message . " with reference number: " . $response->ref
                );
            }
            return( $return_data );
        }

    }


    // ENUGU POSTPAID PAYMENT

    public function enugu_postpaid_payment( $data = array()){
        // Get the Authorization
        $key = ORGANIZATION_KEY;
        $organization_code = ORGANIZATION_CODE;
        $username = ORGANIZATION_USERNAME;
        $date = "2018-05-01 1:52 PM";
        $request_body = array(
            "wallet" => PAYVICE_WALLET_ID,
            "username" => PAYVICE_USERNAME,
            "password" =>  PAYVICE_PWD,
            "type" =>  "postpaid",
            "channel" =>  "WEB",
            "account" => "{$data['meter_number']}",
            "amount" =>  $data['amount'],
            "phone" => "{$data['phone_number']}",
            "productCode" => $this->session->userdata('product_code'),
            "customerName" => "{$data['customer_name']}",
            "paymentMethod" =>"cash",
            "clientReference" => "{$data['transaction_id']}",
            "pin" => PAYVICE_PIN,
            'pfm' => array(
                'state' => array(
                    'serial' => '323-890-383',
                    'ctime' => '',
                    'bl'    => 43,
                    'cs'    => 'NotCharging',
                    'ps'    => 'PrinterOk',
                    'tid'   => '20351K59',
                    'coms'  => 'EGPRS',
                    'sim'   => '',
                    'cloc'  => '',
                    'ss'    => '67',
                    'tmn'   => 'VX5202',
                    'tmanu' => 'Verizone',
                    'hb'    => 'true',
                    'sv'    => '7.8.13',
                    'ITxnAT'    => get_now(),
                    'pads'  => '',
                    'customField' => 'Payment for Electricity Bill...'
                ),
                'journal' => array(
                    "stan" => "",
                    "mPan" => "",
                    "rrn" => "",
                    "acode" => "",
                    "amount" => $data['amount'],
                    "timestamp" => get_now(),
                    "mti" => "0200",
                    "ps" => "001000",
                    "resp" => "",
                    "tap" => "true",
                    "rep" => "",
                    "vm" => "OfflinePin",
                    "ostan" => "",
                    "orrn" => "",
                    "oacode" => "",
                    "mid" => "",
                    "vasCategory" => "Enugu postpaid",
                    "vasProduct" => "Sub Product Type",
                    "mcc" => "",
                    "transMethod" =>  "cash",
                    "customField" => ""
                )
            )
        );
        $hashed_utf_encoded_string = hash('sha512', utf8_encode(json_encode( $request_body )));
        $key_username = $key . $username;
        $token = base64_encode($key_username);
        $signature = hash_hmac('sha256', $hashed_utf_encoded_string, $token, true);
        $authorization = strtoupper($username)."-".base64_encode($signature . $date . $organization_code);
        $ch = curl_init();
        $encoded_requestBody = utf8_encode(json_encode($request_body));
        curl_setopt($ch, CURLOPT_URL, PAYVICE_BASE_URL."/vas/eedc/payment");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_requestBody);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: " .$authorization,
            "Date: 2018-05-01 1:52 PM",
            "Username: ".ORGANIZATION_USERNAME,
            "OrganisationCode: ". ORGANIZATION_CODE,
            "Vend-Type: B2B"
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if ($err) {
           return array('status' => false, 'message' => $err);
        } else {
            $response = json_decode( $response );
            if( $response->error ){
                $return_data = array(
                    'status' => false,
                );
            }else{
                $return_data = array(
                    'status' => true,
                    'message' => $response->message . " with token: " . $response->token . ' Unit Value: ' . $response->unit_value
                );
            }
            return( $return_data );
        }
    }



    // IBADAN VALIDITY

    public function ibadan_validate( $meter_number ){
        // Get the Authorization
        $key = ORGANIZATION_KEY;
        $organization_code = ORGANIZATION_CODE;
        $username = ORGANIZATION_USERNAME;
        $date = "2018-05-01 1:52 PM";
        $request_body = array(
            "terminal_id" => PAYVICE_TERMINAL_ID,
            "terminal" => PAYVICE_TERMINAL_ID,
            "user_id" => PAYVICE_USERNAME,
            "password" => PAYVICE_PWD,
            "account" => "{$meter_number}",
            "type" => "getcus",
            "service_type" => "pay",
            "service" => "postpaid",
            "channel" => "web"
        );
        $hashed_utf_encoded_string = hash('sha512', utf8_encode(json_encode( $request_body )));
        $key_username = $key . $username;
        $token = base64_encode($key_username);
        $signature = hash_hmac('sha256', $hashed_utf_encoded_string, $token, true);
        $authorization = strtoupper($username)."-".base64_encode($signature . $date . $organization_code);
        $ch = curl_init();
        $encoded_requestBody = utf8_encode(json_encode($request_body));
        curl_setopt($ch, CURLOPT_URL, PAYVICE_BASE_URL."/vas/ibedc/validate");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_requestBody);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: " .$authorization,
            "Date: 2018-05-01 1:52 PM",
            "Username: ".ORGANIZATION_USERNAME,
            "OrganisationCode: ". ORGANIZATION_CODE,
            "Vend-Type: B2B"
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if ($err) {
            return($err);
        } else {
            $response = json_decode( $response );
            if( $response->error ){
                return false;
            }else{
                return($response->name);
            }
        }
    }


    // IBADAN PAYMENT
    // @TODO WORK DEY HERE
    public function ibadan_payment( $data = array()){
        // Get the Authorization
        $key = ORGANIZATION_KEY;
        $organization_code = ORGANIZATION_CODE;
        $username = ORGANIZATION_USERNAME;
        $date = "2018-05-01 1:52 PM";
        $request_body = array(
            "wallet" => PAYVICE_WALLET_ID,
            "username" => PAYVICE_USERNAME,
            "password" =>  PAYVICE_PWD,
            "type" =>  "prepaid",
            "channel" =>  "WEB",
            "account" =>  "{$data['meter_number']}",
            "amount" =>  $data['amount'],
            "phone" =>  "{$data['phone_number']}",
            "productCode" =>  $this->session->userdata('product_code'),
            "customerName" =>  "{$data['customer_name']}",
            "paymentMethod" =>  "cash",
            "pin" => PAYVICE_PIN,
            'pfm' => array(
                'state' => array(
                    'serial' => '323-890-383',
                    'ctime' => '',
                    'bl'    => 43,
                    'cs'    => 'NotCharging',
                    'ps'    => 'PrinterOk',
                    'tid'   => '20351K59',
                    'coms'  => 'EGPRS',
                    'sim'   => '',
                    'cloc'  => '',
                    'ss'    => '67',
                    'tmn'   => 'VX5202',
                    'tmanu' => 'Verizone',
                    'hb'    => 'true',
                    'sv'    => '7.8.13',
                    'ITxnAT'    => get_now(),
                    'pads'  => '',
                    'customField' => 'Payment for Electricity Bill...'
                ),
                'journal' => array(
                    "stan" => "",
                    "mPan" => "",
                    "rrn" => "",
                    "acode" => "",
                    "amount" => $data['amount'],
                    "timestamp" => get_now(),
                    "mti" => "0200",
                    "ps" => "001000",
                    "resp" => "",
                    "tap" => "true",
                    "rep" => "",
                    "vm" => "OfflinePin",
                    "ostan" => "",
                    "orrn" => "",
                    "oacode" => "",
                    "mid" => "",
                    "vasCategory" => "EKO",
                    "vasProduct" => "Sub Product Type",
                    "mcc" => "",
                    "transMethod" =>  "cash",
                    "customField" => ""
                )
            )
        );


        $hashed_utf_encoded_string = hash('sha512', utf8_encode(json_encode( $request_body )));
        $key_username = $key . $username;
        $token = base64_encode($key_username);
        $signature = hash_hmac('sha256', $hashed_utf_encoded_string, $token, true);
        $authorization = strtoupper($username)."-".base64_encode($signature . $date . $organization_code);
        $ch = curl_init();
        $encoded_requestBody = utf8_encode(json_encode($request_body));
        curl_setopt($ch, CURLOPT_URL, PAYVICE_BASE_URL."/vas/eedc/payment");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_requestBody);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "Authorization: " .$authorization,
            "Date: 2018-05-01 1:52 PM",
            "Username: ".ORGANIZATION_USERNAME,
            "OrganisationCode: ". ORGANIZATION_CODE,
            "Vend-Type: B2B"
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if ($err) {
            return array('status' => false, 'message' => $err);
        } else {
            $response = json_decode( $response );
            if( $response->error ){
                $return_data = array(
                    'status' => false,
                );
            }else{
                $return_data = array(
                    'status' => true,
                    'message' => $response->message . " with reference number: " . $response->ref
                );
            }
            return( $return_data );
        }

    }

}
