<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Page extends CI_Controller {

    public function __construct(){
        parent::__construct();
        $this->load->library('recaptcha');
    }

    public function index(){
        redirect(base_url());
    }

    public function login(){

        if( $this->session->userdata('logged_id') ) {
            redirect('dashboard/');
        }
        $page_data['title'] = "Login";
        $page_data['page'] = 'login';
        $this->form_validation->set_rules('username', 'Login Username','trim|required|xss_clean');
        $this->form_validation->set_rules('password', 'Password','trim|required|xss_clean|min_length[6]|max_length[15]');

        if( $this->form_validation->run() == false ){
            $this->session->set_flashdata('error_msg', validation_errors());
            $this->load->view('landing/login', $page_data);
            return;
        }else{
            // Lets log this shit in
            $data = array(
                'username' => $this->input->post('username', true),
                'password' => $this->input->post('password', true)
            );
            $user = $this->user->login($data);

            if( !$user ) {
                $this->session->set_flashdata('error_msg','Sorry! Incorrect login username or password');
                $this->load->view('landing/login', $page_data);
                return;
            }else{

                if ( $user->status == 'block' ){
                    $this->session->set_flashdata('error_msg','Your account has been blocked, please contact support.');
                    $this->load->view('landing/login', $page_data);
                    return;
                }

                if ( $user->everify == 0 ){
                    $this->session->set_flashdata('error_msg','Please verify your account before proceeding. We sent you a verification mail with the email you signed up with. You can check your spam folder.');
                    $this->load->view('landing/login', $page_data);
                    return;
                }
                $session_data = array(
                    'logged_in' => true,
                    'logged_id' => $user->id,
                    'email' => $user->email,
                    'username' => $user->name,
                    'is_admin' => $user->is_admin);
                $this->session->set_userdata($session_data);
                $this->session->set_flashdata('success_msg', "Logged in...");
                if( $user->is_admin == 1 ){
                    redirect('admin');
                }else{
                    redirect('dashboard');
                }
            }
        }

    }

    public function create(){

        if( $this->session->userdata('logged_id') ) {
            redirect('dashboard/');
        }
        $page_data['page'] = 'create';
        $page_data['title'] = "Create an account with us";
        $ref = cleanit($this->input->get('ref', true));
        $page_data['referral'] = lang('app_name');
        $page_data['referral_code'] = "12457";
        if( $ref ){
            $row = $this->site->run_sql("SELECT name FROM users WHERE user_code = '{$ref}'")->row();
            if( $row ){
                $page_data['referral'] = $row->name;
                $page_data['referral_code'] = $ref;
            }
        }
        $this->form_validation->set_rules('email', 'Email Address', 'trim|required|xss_clean|valid_email|is_unique[users.email]', array('is_unique' => 'This %s has already been registered!'));
        $this->form_validation->set_rules('phone', 'Phone number','trim|required|xss_clean|is_unique[users.phone]', array('is_unique' => 'This %s has already been registered!'));
        $this->form_validation->set_rules('name', 'Full name','trim|required|xss_clean|min_length[3]|max_length[55]');
        $this->form_validation->set_rules('password', 'Password','trim|required|xss_clean|min_length[6]|max_length[15]');
        $this->form_validation->set_rules('confirm_password', 'Confirm Password','trim|required|xss_clean|min_length[6]|max_length[15]|matches[password]');

        if( $this->form_validation->run() == false ){
            // error
            $this->session->set_flashdata('error_msg', validation_errors());
            $this->load->view('landing/create', $page_data);
            return;
        }else{
            $salt = salt(50);
            $code = $this->user->generate_user_code();
            $name = $this->input->post('name', true);
            $email = $this->input->post('email', true);
            $referral = $this->input->post('ref_code', true);
            $data = array(
                'email' => $email,
                'phone' => $this->input->post('phone', true),
                'name' => $name,
                'salt' => $salt,
                'referral' => $referral,
                'password' => shaPassword($this->input->post('password'), $salt),
                'ip' => $_SERVER['REMOTE_ADDR'],
                'date_registered' => get_now(),
                'membership_type' => 'bronze',
                'last_login' => get_now(),
                'user_code' => $code,
                'everify' => 0
            );

            $user = $this->user->create_account($data);
            if( !is_numeric($user) ) {
                $this->session->set_flashdata('error_msg', "Sorry! There was an error creating the account. Try again later.");
                $this->load->view('landing/create', $page_data);
            }else{
                // Send verification mail
                $message = "Hi {$name}, \r\n\r\nThank you for signing up with us at .\r\n\r\n We're glad having you on-board.\r\n\r\n";
                $link = base_url('page/verify/?t='. simple_crypt($code));
                $message .= '<a href="' . $link . '" target="_blank" style="padding: 8px 12px; border: 1px solid #ED2939;border-radius: 2px;font-family: Helvetica, Arial, sans-serif;font-size: 14px; color: #00000;text-decoration: none;font-weight:bold;display: inline-block;">Verify Account</a>';
                $message .= "\r\n\r\n";
                $message .= "Kindly verify your email by clicking on the button above. or copy and paste the link below to your browser to verify.\r\n\r\n";
                $message .= $link;
                $message .= "\r\n\r\nBest Regards,\r\n\r\n" .lang('site_name'). " Team";
                $this->load->library('email');
                $this->email->clear(TRUE);
                $this->email->set_newline("\r\n");
                $this->email->from( lang('app_email'), lang('site_name'));
                $this->email->to($email);
                $this->email->subject( 'Thank you for signing up with ' . lang('site_name'));
                $this->email->message($message);
                $this->email->send();
                $this->session->set_flashdata('success_msg', "Account created successfully, please verify your email and login to proceed.");
                redirect('page/login/');
            }
        }


    }

    // forgot
    public function forgot(){
//        if( $this->input->post() ){
//            $recaptcha = $this->input->post('g-recaptcha-response');
//            $response = $this->recaptcha->verifyResponse($recaptcha);
//            if (!isset($response['success']) || $response['success'] !== true) {
//                $this->session->set_flashdata('error_msg', 'There was an error validating the captcha, please try again.');
//                redirect('auth/forgot/');
//            }
        $page_data['title'] = "Recover";
        $page_data['page'] = 'forgot';
        $this->form_validation->set_rules('email', 'Email address','trim|required|xss_clean|valid_email');
        if ($this->form_validation->run() == FALSE) {
            $this->session->set_flashdata('error_msg', validation_errors() );
            $this->load->view('landing/forgot', $page_data);
        }else{
            // // send mail
            $email = $this->input->post('email', true);
            // check the email
            $row = $this->site->run_sql("SELECT id, name FROM users WHERE email = '{$email}'")->row();
            if( !$row ){
                $this->session->set_flashdata('error_msg', "Oops sorry, we can't find your detail in our system");
                $this->load->view('landing/forgot', $page_data);
            }else{
                $new_password = random_string('alnum', 10);
                if( $this->site->change_password( $new_password , $row->id) ){
                    // send mail
                    $message = "Hi {$row->name}, \r\n\r\nYou requested to retrieve your password, please find below your new password.\r\n\r\n {$new_password}\r\nAfter login in to your account, you can change it to your preferred password.\r\n\r\nHave a great day.\r\n\r\nBest Regards,\r\n\r\n" .lang('app_name');
                    $this->email->clear(TRUE);
                    $this->email->set_newline("\r\n");
                    $this->email->from(lang('app_email'), lang('app_name'));
                    $this->email->to($email);
                    $this->email->subject('Password Retrieve From ' . lang('app_name'));
                    $this->email->message($message);
                    if( $this->email->send()){
                        $this->session->set_flashdata('success_msg', "Congrats, a new password has been sent to your mail.");
                        redirect('page/login/');
                    }else{
                        $this->session->set_flashdata('error_msg',"There was an error sending the mail...");
                        redirect('page/forgot/');
                    }
                }

            }
        }
    }

    // Email verification
    public function verify(){
        $crypt = $this->input->get('t', true);
        if( $crypt ){
            $decrypt = simple_crypt($crypt,'d');
            // check code
            $decrypt = trim($decrypt);
            $row = $this->site->run_sql("SELECT * FROM users WHERE user_code = '{$decrypt}'")->row();
            if( $row ){
                try {
                    $this->site->update('users', array('everify' => 1 ), array('id' => $row->id));
                    $this->session->set_flashdata('success_msg', "Congrats your account has been verified. Login to get started.");
                    redirect('page/login');
                } catch (Exception $exception) {
                    $this->session->set_flashdata('error_msg', "There was an error verifying your account. Please contact support.");
                    redirect('page/login');
                }
            }else{
                redirect('page/create');
            }

        }
        redirect(base_url());
    }

    public function contact(){
        $page_data['page'] = 'contact';
        $page_data['title'] = "Contact " .lang('app_name'). " for data - airtime - TV subscription and PHCN payment.";

//	    if( $this->input->post() ){

        $this->form_validation->set_rules('name', 'Contact name','trim|required|xss_clean|min_length[3]|max_length[15]');
        $this->form_validation->set_rules('email', 'Contact email','trim|required|xss_clean|valid_email');
        $this->form_validation->set_rules('message', 'Contact message','trim|required|xss_clean|min_length[3]|max_length[300]');
        $this->form_validation->set_rules('phone', 'Phone number','trim|required|xss_clean|min_length[3]|max_length[11]');

        if ($this->form_validation->run() == FALSE) {
            $this->session->set_flashdata('error_msg', validation_errors() );
            $this->load->view('landing/contact', $page_data);
            return;
        }else{
            // // send mail
            $recaptcha = $this->input->post('g-recaptcha-response');
            $response = $this->recaptcha->verifyResponse($recaptcha);
            if (!isset($response['success']) || $response['success'] !== true) {
                $this->session->set_flashdata('error_msg', 'There was an error validating the captcha, please try again.');
                $this->load->view('landing/contact', $page_data);
                return;
            }
            $name = $this->input->post('name', true);
            $email = $this->input->post('email', true);
            $message = cleainit($this->input->post('message', true));
            $message .= "Phone number : " . $this->input->post('phone', true);

            $this->load->library('email');
            $this->email->clear(TRUE);
            $this->email->set_newline("\r\n");
            $this->email->from($email, $name);
            $this->email->to(lang('app_email'));
            $this->email->subject( $name.' A new message from contact page');
            $this->email->message($message);

            if( $this->email->send() ) {
                $this->session->set_flashdata('success_msg', "We received your message and will get back to you shortly");
            }else{
                $this->session->set_flashdata('error_msg', "There was an error sending your message... Please try again or use the chat widget.");
            }
            $this->load->view('landing/contact', $page_data);
            return;
        }


    }


    public function faq(){
        $page_data['page'] = 'faq';
        $page_data['title'] = 'Most Frequently Asked Questions On ' .lang('app_name').' -  Data - Airtime - TV Bills';
        $this->load->view('landing/faq', $page_data);
    }

    public function about(){
        $page_data['page'] = 'faq';
        $page_data['title'] = 'About ' .lang('app_name').' -  Data - Airtime - TV Bills';
        $this->load->view('landing/about', $page_data);
    }


    public function error_404(){
        $page_data['page'] = 'error';
        $page_data['title'] = 'Page not found';
        $this->load->view('landing/404', $page_data);
    }


    /*
     * Data pricing page for reseller
     * */
    public function reseller_pricing(){
        $page_data['page'] = 'data';
        $page_data['data'] = $this->site->get_result('services', 'id, title, message', "(product_id = 1)");
        $this->load->view('landing/pricing', $page_data);
    }

    /*
     * Data pricing page for retail
     * */
    public function retail_pricing(){
        $page_data['page'] = 'data';
        $page_data['data'] = $this->site->get_result('services', 'id, title, message', "(product_id = 1)");
        $this->load->view('landing/retail_pricing', $page_data);
    }


    public function cabletv(){
        $page_data['page'] = 'cable';
        $this->load->view('landing/pricing', $page_data);
    }

    /*
     * Show all services we render
     * */
    public function all_services(){

    }


    public function sitemap(){
        header("Content-Type: text/xml;charset=iso-8859-1");
        $this->load->view('sitemap');
    }


    public function error404(){
        $page_data['title'] = "Page Not Found";
        $page_data['page'] = '404';
        $this->load->view('landing/404', $page_data);
    }

    function get_profile($id){
        return $this->site->run_sql("SELECT phone, email, name, user_code, wallet, account_type FROM users where id = {$id}")->row();
    }

    private function monifylogin(){
        $curl = curl_init();
        $string = MONIFY_API . ':' . MONIFY_SECRET;
        $token = base64_encode( $string );
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.monnify.com/api/v1/auth/login",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_POST => 1,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_HTTPHEADER => array(
                "Content-Type: application/json",
                "Authorization: Basic " . $token,
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $response = json_decode( $response , true);
            return $response;
        }
    }

    private function monifycurl( $data ){
        $curl = curl_init();
        $token = $data['token'];
        unset($data['url']);
        unset($data['token']);
        $encdata = json_encode( $data );
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.monnify.com/api/v1/bank-transfer/reserved-accounts",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_POST => 1,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $encdata,
            CURLOPT_HTTPHEADER => array(
                "Content-Type: application/json",
                "Authorization: Bearer " . $token,
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $response = json_decode( $response , true);
            return $response;
        }
    }
}
