<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends MY_Controller {

    public function __construct(){
        parent::__construct();
        if( !$this->session->userdata('logged_in') ){
            redirect( base_url() );
        }else if( $this->session->userdata('is_admin') == 1 ){
            redirect('admin/');
        }
    }


    public function index(){
        $page_data['page'] = 'home';
        $page_data['title'] = 'Airtime Recharge, Data Purchase, Utility Bills';
        $id = $this->session->userdata('logged_id');
        $page_data['user'] = $this->get_profile($id);
        $page_data['reseller'] = $this->site->get_row('transactions', "status",array('user_id' => $id, 'product_id' => 12) );
        $page_data['transactions'] = $this->site->run_sql("SELECT * FROM transactions WHERE user_id = {$id} ORDER BY id DESC LIMIT 500")->result();
        $page_data['downlines'] = $this->site->my_downlines(  $page_data['user']->user_code );
        $page_data['notifications'] = $this->site->get_result('notifications', '*', array('status' => 1));
        $this->load->view('app/users/dashboard', $page_data);
	}

    // Airtime
    public function airtime(){
        $id = $this->session->userdata('logged_id');
        $page_data['page'] = 'airtime';
        $page_data['title'] = 'Buy Mtn, Glo, 9mobile, Airtel Airtime';
        $page_data['user'] = $this->get_profile($id);
        $page_data['networks'] = $this->site->run_sql("SELECT p.slug, s.id, s.title, network_name, discount, image FROM products p LEFT JOIN services s ON (p.id = s.product_id) WHERE p.title ='airtime' ")->result();
        $msisdn = cleanit($this->input->get('msisdn', true));
        $page_data['msisdn'] = $msisdn;
        $this->load->view('app/users/airtime', $page_data);
    }


    // Data
    public function data(){
        $id = $this->session->userdata('logged_id');
        $page_data['page'] = 'data';
        $page_data['title'] = 'Buy Mtn, Glo, 9mobile, Airtel Data Subscription, works for all Smartphones and devices...';
        $page_data['user'] = $this->get_profile($id);
        $membership_type = $page_data['user']->membership_type;
        $page_data['networks'] = $this->site->run_sql("SELECT p.slug, s.* FROM products p LEFT JOIN services s ON (p.id = s.product_id) WHERE 
        p.title ='data' AND ( s.discount_type = '{$membership_type}' OR s.discount_type = 'all' ) ")->result();
        $msisdn = cleanit($this->input->get('msisdn', true));
        $page_data['msisdn'] = $msisdn;
        $this->load->view('app/users/data', $page_data);
    }


    // Tv verification
    public function verify_tv(){
        $id = $this->session->userdata('logged_id');
        $this->session->userdata('tv_verification_status', false);
        unset( $_SESSION['tv_sub'] );
        $page_data['page'] = 'tv_subscription';
        $page_data['title'] = 'Verify TV IUC Number';
        $page_data['user'] = $this->get_profile($id);
        $page_data['networks'] = $this->site->run_sql("SELECT p.slug, s.id, s.title, network_name, discount FROM products p LEFT JOIN services s ON (p.id = s.product_id) WHERE p.slug ='tv-subscription' ")->result();
        $this->form_validation->set_rules('smart_card_number', 'Smart Card Number','trim|required|xss_clean');
        $this->form_validation->set_rules('network_name', 'Network','trim|required|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            $this->load->view('app/users/verify_tv', $page_data);
            return;
        }else{
            $network_name = $this->input->post('network_name');
            $data = array(
                'account' => $this->input->post('smart_card_number'),
                'type'  => strtoupper( $network_name )
            );
            if( $network_name == 'startimes' ){
                $data['url'] = "https://api.payscribe.ng/api/v1/startimes/validate";
                $data['amount'] = $this->input->post('amount');
            }else{
                $data['url'] = "https://api.payscribe.ng/api/v1/multichoice/validate";
            }
            $return_response = $this->payscribe_curl( $data );
            if( $return_response['status'] ) {
                $this->session->set_userdata(array('tv_verification_status' => true));
                $this->session->set_flashdata('success_msg', $return_response['message']['description']);
                $tv_array = array(
                    'network_name' => $data['type'],
                    'smart_card_number' => $data['account'],
                    'bouquets' => $return_response['message']['details']['bouquets'],
                    'productCode'   => trim($return_response['message']['details']['productCode']),
                    'productToken'   => trim($return_response['message']['details']['productToken']),
                    'customer_name' => $return_response['message']['details']['customer_name']
                );
                $this->session->set_userdata('tv_sub', $tv_array);
                redirect('dashboard/tv_subscription/');
            }else{
                $this->session->set_flashdata('error_msg', "Sorry, the validation was unsuccessful. Try again...");
                $this->load->view('app/users/verify_tv', $page_data);
                return;
            }
        }
    }


    // Tv subscription
    public function tv_subscription(){
        $id = $this->session->userdata('logged_id');
        $page_data['page'] = 'tv_subscription';
        $page_data['title'] = 'Subscribe your GoTV, DSTV, Startimes ... decoder';
        $page_data['user'] = $this->get_profile($id);
        $page_data['networks'] = $this->site->run_sql("SELECT p.slug, s.id, s.title, network_name, discount FROM products p LEFT JOIN services s ON (p.id = s.product_id) WHERE p.slug ='tv-subscription' ")->result();
        $page_data['transactions'] = $this->site->run_sql("SELECT id, trans_id, amount, description, date_initiated,payment_method, product_id, status FROM transactions WHERE product_id = 4 AND user_id = {$id} ORDER BY id DESC LIMIT 10")->result();
        $page_data['tv_sub'] = $this->session->userdata('tv_sub');
        
        $this->form_validation->set_rules('smart_card_number', 'Smart Card Number','trim|required|xss_clean');
        $this->form_validation->set_rules('network_name', 'Network','trim|required|xss_clean');
        $this->form_validation->set_rules('plan', 'Bouquet / Package','trim|required|xss_clean');
        $this->form_validation->set_rules('customer_name', 'Registered Name / Package','trim|required|xss_clean');
        if( $this->form_validation->run() == false ){
            $this->session->set_flashdata('error_msg', validation_errors());
            $this->load->view('app/users/tv_subscription', $page_data);
            return;
        }else{

            $transaction_id = time();
            $network_name = $_POST['network_name'];
            $smart_card_number = $_POST['smart_card_number'];
            $plan = $_POST['plan'];
            $customer_name = $_POST['customer_name'];
            $month = $_POST['month'];
            $phone = $_POST['phone'];
            $x = explode('|', simple_crypt($plan, 'd'));
            $plan_id = $x[0];
            $amount = $x[1];

            // Get the user wallet value before proceeding...
            $user_row = $this->get_profile( $this->session->userdata('logged_id'));

            $array = array(
                "url" => "https://api.payscribe.ng/api/v1/multichoice/vend",
                'plan_id' => $plan_id,
                'customer_name' => $customer_name,
                'phone' => $phone,
                'email' => $user_row->email,
                'account' => $smart_card_number,
                'service' => $network_name,
                'ref' => $transaction_id,
            );
            $total = $month * $amount;

            if( $user_row->wallet <= $amount || $user_row->wallet < 1 ){
                $link = base_url('dashboard/wallet/');
                $this->session->set_flashdata('error_msg', "Low balance on your wallet, please <a href='{$link}' title='Fund my wallet'>Fund Wallet</a> first.");
                $this->load->view('app/users/tv_subscription', $page_data);
                return;
            }
            $response = $this->payscribe_curl( $array );

            if( !in_array($response['status_code'], array(200,201)) ){
                $this->session->set_flashdata('error_msg', 'There was an error processing your request, if persist,please contact support.');
                $this->load->view('app/users/tv_subscription', $page_data);
                return;
            }else{
                $det = $response['message']['details'];

                $insert_data = array(
                    'amount'        => $amount,
                    'balance'        => $user_row->wallet - $amount,
                    'product_id'    => 3,
                    'description'   => "{$det['service']} {$month} subscription - {$det['plan']} ({$smart_card_number}) at the rate of NGN{$det['amount']}. Reference ID : {$det['trans_id']}",
                    'trans_id'      => $transaction_id,
                    'payment_method' => 4,
                    'date_initiated' => get_now(),
                    'user_id'        => $id,
                    'status'           => 'success'
                );
                $this->site->set_field('users', 'wallet', "wallet-{$total}", "id={$id}");
                $this->site->insert_data('transactions', $insert_data);
                $this->session->set_flashdata('success_msg', "Payment successful. Please see transaction page for more details..." .$response['message']['details']['processed']);
                // Unset
                $this->session->userdata('tv_verification_status', false);
                unset( $_SESSION['tv_sub'] );
                redirect('dashboard/verify_tv/');
            }

        }
    }



    // Meter number verification
    public function verify_meter(){
        $id = $this->session->userdata('logged_id');
        $this->session->userdata('meter_verification_status', false);
        $page_data['page'] = 'electricity';
        $page_data['title'] = 'Verify Electricity Meter Number';
        $page_data['user'] = $this->get_profile($id);
        $page_data['electricity'] = $this->site->run_sql("SELECT * FROM services WHERE network_name ='electricity' ")->result();
        $this->form_validation->set_rules('electricity_name', 'Electricity Name', 'trim|required|xss_clean');
        $this->form_validation->set_rules('meter_number', 'Meter Number', 'trim|required|xss_clean');
        $this->form_validation->set_rules('meter_type', 'Meter Type', 'trim|required|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $this->load->view('app/users/verify_meter', $page_data);
            return;
        }else{
            $meter_number = $this->input->post('meter_number');
            $meter_type = $this->input->post('meter_type');
            $amount = $this->input->post('amount');
            $service_validate  = $this->input->post('electricity_name');
            $service = explode('|', $service_validate);
            if( $amount < 1000 ){
                $this->session->set_flashdata('error_msg', "Amount can not be less than N1000 or above N5000000.");
                $this->load->view('app/users/verify_meter', $page_data);
                return;
            }
            // call payscribe URL
            $curl_data = array(
                'url'       => "https://api.payscribe.ng/api/v1/electricity/validate",
                'meter_number' => $meter_number,
                'meter_type'  => $meter_type,
                'service' => $service[0],
                'amount' => $amount
            );
            $return_response = $this->payscribe_curl( $curl_data );

            if ( $return_response['status'] ) {
                $re = $return_response['message']['details'];
                $electricity_array = array(
                    'customer_name' => $re['customer_name'],
                    'product_code' => $re['product_code'],
                    'address' => $re['address'] .' Arrears: ' . $re['arrears'],
                    'validation_result' => true,
                    'meter_number' => $meter_number,
                    'meter_type' => $meter_type,
                    'amount' => $amount,
                    'channel' => $service['0']
                );
                $this->session->set_userdata($electricity_array);
                $this->session->set_flashdata('success_msg', "Meter number validation successful.");
                redirect('dashboard/electricity/');
            }else{
                $this->session->set_flashdata('error_msg', "Meter number not validated. Please check and try again...");
                $this->load->view('app/users/verify_meter', $page_data);
                return;
            }
        }
    }

    // electricity
    public function electricity(){
        $id = $this->session->userdata('logged_id');
        $product_id = 4;
        $page_data['page'] = 'electricity';
        $page_data['title'] = 'Pay your electricity bill';
        $page_data['user'] = $u = $this->get_profile($id);
        $page_data['electricity_channel'] = $_SESSION['channel'];
        $page_data['meter_number'] = $_SESSION['meter_number'];
        $page_data['customer_name'] = $_SESSION['customer_name'];
        $page_data['meter_type'] = $_SESSION['meter_type'];
        $page_data['amount'] = $_SESSION['amount'];
        $page_data['product_code'] = isset($_SESSION['product_code']) ? $_SESSION['product_code'] : '';
        $page_data['address'] = isset($_SESSION['address']) ? $_SESSION['address'] : '';
        $page_data['electricity'] = $this->site->run_sql("SELECT * FROM services WHERE product_id = '4' ")->result();
        $this->form_validation->set_rules('network', 'Electricity Type','trim|required|xss_clean');
        $this->form_validation->set_rules('meter_type', 'Meter Type','trim|required|xss_clean');
        $this->form_validation->set_rules('meter_number', 'Meter Number','trim|required|xss_clean');
        $this->form_validation->set_rules('amount', 'Amount','trim|required|xss_clean');
        if($this->form_validation->run() == FALSE) {
            $this->session->set_flashdata('error_msg', validation_errors());
            $this->load->view('app/users/electricity', $page_data);
            return;
        }else{
            $network = $this->input->post('network');
            $phone_number = $this->input->post('phone');
            $meter_number = $this->input->post('meter_number');
            $meter_type = $this->input->post('meter_type');
            $amount = $this->input->post('amount');
            $explode = explode('|', $network);
            $user = $this->get_profile($id);

            if($amount < 50 ){
                $this->session->set_flashdata('error_msg', "Don't be unfortunate.");
                redirect('dashboard/electricity/');
            }
            if(  $user->wallet < $amount ){
                $this->session->set_flashdata('error_msg', "You don't have up-to the amount you're trying to process. Please fund your wallet first");
                redirect('dashboard/wallet/');
            }

            $transaction_id = time();
            $array = array(
                'url'       => "https://api.payscribe.ng/api/v1/electricity/vend",
                'ref' => $transaction_id,
                'product_code' => $this->input->post('product_code'),
                'meter_number' => $meter_number,
                'meter_type' => $meter_type,
                'amount' => $amount,
                'phone' => $phone_number,
                'email' => $user->email,
                'service' => $explode[0],
            );
            try {
                $response = $this->payscribe_curl( $array );
                $desc = '';
                if( $response['status'] ){
                    $insert_data = array(
                        'amount'        => $amount,
                        'product_id'    => 4,
                        'description'   => strtoupper($explode[0]) . " Electricity Bill - N{$amount}. Details: " . $desc,
                        'trans_id'      => $transaction_id,
                        'details'       => json_encode($response['message']['details']),
                        'payment_method' => 4,
                        'date_initiated'    => get_now(),
                        'user_id'        => $id,
                        'status'        => 'success'
                    );
                    $this->site->set_field('users', 'wallet', "wallet-{$amount}", "id={$id}");
                    $this->site->insert_data('transactions', $insert_data);
                    $this->session->set_flashdata('success_msg', "Payment successful. Please see transaction page for more details...{$discountAmount}% gommission given. Check commission wallet" );
                    redirect( 'dashboard/verify_meter/');
                }else{
                    $this->session->set_flashdata('error_msg', 'There was an error processing your request, if persist, contact support. ' .$response['message']['description']);
                    $this->load->view('app/users/electricity', $page_data);
                    return;
                }
            } catch (Exception $e) {
                $this->session->set_flashdata('error_msg', 'There was an error processing your request, if persist, contact support. ' . $e);
                $this->load->view('app/users/electricity', $page_data);
                return;
            }

        }
    }

    // Referral
    public function referrals(){
        $id = $this->session->userdata('logged_id');
        $page_data['user'] = $us = $this->get_profile($id);
        $page_data['page'] = 'referrals';
        $page_data['title'] = 'Referrals on ' . lang('app_name');
        $page_data['transactions'] = '';
        $page_data['upgrade'] = $this->site->get_row("upgrade", 'id', array('uid' => $id, 'status' => 'pending'));
        $page_data['downlines'] = $this->site->my_downlines(  $page_data['user']->user_code );
        $this->load->view('app/users/referrals', $page_data);
    }

    public function confirm_upgrade(){
        $id = $this->session->userdata('logged_id');
        $page_data['user'] = $us = $this->get_profile($id);
        $page_data['page'] = 'referral';
        $page_data['title'] = 'Complete Your Upgrade Process';
        $tid = $this->input->get_post('tid', true);
        if( $tid ){
            $row = $this->site->run_sql( "SELECT * FROM upgrade WHERE id = '{$tid}' AND uid = '{$id}' AND (status = 'pending' OR status = 'processing' )")->row();
            if( !$row ){
                $this->session->set_flashdata('error_msg', "The transaction you are looking for does not exist or has been approved");
                redirect('dashboard/');
            }else{
                $page_data['tid'] = $this->input->post_get('tid',true);
                $page_data['row'] = $row;
                if( $this->input->post() ){
                    $this->form_validation->set_rules('amount', 'Amount','trim|required|xss_clean');
                    if( $this->form_validation->run() == FALSE ){
                        $this->session->set_flashdata('error_msg', validation_errors());
                        $this->load->view('app/users/confirm_upgrade', $page_data);
                        return;
                    }else{
                        $data = array();
                        $data['remark'] = $this->input->post('remark');
                        if( $_FILES['pop'] ){
                            $config = array(
                                'upload_path' => "./pop/",
                                'allowed_types' => "gif|jpg|png|jpeg",
                                'overwrite' => FALSE,
                                'max_size' => "2048000",
                                'max_height' => "768",
                                'max_width' => "1024",
                                'encrypt_name'   => TRUE
                            );
                            $this->load->library('upload', $config);
                            if( $this->upload->do_upload('pop') ){
                                $data['pop'] = $this->upload->data('file_name');
                            }
                        }
                        $data['status'] = 'processing';
                        if( $this->site->update('upgrade', $data, array('id' => $tid)) ){
                            $this->session->set_flashdata('success_msg', "Good news! Your proof of payment has been uploaded. Wait on admin approval.");
                            redirect('dashboard/referrals/');
                        }else{
                            $this->session->set_flashdata('error_msg', "There was an error updating your proof of payment, contact admin, if persist");

                        }
                    }
                }
                $this->load->view('app/users/confirm_upgrade', $page_data);
                return;
            }
        }

    }

    public function reseller(){
        $id = $this->session->userdata('logged_id');
        $row = $this->site->get_row('transactions', "status",array('user_id' => $id, 'product_id' => 12) );
        if( $row ){
            $this->session->set_flashdata('error_msg', "You have applied to be a reseller before and the status is " . strtoupper($row->status));
            redirect('dashboard/');
        }
        $product_id = 12;
        $page_data['page'] = 'reseller';
        $page_data['user'] = $user = $this->get_profile($id);
        $page_data['title'] = 'Become a reseller and earn more...';
        $this->form_validation->set_rules('bank', 'Bank','trim|required|xss_clean');
        $this->form_validation->set_rules('amount', 'Amount','trim|required|xss_clean');
        if( $this->form_validation->run() == FALSE ){
            $this->load->view('app/users/reseller', $page_data);
            return;
        }
        $amount = $this->input->post('amount');
        if( $amount < 1000 ){
            $this->session->set_flashdata('error_msg', "To upgrade to a reseller account, pleas pay N1000.");
            $this->load->view('app/users/reseller', $page_data);
            return;
        }
        $this->db->trans_start();
        $transaction_id = time();
        $insert_data = array(
            'amount'        => $amount,
            'charge'        => 0,
            'product_id'    => $product_id,
            'description'   => $amount ." paid for reseller membership",
            'trans_id'      => $transaction_id,
            'payment_method' => 1,
            'date_initiated'    => get_now(),
            'user_id'        => $id,
            'status'        => 'pending'
        );
        $tid = $this->site->insert_data('transactions', $insert_data);
        $data = array(
            'bank'      => $this->input->post('bank'),
            'comment' => "Reseller upgrade",
            'tid' => $tid
        );
        if( $_FILES['pop'] ){
            $upload_array = array(
                'folder' => CLOUDINARY_FOLDER,
                'filepath' => $_FILES['pop']['tmp_name'],
                'eager' => array("width" => 220, "height" => 220, "crop" => "fill_pad", 'gravity' => 'auto', 'background' => 'auto')
            );
            $this->cloudinarylib->upload_image( $upload_array );
            $return = $this->cloudinarylib->get_result('filename');
            if($return){
                $data['image'] = $return;
                unset($upload_array);
                $this->site->insert_data('funds', $data);
                // Send mail
            }else{
                $this->session->set_flashdata('error_msg','There was an error with that image. Please upload proof of payment');
                $this->load->view('app/users/wallet', $page_data);
                return;
            }
        }
        $this->db->trans_complete();
        if ($this->db->trans_status() === FALSE){
            $this->db->trans_rollback();
            $response['message'] = "There was an error updating your payment. Please chat us up if persist.";
            $this->load->view('app/users/reseller', $page_data);
            return;
        }else{
            $this->db->trans_commit();
            $this->session->set_flashdata('success_msg','Congrats. Your payment will be verified in less than a minute.');
//            $sms_array = array( '08161500635' =>  "{$user->name} just claimed to pay {$amount} for reseller membership");
//            $this->load->library('AfricaSMS', $sms_array);
//            $this->africasms->sendsms();
            redirect('dashboard/');
        }
    }



    // Invoice
    public function invoice(){
        $trans_id = cleanit($this->uri->segment(3));
        if( $trans_id ){
            // Get row
            $transaction = $this->site->get_row('transactions', '*', array('trans_id' => $trans_id));
            if( !$transaction ){
                $this->session->set_flashdata('error_msg', "The transaction you're looking for does not exist.");
                redirect( 'dashboard/');
            }else{
                $id = $this->session->userdata('logged_id');
                $page_data['page'] = 'invoice';
                $page_data['title'] = 'Receipt for - ' . $trans_id ;
                $page_data['user'] = $this->get_profile($id);
                $page_data['transaction'] = $transaction;
                $this->load->view('app/users/invoice', $page_data);
                return;
            }
        }else{
            redirect( 'dashboard/');
        }
    }

    // recurring
    public function recurring(){
        $id = $this->session->userdata('logged_id');
        $page_data['page'] = 'recurring';
        $page_data['title'] = 'Recurring charges';
        $page_data['user'] = $this->get_profile($id);
//        $page_data['transactions'] = $this->site->run_sql("SELECT")
        $this->load->view('app/users/recurring', $page_data);
    }

    // fund wallet
    public function wallet(){
        $id = $this->session->userdata('logged_id');
        $page_data['page'] = 'wallet';
        $page_data['title'] = 'My Wallet';
        $page_data['user'] = $this->get_profile( $id );
        $page_data['transactions'] = $this->site->run_sql("SELECT t.*, f.id fid, f.tid, f.bank, f.comment, f.image FROM transactions t 
        LEFT JOIN funds f ON(f.tid = t.id) WHERE t.product_id = 6 AND t.user_id = '{$id}' ORDER BY t.id DESC  LIMIT 100")->result();
        $trans_id = cleanit($this->uri->segment(3));
        $page_data['row'] = '';
        if( $trans_id ){
            if( $this->site->count_row('transactions', array('user_id' => $id , 'trans_id' => $trans_id) ) > 0 ){
                $page_data['row'] = $this->site->get_row('transactions', '*', array('trans_id' => $trans_id));
            }
            if( $_POST ){
                // @PARAMS: bank, file, comment
                $this->form_validation->set_rules('bank', 'Bank','trim|required|xss_clean');
                $this->form_validation->set_rules('comment', 'Comment','trim|required|xss_clean');
                if( $this->form_validation->run() == FALSE ){
                    $this->load->view('app/users/wallet', $page_data);
                    return;
                }
                $data = array(
                    'bank'      => $this->input->post('bank'),
                    'comment'   => $this->input->post('comment'),
                    'tid'       => $page_data['row']->id
                );

                if( isset($_FILES['pop']) ){
                    $config['upload_path'] = './assets/img/';
                    $config['allowed_types'] = 'jpeg|jpg|png';
                    $config['encrypt'] = true;
                    $this->load->library('upload', $config);
                    $this->upload->do_upload('pop');
                    $return = $this->upload->file_name;
                    if($return){
                        $data['image'] = $return;
                        unset($upload_array);
                        // Insert into DB and inform admin
                        $this->site->insert_data('funds', $data);
                        $this->session->set_flashdata('success_msg','Congrats. Your payment will be verified in less than a minute, and your wallet will be funded.');
                        $user = $this->site->get_row('users', 'id,name,phone', array('id' => $page_data['row']->user_id ));
                        $sms_array = array( '07019051931' =>  "{$user->name} just claimed to pay {$page_data['row']->amount} using Bank transfer.");
                        $this->load->library('AfricaSMS', $sms_array);
                        $this->africasms->sendsms();
                        // Send mail
                        redirect('dashboard/wallet/');
                    }else{
                        $this->session->set_flashdata('error_msg','There was an error with that image');
                        $this->load->view('app/users/wallet', $page_data);
                        return;
                    }
                }else{
                    $this->session->set_flashdata('error_msg', 'Please upload the proof of payment');
                    $this->load->view('app/users/wallet', $page_data);
                    return;
                }
            }else{
                $this->load->view('app/users/wallet', $page_data);
                return;
            }
        }else{
            $this->load->view('app/users/wallet', $page_data);
            return;
        }
    }

    // Transactions
    public function transactions(){
        $id = $this->session->userdata('logged_id');
        $page_data['page'] = 'transactions';
        $page_data['title'] = 'My Transactions';
        $page_data['user'] = $this->get_profile( $id );
        $page_data['transactions'] = '';
        $page_data['products'] = $this->site->get_result('products');
        if( $this->input->post() ){
            // start empty
            $start = $this->input->post('start');
            if( empty( $start) || !isset($start) ){
                $start = $_POST['start'] = date('Y-m-d', strtotime('first day of this year'));
            }else{
                $start = date('Y-m-d', strtotime($start));
            }
            $end = $this->input->post('end');
            if( empty( $end) || !isset($end) ){
                $end = $_POST['end'] = date('Y-m-d', strtotime('last day of this year'));
            }else{
                $end = date('Y-m-d', strtotime($end));
            }

            $query = "SELECT t.*, u.phone FROM transactions t LEFT JOIN users u ON(u.id = t.user_id) WHERE date_initiated BETWEEN '{$start}' AND '{$end}' AND user_id = {$id}";

            if( $this->input->post('transaction_type') ){
                $transaction = $this->input->post('transaction_type');
                $query .= " AND product_id = {$transaction} ORDER BY id DESC";
            }
            $page_data['transactions'] = $this->site->run_sql( $query )->result();
        }
        $this->load->view('app/users/transactions', $page_data);
    }
    /*
     * Airtime to wallet
     * */

    public function commission(){
        $id = $this->session->userdata('logged_id');
        $page_data['page'] = 'commission';
        $page_data['title'] = 'Transfer  the commission earned to your wallet';
        $page_data['user'] = $user = $this->get_profile($id);
        $this->form_validation->set_rules('amount', 'Amount','trim|required|xss_clean');
        if( $this->form_validation->run() == FALSE ){
            $this->session->set_flashdata('error_msg', validation_errors());
            $this->load->view('app/users/commission', $page_data);
            return;
        }else{
            $user = $this->get_profile($id);
            $amount = $this->input->post('amount', true);
            $amount = preg_replace("/[^0-9]/", '', $amount);
            if( $amount > $user->referral_bonus  || $amount < 1 ){
                $this->session->set_flashdata('error_msg', "Sorry, you can't transfer more than N" . $user->referral_bonus );
                $this->load->view('app/users/commission', $page_data);
                return;
            }
            try {
                $trans_id = time();
                $insert_commission = array(
                    'product_id'    => 13,
                    'trans_id'      => $trans_id,
                    'payment_method' => 4,
                    'date_initiated'    => get_now(),
                    'user_id'        => $id,
                );
                if( $amount >= 3000 ){
                    // credit to bank
                    $insert_commission['status'] = 'pending';
                    $insert_commission['amount'] = $amount - 100;
                    $insert_commission['description'] = "{$amount} referral commission request.";
                    $sms_array = array( '08161500635' => "{$user->name} just initiated referral commission of {$amount}.");
                    $this->load->library('AfricaSMS', $sms_array);
                    $this->africasms->sendsms();
                }else{
                    // moved to wallet
                    $insert_commission['status'] = 'success';
                    $insert_commission['amount'] = $amount;
                    $insert_commission['description'] = "{$amount} was moved from your referral bonus/commission to your wallet balance";
                    $this->site->set_field('users', 'wallet', "wallet+{$amount}", "id={$id}");
                }
                $this->site->set_field('users', 'referral_bonus', "referral_bonus-{$amount}", "id={$id}");
                $this->site->insert_data('transactions', $insert_commission);
                $this->session->set_flashdata('success_msg', "Success, Request has been received.");
            } catch (Exception $e) {
                $this->session->set_flashdata('error_msg', "Something was wrong, contact support");
            }
            redirect( 'dashboard/commission/');
        }

    }

    public function wallet2wallet(){
        $id = $this->session->userdata('logged_id');
        $page_data['page'] = 'wallet2wallet';
        $page_data['title'] = 'Transfer your wallet to another user on 567 Global Concept.';
        $page_data['user'] = $user = $this->get_profile($id);
        $this->form_validation->set_rules('amount', 'Amount','trim|required|xss_clean');
        if( $this->form_validation->run() == FALSE ){
            $this->session->set_flashdata('error_msg', validation_errors());
            $this->load->view('app/users/wallet2wallet', $page_data);
            return;
        }else{
            $user = $this->get_profile($id);
            $amount = $this->input->post('amount', true);
            $receiver = $this->input->post('receiver', true);
            $amount = preg_replace("/[^0-9]/", '', $amount);
            $total_amount = (int)$amount + 5;
            if( $amount > $user->wallet  || $amount < 1 || $amount > 5000 ){
                $this->session->set_flashdata('error_msg', "Error: you can only transfer between 1 - 5,000.");
                $this->load->view('app/users/wallet2wallet', $page_data);
                return;
            }

            $row = $this->site->get_row('users', 'id,wallet,name', "( email = '{$receiver}' OR phone ='{$receiver}' OR user_code ='{$receiver}')");
            if( !$row){
                $this->session->set_flashdata('error_msg', "The account user you are transferring to can't be found.");
                $this->load->view('app/users/wallet2wallet', $page_data);
                return;
            }
            if( $row->id == $id ){
                $this->session->set_flashdata('error_msg', "You can't transfer to your own account.");
                $this->load->view('app/users/wallet2wallet', $page_data);
                return;
            }

            $count = $this->db->query("SELECT * FROM transactions WHERE user_id = {$row->id} AND product_id = 6
                    AND ( status = 'approved' OR status = 'success')")->num_rows();
            if( $count <= 1 ){
                $this->session->set_flashdata('error_msg', "We can't process the action because the user has never fund His/her wallet before.");
                $this->load->view('app/users/wallet2wallet', $page_data);
                return;
            }

            try {
//                $password = cleanit($this->input->post('password'));
//                if(!$this->user->cur_pass_match($password, $id, 'users')){
//                    $this->session->set_flashdata('error_msg', "Oops! The password does not match your current password.");
//                    $this->load->view('app/users/wallet2wallet', $page_data);
//                    return;
//                }
                $transaction_id = time();
                $insert_data = array(
                    'amount'        => $amount,
                    'balance'        => $user->wallet - $total_amount,
                    'charge'        => 5,
                    'product_id'    => 7,
                    'description'   => $amount . " transferred from {$user->name} account to {$row->name} account." .lang('app_name'). " Charge: N5",
                    'trans_id'      => $transaction_id,
                    'payment_method' => 4,
                    'date_initiated'    => get_now(),
                    'user_id'        => $id,
                    'status'        => 'success'
                );
                if( $this->site->insert_data('transactions', $insert_data)){

                    $insert_data = array(
                        'amount'        => $amount,
                        'balance'        => $row->wallet + $amount,
                        'charge'        => 5,
                        'product_id'    => 7,
                        'description'   => $amount . " transferred to you from {$user->name}'s account.",
                        'trans_id'      => $transaction_id .'-'. $row->id,
                        'payment_method' => 4,
                        'date_initiated'    => get_now(),
                        'user_id'        => $row->id,
                        'status'        => 'success'
                    );

                    $this->site->insert_data('transactions', $insert_data);
                    $this->site->set_field('users', 'wallet', "wallet-{$amount}", "id={$id}"); // Giver
                    $this->site->set_field('users', 'wallet', "wallet+{$amount}", "id={$row->id}"); // Receiver

                    // return transaction ID
                    $this->session->set_flashdata('success_msg', "N{$amount} transferred successfully.");
                    $this->load->view('app/users/wallet2wallet', $page_data);
                    return;
                }else{
                    $this->session->set_flashdata('error_msg', "Oops! There was an error transferring the fund.");
                    $this->load->view('app/users/wallet2wallet', $page_data);
                    return;
                }
            } catch (Exception $e) {
                $this->session->set_flashdata('error_msg', "Something was wrong, contact support");
            }
            redirect( 'dashboard/commission/');
        }

    }

    public function airtime_to_wallet(){
        $id = $this->session->userdata('logged_id');
        if( isset($_GET['proceed']) && $_GET['proceed'] == 'true' && $this->session->userdata('a2wallet') ){
            //Send SMS
            $sms_array = array( '08161500635' => $this->session->userdata('a2wallet'));
            $this->session->set_flashdata('success_msg',"Thank you! Your request has been received and will be processed.");
            $this->load->library('AfricaSMS', $sms_array);
            $this->africasms->sendsms();
            redirect('dashboard/airtime_to_wallet');
        }elseif(isset($_GET['proceed']) && $_GET['proceed'] == 'false'){
            $transaction_row = $this->site->run_sql("SELECT id,tid FROM airtime_to_cash WHERE uid = {$id} ORDER BY id DESC LIMIT 1")->row();
            $this->site->delete( 'airtime_to_cash', array('id' => $transaction_row->id));
            $this->site->delete( 'transactions', array('id' => $transaction_row->tid));
        }
        $page_data['row'] = '';
        $page_data['page'] = 'airtime2wallet';
        $page_data['title'] = "Airtime to Wallet";
        $page_data['user'] = $this->get_profile( $id );
        $page_data['networks'] = $this->site->run_sql("SELECT p.slug, s.id, s.title, network_name, discount, image FROM products p LEFT JOIN services s ON (p.id = s.product_id) WHERE p.title ='airtime' ")->result();
        $this->load->view('app/users/airtime_to_wallet', $page_data);
    }
    /*
     * Airtime process
     * */
    function airtime_transfer(){
        $post_type = $this->input->post('post_type', true);
        $network = $this->input->post('airtime_pin_network');
        $user_id = $this->session->userdata('logged_id');
        switch ($post_type) {
            case 'pin_transfer':
                $product_id = 8;
                $this->form_validation->set_rules('airtime_pin_network', 'Airtime Network','trim|required|xss_clean');
                $this->form_validation->set_rules('pin', 'Pin Network','trim|required|xss_clean');
                $this->form_validation->set_rules('amount', 'Amount','trim|required|xss_clean');
                $this->form_validation->set_rules('amount_earned', 'Amount Earned','trim|required|xss_clean');
                if( $this->form_validation->run() == false ){
                    $this->session->set_flashdata('error_msg', validation_errors());
                    redirect('dashboard/airtime_to_wallet/');
                }

                $amount = $this->input->post('amount');
                $outgoing = $this->input->post('amount_earned');
                $transaction_id = time();
                $pin = trim($this->input->post('pin'));
                // Mtn - Airtel : 16, Glo - 9mobile : 15,
                $length = strlen( $pin );
                switch ( $network ) {
                    case 'glo':
                    case '9mobile':
                        if( $length != 15){
                            $this->session->set_flashdata('error_msg', "Error: The " . strtoupper( $network) . " network pin is invalid");
                            redirect('dashboard/airtime_to_wallet/');
                        }
                        break;
                    case 'mtn':
                    case 'airtime':
                        if( $length != 16){
                            $this->session->set_flashdata('error_msg', "Error: The " . strtoupper( $network) . " network pin is invalid");
                            redirect('dashboard/airtime_to_wallet/');
                        }
                        break;
                }

                $description = ucwords($network) . " N" . $amount . " pin transfer ( {$pin} ) to " . lang('app_name');
                $transaction_table = array(
                    'product_id' => $product_id,
                    'trans_id'      => $transaction_id,
                    'user_id'       => $user_id,
                    'amount'        => $amount,
                    'payment_method' => 4,
                    'description'   => $description,
                    'date_initiated'    => get_now(),
                    'status'            => 'pending'
                );
                try {
                    $receiving_channel = $this->input->post('how_to_receive');
                    $details = ucwords($network) . " N" . $amount . " pin transfer ( {$pin} ) to " .lang('app_name'). " and to receive by {$receiving_channel}";
                    $receiver = $this->input->post('receiver', true);
                    if( $receiver ) $details .= " : {$receiver}";
                    $this->db->trans_start();
                    $tid = $this->site->insert_data('transactions',  $transaction_table);
                    $airtime_to_cash_table = array(
                        'tid' => $tid,
                        'uid' => $user_id,
                        'network' => $network,
                        'incoming' => $amount,
                        'outgoing' => $outgoing,
                        'type' => $receiving_channel,
                        'status' => 'pending',
                        'details' => $details,
                        'datetime'  => get_now()
                    );
                    $this->site->insert_data('airtime_to_cash', $airtime_to_cash_table);
                    $this->db->trans_complete();
                    if ($this->db->trans_status() === FALSE){
                        $this->session->set_flashdata('error_msg', 'There was an error processing your request.');
                        $this->db->trans_rollback();
                    }else{
                        // Send a message to the admin??
                        $this->db->trans_commit();
                        $this->session->set_flashdata('success_msg', 'Please click on proceed to complete your request.');
                    }

                } catch (Exception $e) {

                }
                redirect('dashboard/airtime_to_wallet/');
                break;

            case 'airtime_transfer':
                $product_id = 9;
                $this->form_validation->set_rules('airtime_pin_network', 'Airtime Network','trim|required|xss_clean');
                $this->form_validation->set_rules('amount', 'Amount','trim|required|xss_clean');
                $this->form_validation->set_rules('sender', 'Number you are sending it from','trim|required|xss_clean');
                if( $this->form_validation->run() == false ){
                    $this->session->set_flashdata('error_msg', validation_errors());
                    redirect('dashboard/airtime_to_wallet/');
                }
                $airtime_pin_network = $this->input->post('airtime_pin_network');
                $amount = $this->input->post('amount');
                if( $amount < 500 || $amount > 5000 ){
                    $this->session->set_flashdata('error_msg', "You can only send airtime between N500 and N5000");
                    redirect('dashboard/airtime_to_wallet/');
                }
                $outgoing = $this->input->post('amount_earned');
                $transaction_id = time();
                $description = ucwords($network) . " N" . $amount . ucwords( $airtime_pin_network ). " airtime transfer to " .lang('app_name');
                $transaction_table = array(
                    'product_id' => $product_id,
                    'trans_id'      => $transaction_id,
                    'user_id'       => $user_id,
                    'amount'        => $amount,
                    'payment_method' => 4,
                    'description'   => $description,
                    'date_initiated'    => get_now(),
                    'status'            => 'pending'
                );

                try {
                    $details = "N" . $amount . " ". ucwords( $airtime_pin_network ). " network transfer to " .lang('app_name');
                    $details .= $this->switch_network_details( $network ,$amount);
                    $receiver = $this->input->post('receiver', true);
                    if( $receiver ) $details .= " : {$receiver}";
                    $this->db->trans_start();
                    $tid = $this->site->insert_data('transactions',  $transaction_table);
                    $airtime_to_cash_table = array(
                        'tid' => $tid,
                        'uid' => $user_id,
                        'network' => $network,
                        'incoming' => $amount,
                        'outgoing' => $outgoing,
                        'type' => 'wallet',
                        'details' => $details,
                        'datetime'  => get_now()
                    );
                    $aid = $this->site->insert_data('airtime_to_cash', $airtime_to_cash_table);
                    $this->db->trans_complete();
                    if ($this->db->trans_status() === FALSE){
                        $this->session->set_flashdata('error_msg', 'There was an error processing your request.');
                        $this->db->trans_rollback();
                    }else{
                        // Send a message to the admin??
                        $this->db->trans_commit();
                        $this->session->set_userdata('a2wallet', "A user just sent {$network}  - {$amount} airtime to you via transfer, to receive {$outgoing}. Go to dashboard to confirm.");
                        $this->session->set_flashdata('success_msg', "Please transfer N{$amount} to the number below following the instruction. Click on submit button once done.");
                        redirect('dashboard/preview/?a=' . $aid );
                    }

                } catch (Exception $e) {

                }
                redirect('dashboard/airtime_to_wallet/');
                break;
            default:
                break;
        }
    }

    /*
     * Airtime Preview
     * */
    public function preview(){
        $id = cleanit($this->input->get('a', true));
        if( !$id ) redirect( $_SERVER['HTTP_REFERER']);
        $row = $this->site->run_sql("SELECT * FROM airtime_to_cash WHERE id = {$id} ")->row();
        if( !$row ){
            $this->session->set_flashdata('error_msg', "Looks like you are looking for something else :( ");
            redirect($_SERVER['HTTP_REFERER']);
        }else{
            $id = $this->session->userdata('logged_id');
            $page_data['page'] = 'airtime2wallet';
            $page_data['title'] = "Airtime to Cash";
            $page_data['user'] = $this->get_profile( $id );
            $page_data['row'] = $row;
            $this->load->view('app/users/airtime_to_wallet', $page_data);
        }
    }

    function switch_network_details( $network, $amount ){
        $network = trim( strtolower($network) );
        $detail = '';
        $network_detail = $this->site->get_row('airtime_settings', '*', array('network' => $network))->phone_no;

        switch ( $network ){
            case 'glo':
//                08153886038
                $detail = "<br>Kindly transfer N{$amount} to {$network_detail}";
                $detail .= "<br>Dial: *131*{$network_detail}*{$amount}.0*PIN# If you don't have a PIN, Create new ,to use 1234 as your PIN Dial: *132*00000*newpin*newpin# i.e *132*00000*1234*1234# ";
                return $detail;
                break;
            case '9mobile':
                $detail = "<br>Kindly transfer N{$amount} to ";
                $detail .= "<br />Dial: *223*{$network_detail}*{$amount}.0*PIN# If you don't have a PIN, to use 1234 as your PIN Dial: *247*0000*new pin# i.e *247*0000*1234# ";
                return $detail;
                break;
            case 'airtel':
//                09073940928
                $detail = "<br /> Kindly transfer N{$amount} airtime from Airtel network to {$network_detail}";
                $detail .= "*432*1*# To {$network_detail} If you don't have a PIN *432*1*# (Default pin:1234)";
                return $detail;
                break;
            default:
                // mtn
                $detail = "<br />Transfer N{$amount} airtime on your MTN network MTN Share ’N’ Sell by dialing *600*{$network_detail}*{$amount}.0*PIN#";
                $detail .= "<br />If you don't have a PIN, use 1234 as your PIN Dial: *600*0000*new pin*new pin# i.e *600*0000*1234*1234# ";
                return $detail;
                break;
        }
    }


    // Settings
    public function profile(){
        $id = $this->session->userdata('logged_id');
        $page_data['page'] = 'profile';
        $page_data['title'] = "Profile Setting";
        $page_data['user'] = $this->site->run_sql("SELECT * FROM users WHERE id = {$id}")->row();
        $this->load->view('app/users/profile', $page_data);
    }

    function profile_setting(){
        $action_type = $this->input->post('post_type');
        $uid = $this->session->userdata('logged_id');
        switch ( $action_type ){
            case 'account':
                $this->form_validation->set_rules('name', 'Full name','trim|required|xss_clean|min_length[3]|max_length[50]');
                $this->form_validation->set_rules('account_name', 'Account name','trim|required|xss_clean|max_length[50]');
                $this->form_validation->set_rules('account_type', 'Account type','trim|required|xss_clean');
                $this->form_validation->set_rules('bank_name', 'Bank name','trim|required|xss_clean');
                $this->form_validation->set_rules('account_number', 'Account Number','trim|required|xss_clean');
                if( $this->form_validation->run() == false ){
                    $this->session->set_flashdata('error_msg', validation_errors());
                    redirect('dashboard/profile/');
                }else{
                    $password = cleanit($_POST['confirm_password']);
                    if(!$this->user->cur_pass_match($password, $uid, 'users')){
                        $this->session->set_flashdata('error_msg', "Oops! The password does not match your current password.");
                        redirect('dashboard/profile/');
                    }
                    $data = array(
                        'name' => cleanit($_POST['name']),
                        'account_name' => cleanit($_POST['account_name']),
                        'account_type' => cleanit($_POST['account_type']),
                        'bank_name' => cleanit($_POST['bank_name']),
                        'account_number' => cleanit($_POST['account_number']),
                    );

                    if( $this->site->update('users', $data, "(id = {$uid})")){
                        $this->session->set_flashdata('success_msg', "Profile updated successfully.");
                    }else{
                        $this->session->set_flashdata('error_msg', "There was an error updating your profile.");
                    }
                    redirect('dashboard/profile/');
                }
                break;
            case 'password_change':
                $this->form_validation->set_rules('current_password', 'Password','trim|required|xss_clean');
                $this->form_validation->set_rules('new_password', 'New Password','trim|required|xss_clean');
                $this->form_validation->set_rules('confirm_password', 'Confirm Password','trim|required|xss_clean|min_length[6]|max_length[15]|matches[new_password]');

                $password = cleanit($_POST['current_password']);
                if(!$this->user->cur_pass_match($password, $uid, 'users')){
                    $this->session->set_flashdata('error_msg', "Oops! The password does not match your current password. ");
                    redirect('dashboard/profile/');
                }
                $new_password = cleanit( $_POST['new_password'] );
                if( $this->user->change_password( $new_password, $uid, 'users')){
                    $this->session->set_flashdata('success_msg', "Password changed successfully.");
                }else{
                    $this->session->set_flashdata('error_msg', "There was an error updating your password.");
                }
                redirect('dashboard/profile/');
                break;
        }
    }

    public function payment_made(){
        $tid = cleanit( $this->input->get('tid', true));
        if( !$tid ) redirect('dashboard/wallet/');

        $row = $this->site->run_sql("SELECT amount, trans_id, description FROM transactions WHERE trans_id = {$tid}")->row();
        if( !$row ){
            $this->session->set_flashdata('error_msg', "The transaction does not exist.");
            redirect( 'dashboard/wallet/');
        }else{
            $page_data['row'] = $row;
            $page_data['page'] = 'payment_made';
            $page_data['title'] = "Payment Made";
            $page_data['user'] = $this->get_profile($this->session->userdata('logged_id'));
            $this->load->view('app/users/payment_made', $page_data);
        }
    }

    private function _submitGet( $data ){
        $post_url = $data['url'];
        unset($data['url']);
        $ponmo = http_build_query($data);
        $url = $post_url .'?'. $ponmo; // json
        $headers = array(
            "GET /HTTP/1.1",
            "User-Agent: Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.0.1) Gecko/2008070208 Firefox/3.0.1",
            "Accept: */* ",
            "Accept-Language: en-us,en;q=0.5",
            "Keep-Alive: 300",
            "Connection: keep-alive"
        );
        if( ini_get('allow_url_fopen') ) {
            $response = file_get_contents($url);
        } else {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_TIMEOUT, 60);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
            curl_setopt($ch, CURLOPT_POST, false);
            $response = curl_exec($ch);
            $response = json_decode($response, TRUE);
            curl_close($ch);
        }
        return $response;
    }
    public function callSMSAPI( $data ){
        $getResponse = $this->_submitGet(
            array(
                'url'   => "https://www.nellobytesystems.com/APIBuyBulkSMS.asp",
                'UserID' => CK_USER_ID,
                'APIKey' => CK_KEY,
                'Sender' => 'Payscribe',
                'Recipient' => '08066795128',
//                'Recipient' => '07019051931',
                'Message' => $data['message']
//                08151148607
            )
        );
        return json_decode($getResponse, true);
    }


    function get_profile($id){
        return $this->site->run_sql("SELECT phone, email,providus, name, user_code, wallet, account_type, membership_type, referral_bonus, is_admin, bank_name, account_type, account_name, account_number FROM users WHERE id = {$id}")->row();
    }


    private function payscribe_curl( $data ){
        $curl = curl_init();
        $post_url = $data['url'];
        unset($data['url']);
        $encdata = json_encode( $data );
        curl_setopt_array($curl, array(
            CURLOPT_URL => $post_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_POST => 1,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $encdata,
            CURLOPT_HTTPHEADER => array(
                "Content-Type: application/json",
                "Authorization: Bearer 2c5265e9eebb53b38652f90193c3092ebcd3c33594f61c012b6bed635cbef5a6",
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            echo "cURL Error #:" . $err;
            exit;
        } else {
            $response = json_decode( $response , true);
            return $response;
        }
    }

}
