<?php
class Api extends CI_Controller {

    public function __construct(){
        parent::__construct();
    }

	public function index(){
		redirect(base_url());
	}

    public function monify_webhook(){
        $body = @file_get_contents("php://input");
        http_response_code(200); // PHP 5.4 or greater
        $payload = json_decode( $body, true );
        if( empty( $payload )){
            redirect(base_url());
        }else{
            $transactionReference = $payload['transactionReference'];
            $paidOn = $payload['paidOn'];
            $paymentReference = $payload['paymentReference'];
            $amountPaid = $payload['amountPaid'];
            $transactionHash = $payload['transactionHash'];
            $string = MONIFY_SECRET .'|' . $paymentReference .'|' . $amountPaid.'|' .$paidOn .'|' . $transactionReference;
            $my_hash = hash('SHA512', $string) ;
            $customer_email = $payload['customer']['email'];
            if( $my_hash == $transactionHash ){
                $user = $this->site->get_row('users', 'wallet,id, name', array('email' => $customer_email));
                $transaction_id = $this->site->generate_code('transactions', 'trans_id');
                $charge = 54;
                $amount_credit = $amountPaid - $charge;
                $insert_data = array(
                    'amount'        => $amountPaid,
                    'balance'  =>      $user->wallet + $amountPaid ,
                    'charge'        => $charge,
                    'product_id'    => 6,
                    'description'   => "N{$amountPaid} Wallet funding using Providus Bank.",
                    'trans_id'      => $transaction_id,
                    'payment_method' => 5,
                    'date_initiated'    => get_now(),
                    'user_id'        => $user->id,
                    'status'        => 'approved'
                );
                $this->db->trans_start();
                $this->site->insert_data('transactions', $insert_data);
                $this->site->set_field('users', 'wallet', "wallet+{$amount_credit}", "id={$user->id}");
                $this->db->trans_complete();
                if ($this->db->trans_status() === FALSE){
                    // send user the mail
                    $message = "There was an error... Webhook :: API:monify_webhook Thats all I know...\r\n\r\n.";

                    $this->load->library('email');
                    $this->email->clear(TRUE);
                    $this->email->set_newline("\r\n");
                    $this->email->from( lang('app_email'), lang('site_name'));
                    $this->email->to("567servicesgroup@gmail.com");
                    $this->email->subject( 'There was an error updating a user wallet');
                    $this->email->message($message);
                    $this->email->send();
//					$this->my_email->send_debug_mail('API:Monify_webhook', "Transaction can not be updated. Payment Reference: " . $paymentReference);
                }else{
                    $this->db->trans_commit();
//					$this->my_email->wallet_updated($customer_email, $message);
                }
            }else{
                // transaction hash does not match
//				$this->my_email->send_debug_mail('API:Monify_webhook', "Transaction hash does not match.");
            }
        }
    }
}
