<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ajax extends CI_Controller {

    protected $valid_numbers;
    protected $invalid_numbers;
    protected $numbers = array();
    protected $message;
    public function __construct(){
        $this->valid_numbers = array();
        $this->message = $this->invalid_numbers = '';
        parent::__construct();
        if (!$this->input->is_ajax_request()) {
            redirect(base_url());
        }
    }

    /*
     *
     * Delete service for admin
     * */

    public function delete_service(){
        if( $this->session->userdata('logged_id') ){
            $response = array('status' => 'error');
            $id = $this->input->post('service_id');
            if( $this->site->delete( 'plans',  array('sid' => $id ))){
                $this->site->delete( 'services', array('id' => $id) );
                $response['status'] = 'success';
                $this->return_response($response);
            }else{
                $response['message'] = 'There was an error deleting that service';
                $this->return_response( $response);
            }
        }
    }

    /*
     * Delete Pending Transactions
     * */
    public function delete_transaction(){
        $tid = $this->input->post('tid', true);
        //
        if( $this->site->delete('transactions', array('id' => $tid)) ){
            $response['status'] = 'success';
            $this->return_response($response);
        }else{
            $response['message'] = 'There was an error deleting that service';
            $this->return_response( $response);
        }
    }


    public function delete_contact(){
        $tid = $this->input->post('id', true);
//        die( $tid );
        if( $this->site->delete('contacts', array('id' => $tid)) ){
            $response['status'] = 'success';
            $this->return_response($response);
        }else{
            $response['message'] = 'There was an error deleting that contact';
            $this->return_response( $response);
        }
    }

    /*
     * Confirm Transactions
     * */
    public function confirm_transaction(){
        if( $this->session->userdata('is_admin') == 1 ){
            $tid = $this->input->post('tid', true);
            $amount = $this->input->post('amount', true);
            $user_id = $this->input->post('user_id', true);
            if( $this->site->update('transactions', array('status' => 'approved'), array('id' => $tid)) ){
                $this->site->set_field('users', 'wallet', "wallet+{$amount}", "id={$user_id}");

                if( SEND_MAIL ){
                    $user = $this->get_profile($user_id);
                    $message = "Hi {$user->name},\r\n\r\nThis is to notify you that N{$amount} has been credited to your wallet,\r\n\r\nBest Regards,\r\n\r\n567Services Team.";

                    $this->load->library('email');
                    $this->email->clear(TRUE);
                    $this->email->set_newline("\r\n");
                    $this->email->from(lang('app_email'), lang('site_name'));
                    $this->email->to($user->email);
                    $this->email->subject( 'Wallet Updated - ' . lang('site_name'));
                    $this->email->message($message);
                    $this->email->send();
                }


                $response['status'] = 'success';
                $this->return_response($response);
            }else{
                $response['message'] = 'There was an error confirming that action.';
                $this->return_response( $response);
            }
        }
    }

    /*
     * Confirm the user upgrade account
     * */
    public function confirm_upgrade(){
        if( $this->session->userdata('is_admin') == 1 ){
            $tid = $this->input->post('tid', true);
            $type = $this->input->post('type', true);
            $amount = $this->input->post('amount', true);
            $user_id = $this->input->post('user_id', true);
            if( $this->site->update('upgrade', array('status' => 'approved'), array('id' => $tid)) ){
                $this->site->update('users', array('membership_type' => $type), array('id' => $user_id));

                // Lets give His uplines what they deserve
                $this->share_bonus( $user_id, $amount );
                $response['status'] = 'success';
                $this->return_response($response);
            }else{
                $response['message'] = 'There was an error confirming that action.';
                $this->return_response( $response);
            }
        }
    }

    /*
     * This will share all referral bonus to the user upline
     * */
    private function share_bonus( $user_id, $amount) {
        // This is a long walk ...
        $user_row = $this->get_profile( $user_id );
        $transaction_id = time();
        // Give the user his 50%
        $half = ( 0.5 * $amount );
        $insert_data = array(
            'charge'        => 0,
            'product_id'    => 6,
            'balance'    => $user_row->wallet + $half,
            'description'   => "50% of your upgrade amount ({$amount}) funded to your wallet.",
            'trans_id'      => $transaction_id,
            'payment_method' => 4,
            'date_initiated'    => get_now(),
            'user_id'        => $user_id,
            'platform'      => 'web',
            'status'        => 'success'
        );

        $this->site->set_field('users', 'wallet', "wallet+{$half}", "id={$user_id}");
        $this->site->insert_data('transactions', $insert_data);
        // Get the direct user detail
        if( $user_row->referral != '12457' ){
            // Get the direct user detail
            $direct = $this->upline_detail( $user_row->referral );
            $this->allocate_bonus( 'direct', $direct->membership_type,$amount, $transaction_id,  $direct->id, "Direct referral commission earned on {$user_row->name} upgrade." );
            if( $direct->referral != '12457'){
                // 2nd generation
                $second = $this->upline_detail( $direct->referral );
                $this->allocate_bonus( 'second', $second->membership_type,$amount, $transaction_id,  $second->id, "Second generation referral commission earned on {$user_row->name} upgrade."  );

                // 3rd Generation
                if( $second->referral != '12457' ){
                    $third = $this->upline_detail( $second->referral );
                    $this->allocate_bonus( 'third', $third->membership_type,$amount, $transaction_id,  $third->id, "Third generation referral commission earned on {$user_row->name} upgrade."  );

                    if( $third->referral != '12457') {
                        // Fourth Generation
                        $fourth = $this->upline_detail( $third->referral );
                        $this->allocate_bonus( 'fourth', $fourth->membership_type,$amount, $transaction_id,  $fourth->id, "Fouth generation referral commission earned on {$user_row->name} upgrade."  );
                        /*
                         *
                        7. 4th generation upgrade bonus shows as 3rd generation.

                        8. 5th generation showing as third generation and pays 2% instead of 1%
                        */
                        if( $fourth->referral != '12457'){
                            // Fifth generation
                            $fifth = $this->upline_detail( $fourth->referral );
                            $this->allocate_bonus( 'fifth', $fifth->membership_type,$amount, $transaction_id,  $fifth->id, "Fifth generation referral commission earned on {$user_row->name} upgrade."  );
                        }
                    }
                }
            }
        }
    }

    private function upline_commission( $referral, $name , $amount,  $type){

        // Diamond

        $upline_user = $this->site->run_sql("SELECT id , referral,referral_bonus, membership_type FROM users WHERE user_code = '".$referral."' ")->row();
        $fee = 0;
        if( strtolower(trim($upline_user->membership_type)) == 'diamond' ){
            $fee = ( $type == 'airtime') ? 0.01 * $amount : 25; // diamond
        }else{
            $fee = ( $type == 'airtime') ? 0.005 * $amount : 15; // gold
        }
        $transaction_id = time();
        // Give the user his 50%
        $insert_data = array(
            'charge'        => 0,
            'product_id'    => ($type == 'airtime') ? 2 : 1,
            'amount' => $fee,
            'balance'    => $upline_user->referral_bonus + $fee,
            'description'   => "N{$fee} added to your referral wallet from a downline ({$name}) {$type} purchase transaction.",
            'trans_id'      => $transaction_id,
            'payment_method' => 4,
            'date_initiated'    => get_now(),
            'user_id'        => $upline_user->id,
            'platform'      => 'web',
            'status'        => 'success'
        );
        $this->site->set_field('users', 'referral_bonus', "referral_bonus+{$fee}", "id={$upline_user->id}");
        $this->site->insert_data('transactions', $insert_data);

    }

    // This function helps us to distribute the bonus
    protected function allocate_bonus( $type , $membership_type,$amount, $transaction_id, $uid, $description ){

        $insert_data = array(
            'charge'        => 0,
            'product_id'    => 10,
            'description'   => $description,
            'trans_id'      => $transaction_id,
            'payment_method' => 4,
            'date_initiated'    => get_now(),
            'user_id'        => $uid,
            'platform'      => 'web',
            'status'        => 'success'
        );
        // We are switching the upline membership type
        switch ( $membership_type ) {
            case 'bronze':
                // Only entitled for direct referral bonus
                if( $type == 'direct' ){
                    $insert_data['amount'] = (10/100 * $amount);
                    $this->site->set_field('users', 'referral_bonus', "referral_bonus+{$insert_data['amount']}", "id={$uid}");
                    $this->site->insert_data('transactions', $insert_data);
                }
                break;
            case 'silver':
                if( $type == 'direct' ){
                    $insert_data['amount'] = (15/100 * $amount);
                    $this->site->set_field('users', 'referral_bonus', "referral_bonus+{$insert_data['amount']}", "id={$uid}");
                    $this->site->insert_data('transactions', $insert_data);
                }elseif( $type == 'second' ){
                    $insert_data['amount'] = (7/100 * $amount);
                    $this->site->set_field('users', 'referral_bonus', "referral_bonus+{$insert_data['amount']}", "id={$uid}");
                    $this->site->insert_data('transactions', $insert_data);
                }elseif( $type == 'third' ){
                    $insert_data['amount'] = (5/100 * $amount);
                    $this->site->set_field('users', 'referral_bonus', "referral_bonus+{$insert_data['amount']}", "id={$uid}");
                    $this->site->insert_data('transactions', $insert_data);
                }
                break;
            case 'gold':
                if( $type == 'direct' ){
                    $insert_data['amount'] = (20/100 * $amount);
                    $this->site->set_field('users', 'referral_bonus', "referral_bonus+{$insert_data['amount']}", "id={$uid}");
                    $this->site->insert_data('transactions', $insert_data);
                }elseif( $type == 'second' ){
                    $insert_data['amount'] = (7/100 * $amount);
                    $this->site->set_field('users', 'referral_bonus', "referral_bonus+{$insert_data['amount']}", "id={$uid}");
                    $this->site->insert_data('transactions', $insert_data);
                }elseif( $type == 'third' ){
                    $insert_data['amount'] = (5/100 * $amount);
                    $this->site->set_field('users', 'referral_bonus', "referral_bonus+{$insert_data['amount']}", "id={$uid}");
                    $this->site->insert_data('transactions', $insert_data);
                }elseif( $type == 'fourth' ){
                    $insert_data['amount'] = (2/100 * $amount);
                    $this->site->set_field('users', 'referral_bonus', "referral_bonus+{$insert_data['amount']}", "id={$uid}");
                    $this->site->insert_data('transactions', $insert_data);
                }

                break;
            case 'diamond':
                if( $type == 'direct' ){
                    $insert_data['amount'] = (25/100 * $amount);
                    $insert_data['description'] = $description;
                    $this->site->set_field('users', 'referral_bonus', "referral_bonus+{$insert_data['amount']}", "id={$uid}");
                    $this->site->insert_data('transactions', $insert_data);
                }elseif( $type == 'second' ){
                    $insert_data['amount'] = (7/100 * $amount);
                    $this->site->set_field('users', 'referral_bonus', "referral_bonus+{$insert_data['amount']}", "id={$uid}");
                    $this->site->insert_data('transactions', $insert_data);
                }elseif( $type == 'third' ){
                    $insert_data['amount'] = (5/100 * $amount);
                    $this->site->set_field('users', 'referral_bonus', "referral_bonus+{$insert_data['amount']}", "id={$uid}");
                    $this->site->insert_data('transactions', $insert_data);
                }elseif( $type == 'fourth' ){
                    $insert_data['amount'] = (2/100 * $amount);
                    $this->site->set_field('users', 'referral_bonus', "referral_bonus+{$insert_data['amount']}", "id={$uid}");
                    $this->site->insert_data('transactions', $insert_data);
                }else{
                    $insert_data['amount'] = (1/100 * $amount);
                    $insert_data['description'] = $description;
                    $this->site->set_field('users', 'referral_bonus', "referral_bonus+{$insert_data['amount']}", "id={$uid}");
                    $this->site->insert_data('transactions', $insert_data);
                }
                break;
        }

    }

    protected function upline_detail( $ref_code ){
        return $this->site->run_sql("SELECT id, referral, membership_type, status FROM users WHERE user_code = {$ref_code}")->row();
    }


    /*
     * Delete Pending Transactions
     * */
    public function delete_upgrade(){
        $tid = $this->input->post('tid', true);
        // Diesel tumec generator 4kva
        if( $this->site->delete('upgrade', array('id' => $tid)) ){
            $response['status'] = 'success';
            $this->return_response($response);
        }else{
            $response['message'] = 'There was an error deleting that service';
            $this->return_response( $response);
        }
    }

    public function confirm_reseller(){
        if( $this->session->userdata('is_admin') == 1 ){
            $tid = $this->input->post('tid', true);
            $user_id = $this->input->post('user_id', true);
            if( $this->site->update('transactions', array('status' => 'approved'), array('id' => $tid)) ){
                $this->site->update('users', array('membership_type' => 'reseller'), array('id' => $user_id));
                $response['status'] = 'success';
                $this->return_response($response);
            }else{
                $response['message'] = 'There was an error confirming that action.';
                $this->return_response( $response);
            }
        }
    }

    /*
     *
     * Delete plan for admin
     * */

    public function delete_plan(){
        if( $this->session->userdata('is_admin') == 1 ){
            $response = array('status' => 'error');
            $id = $this->input->post('plan_id');
            if( $this->site->delete( 'plans',  array('id' => $id )) ){
                $response['status'] = 'success';
                $this->return_response($response);
            }else{
                $response['message'] = 'There was an error deleting that plan';
                $this->return_response( $response);
            }
        }
    }


    public function fetch_plans(){
        $response = array('status' => 'error');
        $id = $this->input->post_get('service_id', true);
        $plans_array = array();
        $plans = $this->site->run_sql("SELECT * FROM plans WHERE sid = {$id} ORDER BY amount ASC")->result();
        $response['message'] = (array)$plans;
        if( $plans ){
            $response['status'] = 'success';
            foreach( $plans as $plan ){
                $res['id'] = $plan->id;
                $res['name'] = $plan->name;
                $res['amount'] = $plan->amount ;
                $res['variation'] = $plan->variation ;
                array_push( $plans_array, $res );
            }
            $response['message'] = $plans_array;
        }
        $this->return_response( $response );
    }

    /*
     * Wallet funding
     * @PARAMS : payment_method, amount, bank
     * */
    public function fund_wallet(){
        $product_id = '6';
        $response = array('status' => 'error');
        $payment_method = $this->input->post('payment_method', true);
        $amount = $this->input->post('amount', true);

        $payment_method = (int)$payment_method;
        $description = "Wallet funding via {{$payment_method}}";
        if( $this->input->post('bank') ) {$description .= " To " . $this->input->post('bank');}
        $transaction_id = time();
        // paystack charge
        $charge = 0;
        if( $payment_method == 3 ){
            $charge = (1.5 / 100 ) * $amount;
        }
        if( $payment_method == 1 && $amount < 1000 ){
            $response['message'] = 'You can only fund N1000 above with bank transfer.';
            $this->return_response( $response);
        }
        $insert_data = array(
            'amount'        => $amount,
            'charge'        => $charge,
            'product_id'    => $product_id,
            'description'   => $description,
            'trans_id'      => $transaction_id,
            'payment_method' => $payment_method,
            'date_initiated'    => get_now(),
            'user_id'        => $this->session->userdata('logged_id'),
            'platform'      => 'web',
            'status'        => 'pending'
        );



        if( $this->site->insert_data('transactions', $insert_data)){
            // return transaction ID
            $response['status'] = 'success';
            $response['message'] = $transaction_id;
            $this->return_response( $response);
        }else{
            $response['message'] = 'There was an error creating your transaction ID';
            $this->return_response( $response);
        }

    }

    /*
     * Data purchase
     * */
    public function data_purchase(){

        $response = array('status' => 'error');
        $product_id = 1;

        $plan_id = $this->input->post('plan_id', true);
        $service_id = $this->input->post('network', true);
        $recipent = $this->input->post('recipent', true);
        $frequency = $this->input->post('frequency', true);
        $ported = $this->input->post('ported', true);
        // check for number validity

        $user_row = $this->get_profile( $this->session->userdata('logged_id'));
        $user_id = $this->session->userdata('logged_id');
        $service_row = $this->service_row_plan( $service_id, $plan_id);

        if( $service_row ){
            // validate phone number
            $this->validate_numbers( $recipent, $service_row->network_name, $ported);
        }else{
            $response['message'] = "We couldn't process your order because the service does not exist.";
            $this->return_response( $response );
        }
        $count = count($this->valid_numbers);

        if( $count ){
            $total_amount = $count * $service_row->amount;

            if( $total_amount > $user_row->wallet || $user_row->wallet < 1 ){
                $response['message'] = "You don't have enough money in your wallet for the transaction.";
                $this->return_response($response);
            }else{
                $description = ucfirst( $service_row->network_name) . " {$service_row->name} - $service_row->amount Data purchase for {$count} recipent ({$this->message})";
                $transaction_id = time();
                $insert_data = array(
                    'amount'        => $total_amount,
                    'product_id'    => $product_id,
                    'balance'    => $user_row->wallet - $total_amount,
                    'description'   => $description,
                    'trans_id'      => $transaction_id,
                    'payment_method' => 4,
                    'date_initiated'    => get_now(),
                    'user_id'        => $user_id,
                    'status'        => 'success'
                );
                $this->db->trans_start();
                $networkIds = array(
                    'mtn' => 1,
                    'glo'   => 2,
                    '9mobile'   => 3,
                    'airtel'    => 4
                );
                $this->site->set_field('users', 'wallet', "wallet-{$total_amount}", "id={$user_id}");
                $this->site->insert_data('transactions', $insert_data);
                foreach( $this->valid_numbers as $number ){
                    $network = $service_row->network_name;

                    $data = array(
                        'network' => $networkIds[$network],
                        'mobile_number'	=> $number,
                        'plan' => $service_row->ref_id,
                        'Ported_number' => false,
                        'token' => '5e1c25bcdb9d1cd85c4edc3364963cd87591d3d9',
                        'url' => "https://www.affatech.com.ng/api/data/"
                    );
                    $this->dataCurl( $data );
                    sleep(6);
                    next( $this->valid_numbers );
                }

                /*
                 *
                 * - User login details on your site
Userid : 08030733608
Pword: Gang@1991

- Admin login details
Username: Admin@gmail.com
Pword: re5pectEd%*/

                $this->db->trans_complete();
                if ($this->db->trans_status() === FALSE){
                    $this->db->trans_rollback();
                    $response['message'] = "There was an error with your request. Please chat us up if debited.";
                    $this->return_response($response);
                }else{


                    $this->db->trans_commit();
                    $response['status'] = 'success';
                    $response['message'] = "Thanks for using " .lang('app_name'). ". Your {$service_row->name} data plan order for {$this->message} has been processed. Please check balance with <b>{$service_row->check_balance}</b><br />";
                    if( $this->invalid_numbers != '' ){
                        $response['message'] .=  $this->invalid_numbers ." was not processed. because they are invalid or {$service_row->network_name} number";
                    }
                    $response['message'] .= "<br />Your transaction ID: <b>{$transaction_id}</b>";
                    // incensitive reward
                    if( $this->incentive_count( $user_id )){
                        $trans_id = time();
                        $incentive = array(
                            'amount'        => 500,
                            'product_id'    => 13,
                            'balance'    => $user_row->wallet - $total_amount,
                            'description'   => "N500 credited to your wallet for making over 30 data transactions on the platform.",
                            'trans_id'      => $trans_id,
                            'payment_method' => 4,
                            'date_initiated'    => get_now(),
                            'user_id'        => $user_id,
                            'status'        => 'success'
                        );
                        $this->site->insert_data('transactions', $incentive);
                        $this->site->set_field('users', 'wallet', "wallet+500", "id={$user_id}");
                    }

                    // lets give his upline a commission for this
                    if( $user_row->referral != '12457' ){
                        $this->upline_commission( $user_row->referral, $user_row->name , $total_amount, 'data');
                    }
                    $this->return_response($response);
                }
            }
        }else{
            $response['message'] = "We couldn't process your order because the number(s) {$this->invalid_numbers} is not ". ucfirst($service_row->network_name). " number(s) ";
            $this->return_response($response);
        }

    }

    function dataCurl( $data ){
        $url = $data['url']; unset( $data['url']);
        $token = $data['token']; unset( $data['token']);

        $encdata = json_encode( $data );
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $encdata);
        curl_setopt(
            $ch, CURLOPT_HTTPHEADER, array('Authorization: Token ' . $token, "Content-Type: application/json")
        );
        $res = curl_exec($ch);
        curl_close($ch);
        return $res;
    }

    function simhostng($urlxxx, $dataxxx) {
        $ch = curl_init($urlxxx);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $dataxxx);
        $rxxxxxxxx = curl_exec($ch);
        curl_close($ch);
        return $rxxxxxxxx;
    }

    function incentive_count( $user_id ){
        $this_month = strtotime('this month');
        $count = $this->site->run_sql("SELECT id FROM transactions WHERE product_id = 1 
        AND date_initiated = '{$this_month}' AND user_id = $user_id ")->row();
        if( count($count) == 30 || count($count) == 50 ){
            return true;
        }
        return false;
    }

    /*
     * Airtime
     * */

    public function buy_airtime(){
        $response = array('status' => 'error');
        $product_id = 2;
        // LETS PROCESS
        $this->form_validation->set_rules('amount', 'Amount','trim|required|xss_clean');
        $this->form_validation->set_rules('network', 'Network','trim|required|xss_clean');
        $this->form_validation->set_rules('recipent', 'Phone Number','trim|required|xss_clean');
        if(  $this->form_validation->run() == FALSE ){
            $response['message'] = validation_errors();
            $this->return_response( $response );
        }


        $amount = $this->input->post('amount', true);
        $recipent = $this->input->post('recipent', true);
        $network = $this->input->post('network', true);
        $ported = $this->input->post('ported', true);

        if(  $amount < 100 ){
            $response['message'] = "Amount can't be less than N100";
            $this->return_response( $response );
        }

        $user_row = $this->get_profile( $this->session->userdata('logged_id'));
        $user_id = $this->session->userdata('logged_id');
        $service_row = $this->service_row( $network );

        if( $service_row ){
            // validate phone number
            $this->validate_numbers( $recipent, $service_row->network_name, $ported );
        }else{
            $response['message'] = "We couldn't process your order because the service does not exist.";
            $this->return_response( $response );
        }
        $count = count($this->valid_numbers);

        if( $count ){
            $total_amount = $count * $amount;
            if( $service_row->discount > 1 ){
                $total_amount = $total_amount - ( $service_row->discount/100 * $total_amount );
            }
            if( $total_amount > $user_row->wallet || $user_row->wallet < 1 ){
                $link = base_url('dashboard/wallet/');
                $response['message'] = "You don't have enough money in your wallet for the transaction. <a href='{$link}' title='Fund wallet'>Please fund your wallet</a>";
                $this->return_response($response);
            }else{
//                $check = $this->site->check_transaction( array('user_id' => $user_id, 'product_id' => $product_id));
//                if( $check > 0 ){
//                    $response['message'] = "Duplicate transaction, please wait after 5 minute before processing again.";
//                    $this->return_response($response);
//                }

                $description = ucfirst( $service_row->network_name) . " airtime N{$amount} purchase for {$this->message}";
                $transaction_id = time();
                $insert_data = array(
                    'amount'        => $total_amount,
                    'product_id'    => $product_id,
                    'balance'    => $user_row->wallet - $total_amount,
                    'description'   => $description,
                    'trans_id'      => $transaction_id,
                    'payment_method' => 4,
                    'date_initiated'    => get_now(),
                    'user_id'        => $user_id
                );
                // Call the API
                foreach( $this->valid_numbers as $number ){
                    $data = array(
                        'network'   => $service_row->network_name,
                        'amount'    => $amount,
                        'number'    => $number
                    );
                    $return = $b = $this->callAirtimeAPI( $data );
                    if( $return['status'] == "ORDER_RECEIVED" || $return['status'] == "ORDER_COMPLETED" ){
                        $insert_data['orderid'] = $return['orderid'];
                        $insert_data['status'] = 'success';
                        $insert_data['payment_status'] = $return['status'];
                    }else{
                        $insert_data['status'] = 'pending';
                        if( $return['orderid'] ) $insert_data['orderid'] = $return['orderid'];
                        $insert_data['payment_status'] = $return['status'];
                    }
                }
                $this->db->trans_start();
                $this->site->set_field('users', 'wallet', "wallet-{$total_amount}", "id={$user_id}");
                $insert_id = $this->site->insert_data('transactions', $insert_data);
                $this->db->trans_complete();
                if ($this->db->trans_status() === FALSE){
                    $this->db->trans_rollback();
                    $response['message'] = "There was an error with your request. Please chat us up if debited.";
                    $this->return_response($response);
                }else{
                    $response['status'] = 'success';

                    $response['message'] = "Thanks for using " .lang('app_name'). ". Your order {$this->message} has been processed and should be received in less than a minute. <br />";
                    if( $this->invalid_numbers != '' ){
                        $response['message'] .=  $this->invalid_numbers ." was not processed. because they are invalid or {$service_row->network_name} number";
                    }
                    $response['message'] .= "<br />Your transaction ID: <b>{$transaction_id}</b>!";

                    // lets give his upline a commission for this
                    if( $user_row->referral != '12457' ){
                        $this->upline_commission( $user_row->referral , $user_row->name, $amount, 'airtime');
                    }

                    $this->return_response($response);
                }
            }
        }else{
            $response['message'] = "We couldn't process your order because the number(s) {$this->invalid_numbers} is not ". ucfirst($service_row->network_name). " number(s) ";
            $this->return_response($response);
        }

    }

    /*
     * Fetch Service row
     * */
    function service_row_plan( $sid , $pid){
        return $this->site->run_sql("SELECT s.network_name,s.product_id, p.name, p.amount, p.variation, p.ref_id, check_balance FROM services s LEFT JOIN plans p ON (s.id = p.sid) WHERE s.id = {$sid} AND p.id ={$pid}  ")->row();
    }

    function service_row( $sid ){
        return $this->site->run_sql("SELECT * FROM services WHERE id = {$sid}")->row();
    }

    function validate_numbers( $numbers, $network_name , $ported){
        if( isset($ported) ){
            array_push($this->valid_numbers, $numbers);
            $this->message = $numbers. ',';
            return;
        }
        $numbers = explode( ',', $numbers);
        foreach( $numbers as $key => $msisdn ){
            $msisdn = preg_replace('/\D/', '', $msisdn);
            $strlen = strlen( $msisdn );
//            $msisdn = ($strlen = 10 ) ? '0'.$msisdn : $msisdn;
            switch ($strlen) {
                case 11:
                    $local_prefix = substr($msisdn, 0 , 4);
                    if( in_array($local_prefix, NIGERIA_TELCOS[$network_name])){
                        array_push($this->valid_numbers, $msisdn);
                        $this->message .= $msisdn. ',';
                    }else{
                        $this->invalid_numbers .= $msisdn;
                    }
                    break;
                case 13:
                    $local_prefix = substr($msisdn, 0 , 6);
                    if( in_array($local_prefix, NIGERIA_TELCOS[$network_name])){
                        array_push($this->valid_numbers, $msisdn);
                        $this->message .= $msisdn. ',';
                    }else{
                        $this->invalid_numbers .= $msisdn;
                    }
                    break;
                default:
                    $this->invalid_numbers .= $msisdn;
                    break;
            }
        }
    }



    private function _submitGet( $data ){
        $post_url = $data['url'];
        unset($data['url']);
        $ponmo = http_build_query($data);
        $url = $post_url .'?'. $ponmo; // json
        $headers = array(
            "GET /HTTP/1.1",
            "User-Agent: Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.0.1) Gecko/2008070208 Firefox/3.0.1",
            "Accept: */* ",
            "Accept-Language: en-us,en;q=0.5",
            "Keep-Alive: 300",
            "Connection: keep-alive"
        );
        if( ini_get('allow_url_fopen') ) {
            $response = file_get_contents($url);
        } else {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_TIMEOUT, 60);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
            curl_setopt($ch, CURLOPT_POST, false);
            $response = curl_exec($ch);
            $response = json_decode($response, TRUE);
            curl_close($ch);
        }
        return $response;
    }


    public function fetch_bouquets(){
        $type = cleanit($_GET['network']);
        $resp = $this->payscribe_curl_get("https://api.payscribe.ng/api/v1/bouquets?service={$type}");
        $plans_array = array();
        if( $resp['status'] ){
            $response['status'] = 'success';
            foreach( $resp['message']['details'] as $plan ){
                $res['id'] = simple_crypt($plan['id'] .'|' . $plan['amount']);
                $res['name'] = $plan['name'];
                $res['amount'] = $plan['amount'];
                if( $res['amount'] != 0 ){ array_push( $plans_array, $res ); }
            }
            $response['message'] = $plans_array;
        }
        $this->return_response( $response );
    }

    public function verify_tv(){
        $response['status'] = 'error';
        $service = cleanit( $_GET['network_name']);
        $account = cleanit( $_GET['smart_card_number']);
        $plan_id = cleanit( $_GET['plan']);
        $month = cleanit( $_GET['month']);

        if( !$service || !$account || !$plan_id ){
            $response['message'] = "Service, smart card number and plan can not be empty";
            $this->return_response( $response );
        }

        $plan_id = explode( '|', simple_crypt($plan_id, 'd'));
        $data = array(
            'url'       => "https://api.payscribe.ng/api/v1/multichoice/validate",
            'service'   => $service,
            'account'    => $account,
            'plan_id'  => $plan_id[0],
            'month'  => $month,
        );
        $resp = $this->payscribe_curl( $data );


        if( $resp['status']){
            $response['status'] = 'success';
            $response['message'] = $resp['message']['details']['customer_name'];
            $this->return_response( $response );
        }

        $response['message'] = "An error occurred when validating. Please try again";
        $this->return_response( $response );
    }

    private function payscribe_curl( $data ){
        $curl = curl_init();
        $post_url = $data['url'];
        unset($data['url']);
        $encdata = json_encode( $data );

        curl_setopt_array($curl, array(
            CURLOPT_URL => $post_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_POST => 1,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $encdata,
            CURLOPT_HTTPHEADER => array(
                isset( $get ) ? null : "Content-Type: application/json",
                "Authorization: Bearer 2c5265e9eebb53b38652f90193c3092ebcd3c33594f61c012b6bed635cbef5a6",
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $response = json_decode( $response , true);
            return $response;
        }
    }

    private function payscribe_curl_get($url){
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer 2c5265e9eebb53b38652f90193c3092ebcd3c33594f61c012b6bed635cbef5a6'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $response = json_decode( $response , true);
        return $response;
    }

    /*
     *
     * Paystack verification
     * */
    function verifyPaystack(){
        $response = array('status' => 'error');
        $paystackreference = $this->input->post('reference', true);
        $ref = $this->input->post('ref', true);
        // Get row of the transaction
        $row = $this->site->run_sql("SELECT user_id, amount, charge, product_id FROM transactions WHERE trans_id = '{$ref}'")->row();
        if( !$row ){
            $response['message'] = "We couldn't find the transaction.";
            $this->return_response($response);
        }else{
            $amount = (int) $row->amount;
            //The parameter after verify/ is the transaction reference to be verified
            $url = 'https://api.paystack.co/transaction/verify/' . $paystackreference;
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt(
                $ch, CURLOPT_HTTPHEADER, array('Authorization: Bearer '. S_KEY)
            );
            $request = curl_exec($ch);
            curl_close($ch);
            if ($request) {
                $result = json_decode($request, true);
                // print_r($result);
                if($result){
                    if($result['data']){
                        //something came in
                        if($result['data']['status'] == 'success'){
                            // the transaction was successful, you can deliver value
                            // Update the transaction
                            $this->db->trans_start();
                            $paystack_amount = $result['data']['amount']/100;
                            $amount_paid = $paystack_amount - $row->charge;
                            $this->site->update('transactions', array('status' => 'approved', 'payment_status' => $result['message'], 'amount' => $amount_paid), "(trans_id = '{$ref}')" );
                            $this->site->set_field('users', 'wallet', "wallet+{$amount_paid}", "id={$row->user_id}");
                            $this->db->trans_complete();
                            if ($this->db->trans_status() === FALSE){
                                $this->db->trans_rollback();
                                $response['message'] = "There was an error updating your payment. Please chat us up if debited.";
                                $this->return_response($response);
                            }else{
                                // Send a message to the admin??

                                $this->db->trans_commit();

                                if( SEND_MAIL ){
                                    $user = $this->get_profile($row->user_id);
                                    $message = "Hi {$user->name},\r\n\r\nThis is to notify you that N{$amount} has been credited to your wallet,\r\n\r\nBest Regards,\r\n\r\n567 Global Concept Team.";

                                    $this->load->library('email');
                                    $this->email->clear(TRUE);
                                    $this->email->set_newline("\r\n");
                                    $this->email->from(lang('app_email'), lang('app_name'));
                                    $this->email->to($user->email);
                                    $this->email->subject( 'Wallet Updated - ' . lang('app_name'));
                                    $this->email->message($message);
                                    $this->email->send();
                                }
                                $response['status'] = 'success';
                                $response['message'] = "Transaction successful.";
                                $this->return_response($response);
                            }
                        }else{
                            // the transaction was not successful, do not deliver value'
                            // print_r($result);  //uncomment this line to inspect the result, to check why it failed.
                            $response['message'] = "Transaction was unsuccessful, please contact us if debited.";
                            $this->return_response($response);

                        }
                    }else{
                        $response['message'] = $result['message'];
                        $this->return_response($response);
                    }

                }else{
                    //print_r($result);
                    $response['message'] = "Technical Error. Please contact us if persist.";
                    $this->return_response($response);
//                    die("Something went wrong while trying to convert the request variable to json. Uncomment the print_r command to see what is in the result variable.");
                }
            }else{
                //var_dump($request);
                $response['message'] = "Error";
                $this->return_response($response);
//                die("Something went wrong while executing curl. Uncomment the var_dump line above this line to see what the issue is. Please check your CURL command to make sure everything is ok");
            }
        }
    }

    /*
     * network ish
     * */

    public function fetch_network_price(){
        $response = array('status' => 'success');
        $network = $this->input->post_get('network');
        $rate = $this->site->get_row('airtime_settings', 'percentage', array('network' => $network))->percentage;
        $response['message'] = $rate;
        $this->return_response( $response );
    }


    function get_profile($id){
        return $this->site->run_sql("SELECT id, phone, email, name, user_code,referral, wallet, account_type, membership_type, is_admin FROM users where id = {$id}")->row();
    }

    // For Airtime

    public function callAirtimeAPI( $data ){
        $network_code = network_code($data['network']);
        $getResponse = $this->_submitGet(
            array(
                'url'   => "https://www.nellobytesystems.com/APIBuyAirTime.asp",
                'UserID' => CK_USER_ID,
                'APIKey' => CK_KEY,
                'MobileNetwork' => $network_code,
                'Amount' => $data['amount'],
                'MobileNumber' => $data['number'],
            )
        );
        return json_decode($getResponse, true);
    }


    function upgrade_membership_request(){
        $response = array('status' => 'error');
        $type = strtolower($this->input->post('type', true));
        $amount = strtolower($this->input->post('amount', true));
        $uid = $this->session->userdata('logged_id');
        if( $uid ){
            $array = array(
                'uid' => $uid,
                'type' => $type,
                'amount' => $amount,
                'date_initiated' => get_now(),
                'status' => 'pending'
            );
            if( $this->site->get_row('upgrade', 'id', array('uid'=> $uid, 'status' => 'pending'))){
                $response['message'] = "Sorry, you have a pending membership upgrade, contact the admin.";
            }else{
                $insert_id = $this->site->insert_data('upgrade', $array );
                if( $insert_id ){
                    $response['status'] ='success';
                    $response['message'] = $insert_id;
                    $sms_array = array( '08161500635' => "A user just initiate membership upgrade request, Go to admin to confirm.");
                    $this->load->library('AfricaSMS', $sms_array);
                    $this->africasms->sendsms();
                }else{
                    $response['message'] = "There was an error processing the request";
                }
            }
        }else{
            $response['message'] = "There was an error, processing the request...";
        }
        $this->return_response( $response );
    }

    function get_reserve_account(){
        $uid = $this->session->userdata('logged_id');
        $u = $this->get_profile( $uid );
        $response = array('status' => 'error');
        $mlogin = $this->monifylogin();
        $mdata = array(
            'token' => $mlogin['responseBody']['accessToken'],
            'url' => 'https://api.monnify.com/api/v2/bank-transfer/reserved-accounts/' . $u->user_code,
            'method' => 'GET'
        );
        $providusResponse = $this->monifycurl( $mdata );
        // update
        if( $providusResponse['requestSuccessful'] && !empty($providusResponse['responseBody']['accounts'])){
            $result = array();
            foreach ( $providusResponse['responseBody']['accounts'] as $k){
                $res['acctName'] = lang('app_name') . ' '.$u->user_code;
                $res['bankName'] = $k['bankName'];
                $res['accountNumber'] = $k['accountNumber'];
                array_push( $result , $res);
            }


            $providus = json_encode( $result );
            $this->site->update('users', array('providus' => $providus) , array('id' => $u->id) );
            $response['status'] = 'success';
            $this->return_response( $response );
        }else{
            //create
            $mdata = array(
                'accountReference' => $u->user_code,
                'accountName'	=> $u->user_code,
                'currencyCode'	=> 'NGN',
                'contractCode'	=> '921138438934',
                'customerEmail' => $u->email,
                'customerName' => $u->name,
                'token' => $mlogin['responseBody']['accessToken'],
                'url' => 'https://api.monnify.com/api/v1/bank-transfer/reserved-accounts',
                'method' => 'POST'
            );
            $providusResponse = $this->monifycurl( $mdata );
            if( $providusResponse['requestSuccessful'] ){
                $actNumber = $providusResponse['responseBody']['accountNumber'];
                $bankName = $providusResponse['responseBody']['bankName'];
                $res = array(
                    'acctName' => lang('app_name')." ".$u->user_code,
                    'bankName' => $bankName,
                    'accountNumber' => $actNumber
                );


                $providus = json_encode( $res );
                $this->site->update('users', array('providus' => $providus) , array('id' => $u->id) );
                $response['status'] = 'success';
                $this->return_response( $response );
            }else{
                $message = 'Error: ';
                $message .= json_encode( $providusResponse );
                $this->load->library('email');
                $this->email->clear(TRUE);
                $this->email->set_newline("\r\n");
                $this->email->from( lang('app_email'), lang('site_name'));
                $this->email->to("567servicesgroup@gmail.com");
                $this->email->subject( 'There was an error while creating Account number');
                $this->email->message($message);
                $this->email->send();
                $response['status'] = 'error';
                $response['message'] = 'error in creating your reserve account number.';
                $this->return_response( $response );
            }
        }



    }

    private function monifylogin(){
        $curl = curl_init();
        $string = MONIFY_API . ':' . MONIFY_SECRET;
        $token = base64_encode( $string );
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.monnify.com/api/v1/auth/login",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_POST => 1,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_HTTPHEADER => array(
                "Content-Type: application/json",
                "Authorization: Basic " . $token,
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $response = json_decode( $response , true);
            return $response;
        }
    }

    private function monifycurl( $data ){
        $curl = curl_init();
        $token = $data['token'];
        $url = $data['url'];
        $method = $data['method'];
        unset($data['url']);
        unset($data['token']);
        $encdata = json_encode( $data );
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_POST => 1,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_POSTFIELDS => $encdata,
            CURLOPT_HTTPHEADER => array(
                "Content-Type: application/json",
                "Authorization: Bearer " . $token,
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $response = json_decode( $response , true);
            return $response;
        }
    }

    /* General FUnction
    * Help us to return the response
    * */
    function return_response( $array = array()){
        header('Content-type: text/json');
        header('Content-type: application/json');
        echo json_encode( $array );
        exit;
    }
}





