<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends CI_Controller {

    public function __construct(){
        parent::__construct();

        if( !$this->session->userdata('logged_in') || ($this->session->userdata('is_admin') != '1') ){
            redirect( base_url() );
        }
    }

	public function index(){
        $page_data['page'] = 'home';
        $page_data['title'] = 'Welcome to admin panel';
        $page_data['products'] = $this->site->get_result('products');
        $page_data['user'] = $this->get_profile( $this->session->userdata('logged_id'));
        $query = "SELECT t.*, u.phone,u.name FROM transactions t LEFT JOIN users u ON(u.id = t.user_id) ORDER BY id DESC LIMIT 20";
        // System money with status of 'success'
        $today_sales = $this->site->run_sql("SELECT SUM(amount) amt, COUNT(*) number_of_times FROM transactions WHERE DATE(date_initiated) = CURDATE() AND (status = 'success')")->result_array();
        $page_data['today'] = array_sum(array_column($today_sales, 'amt'));
        $page_data['today_count'] = array_sum(array_column($today_sales, 'number_of_times'));

        // Deposited with status of 'approved'
        $today_sales = $this->site->run_sql("SELECT SUM(amount) amt, COUNT(*) number_of_times FROM transactions WHERE DATE(date_initiated) = CURDATE() AND (status = 'approved')")->result_array();
        $page_data['today_deposited'] = array_sum(array_column($today_sales, 'amt'));
        $page_data['today_deposited_count'] = array_sum(array_column($today_sales, 'number_of_times'));


        $first_day = date('Y-m-d', strtotime('last monday'));
        $last_day = date('Y-m-d', strtotime('next sunday'));
        $this_week_sales = $this->site->run_sql("SELECT SUM(amount) amt,COUNT(*) number_of_times FROM transactions WHERE 
        (DATE(date_initiated) >= '{$first_day}' AND DATE(date_initiated) <= '{$last_day}') 
        AND (status = 'success') ")->result_array();
        $page_data['week'] = array_sum(array_column($this_week_sales, 'amt'));
        $page_data['week_count'] = array_sum(array_column($this_week_sales, 'number_of_times'));


        $page_data['users_money'] = $this->site->run_sql("SELECT SUM(wallet) amt FROM users")->row()->amt;
        $page_data['referral_money'] = $this->site->run_sql("SELECT SUM(referral_bonus) amt FROM users")->row()->amt;

        $page_data['successful_transaction'] = $this->site->run_sql("SELECT SUM(amount) amt FROM transactions WHERE status = 'success'")->row()->amt;

        // Get CLukkonnect Balance

        $content = file_get_contents("https://www.nellobytesystems.com/APIWalletBalanceV1.asp?UserID=".CK_USER_ID."&APIKey=".CK_KEY);
//        $content_decode = json_encode( $content);
        $aa = explode(':', $content);
        $page_data['ck_balance'] = preg_replace('/\D/', '', substr($aa[4], 0, -4));

        $today_sales = $this->site->run_sql("SELECT SUM(amount) amt, COUNT(*) number_of_times FROM transactions WHERE DATE(date_initiated) = CURDATE() AND (status = 'success' OR status = 'approved')")->result_array();
        $page_data['today'] = array_sum(array_column($today_sales, 'amt'));
        $page_data['today_count'] = array_sum(array_column($today_sales, 'number_of_times'));

        $first_day = date('Y-m-d', strtotime('last monday'));
        $last_day = date('Y-m-d', strtotime('next sunday'));

        $this_week_sales = $this->site->run_sql("SELECT SUM(amount) amt,COUNT(*) number_of_times FROM transactions WHERE 
        (DATE(date_initiated) >= '{$first_day}' AND DATE(date_initiated) <= '{$last_day}') 
        AND (status = 'success' OR status = 'approved') ")->result_array();
        $page_data['week'] = array_sum(array_column($this_week_sales, 'amt'));
        $page_data['week_count'] = array_sum(array_column($this_week_sales, 'number_of_times'));

        $this_month = date('m', strtotime('this month'));
        $month = $this->site->run_sql("SELECT SUM(amount) amt, count(*) number_of_times FROM transactions WHERE 
        (MONTH(date_initiated) = '{$this_month}') 
        AND (status = 'success' OR status = 'approved' ) ")->result_array();
        $page_data['month'] = array_sum(array_column($month, 'amt'));
        $page_data['month_count'] = array_sum(array_column($month, 'number_of_times'));


        $this_year = date('Y', strtotime('this year'));
        $year = $this->site->run_sql("SELECT SUM(amount) amt, COUNT(*) number_of_times FROM transactions WHERE 
        (YEAR(date_initiated) >= '{$this_year}') 
        AND (status = 'success' OR status = 'approved' )")->result_array();
        $page_data['year'] = array_sum(array_column($year, 'amt'));
        $page_data['year_count'] = array_sum(array_column($year, 'number_of_times'));


        $page_data['users_count'] = $this->site->run_sql("SELECT * FROM users")->num_rows();

        $page_data['transactions'] = $this->site->run_sql( $query )->result();
		$this->load->view('app/admin/dashboard', $page_data);
	}

    /*
     * Services
     * */

    public function services(){
        $page_data['page'] = 'services';
        $page_data['title'] = "Manage Service & Products";
        $page_data['user'] = $this->get_profile( $this->session->userdata('logged_id'));
        $page_data['products'] = $this->site->get_result('products', 'id, title', 'user_end = 1');
        $page_data['services'] = $this->site->run_sql('SELECT s.*, p.title category, p.slug FROM services s LEFT JOIN products p ON (p.id = s.product_id)')->result();

        $this->form_validation->set_rules('title', 'Service Name','trim|required|xss_clean');
        if( $this->form_validation->run() == FALSE ){
            $this->session->set_flashdata('error_msg', validation_errors());
            $this->load->view('app/admin/services', $page_data);
            return;
        }else{
            $slug = urlify( $this->input->post('title') );
            $array = array(
                'title' => $this->input->post('title'),
                'product_id' => $this->input->post('product_id'),
                'message'  => $this->input->post('message'),
                'check_balance'  => $this->input->post('check_balance'),
                'seo'      => $this->input->post('seo'),
                'discount'      => ($this->input->post('discount') == 1) ? 100 : $this->input->post('discount'),
                'discount_type'      => $this->input->post('discount_type'),
                'availability' => $this->input->post('availability'),
                'network_name' => $this->input->post('network_name')
            );

            if( $_FILES['image_icon'] ) {
                $upload_array = array(
                    'folder' => CLOUDINARY_IMG_URL,
                    'filepath' => $_FILES['image_icon']['tmp_name'],
                    'eager' => array("width" => 220, "height" => 220, "crop" => "fill_pad", 'gravity' => 'auto', 'background' => 'auto')
                );
                $this->cloudinarylib->upload_image($upload_array);
                $return = $this->cloudinarylib->get_result('filename');

                if($return){
                    $array['image'] = $return;
                }else{
                    $this->session->set_flashdata('error_msg','There was an error with that image');
                    $this->load->view('app/users/wallet', $page_data);
                    return;
                }
            }

            $array['slug'] = $this->site->check_slug( $slug );
            $sid = $this->site->insert_data('services', $array);
            if( is_numeric( $sid ) ){
                // Does it has plans
                $plan_name = $this->input->post('plan_name');
                if( isset( $plan_name) &&  !empty( $plan_name )){
                    $plans_array = $res = array();
                    $name = $this->input->post('plan_name');
                    $value = $this->input->post('plan_value');
                    $variation = $this->input->post('plan_variation');
                    $ref_id = $this->input->post('ref_id');
                    $count_check = count($this->input->post('plan_name'));
                    for ($i = 0; $i < $count_check; $i++) {
                        $res['sid'] = $sid;
                        $res['name'] = trim($name[$i]);
                        $res['amount'] = trim( $value[$i]);
                        $res['variation'] = trim($variation[$i]);
                        $res['ref_id'] = trim($ref_id[$i]);
                        array_push( $plans_array, $res );
                    }
                    // insert batch
                    if( !$this->site->insert_batch('plans', $plans_array)){
                        $this->session->set_flashdata('error_msg', 'There was an error adding the plan');
                    }
                }
                $this->session->set_flashdata('success_msg', 'The services has been added successfully. ');
            }else{
                $this->session->set_flashdata('error_msg', 'There was an error adding the service.');
            }
            $this->load->view('app/admin/services', $page_data);
            return;
        }
    }

    /*
     * Edit Service and plan
     * */
    public function edit_service( ){
        $page_data['page'] = 'services';
        $page_data['title'] = "Manage Service & Products";
        $page_data['products'] = $this->site->get_result('products', 'id, title', 'user_end = 1');
        $this->form_validation->set_rules('title', 'Service Name','trim|required|xss_clean');
        $sid = cleanit( $this->input->post_get('sid', true));
        $page_data['row'] = $this->site->run_sql("SELECT s.*, p.title category, p.slug FROM services s LEFT JOIN products p ON (p.id = s.product_id) WHERE s.id='{$sid}'")->row();
        $page_data['user'] = $this->get_profile( $this->session->userdata('logged_id'));

        if( !$page_data['row'] ){
            $this->session->set_flashdata('error_msg', 'The service does not exist.');
            redirect('admin/');
        }
        if( $this->form_validation->run() == FALSE ){
            $this->session->set_flashdata('error_msg', validation_errors());
            $this->load->view('app/admin/edit_service', $page_data);
            return;
        }else{
            $slug = urlify( $this->input->post('title') );
            $array['slug'] = $this->site->check_slug( $slug );
            $array = array(
                'title' => $this->input->post('title'),
                'product_id' => $this->input->post('product_id'),
                'message'  => $this->input->post('message'),
                'check_balance'  => $this->input->post('check_balance'),
                'seo'      => $this->input->post('seo'),
                'discount'      => ($this->input->post('discount') == 1) ? 100 : $this->input->post('discount'),
                'discount_type'      => $this->input->post('discount_type'),
                'availability' => $this->input->post('availability'),
                'network_name' => $this->input->post('network_name')
            );



            if( $this->site->update('services', $array, array('id' => $sid))){
                // Does it has plans
                if( $this->input->post('plan_name') ){
                    //Delete the plans
//                    $plans_array = $res = array();
                    $plan_id = $this->input->post('plan_id');
                    $name = $this->input->post('plan_name');
                    $value = $this->input->post('plan_value');
                    $variation = $this->input->post('plan_variation');
                    $count_check = count($this->input->post('plan_name'));
                    $ref_id = $this->input->post('ref_id');

//                    var_dump( $_POST ); exit;

                    for ($i = 0; $i < $count_check; $i++) {
                        $res = array();
                        if( !empty( $name[$i]) ) {
                            $res['sid'] = $sid;
                            $res['id'] = $plan_id[$i];
                            $res['name'] = trim($name[$i]);
                            $res['amount'] = trim( $value[$i]);
                            $res['variation'] = trim($variation[$i]);
                            $res['ref_id'] = trim($ref_id[$i]);
                            if ($res['id'] == 'new') {
                                unset( $res['id']);
                                $this->site->insert_data('plans', $res);
                            } else {
                                $id = $res['id'];
//                                var_dump( $res );exit;
                                $this->site->update('plans', $res, array('id' => $id));
                            }
                        }
                        unset( $res);
                    }

                }
                $this->session->set_flashdata('success_msg', 'The services has been updated successfully. ');
                redirect( base_url('admin/edit_service/?sid=' . $_POST['sid'] ));

            }else{
                $this->session->set_flashdata('error_msg', 'There was an error updating the service.');
            }
            $this->load->view('app/admin/services' , $page_data);
            return;
        }
    }

    public function notification(){
        $page_data['page'] = 'notification';
        $page_data['notifications'] = $this->site->get_result('notifications');
        $action = $this->input->get('action', true);
        $page_data['user'] = $this->get_profile( $this->session->userdata('logged_id'));
        $id = $this->input->get('id', true);
        if( isset( $id ) && isset( $action) ){
            if( $action == 'enable' ){
                $this->site->update('notifications', array('status' => 1), array('id' => $id ));
                $this->session->set_flashdata('success_msg', "Notification marked as enabled.");
            }elseif( $action == 'disable' ){
                $this->site->update('notifications', array('status' => 0), array('id' => $id ));
                $this->session->set_flashdata('success_msg', "Notification marked as disabled.");
            }else{
                $this->site->delete('notifications', array('id' => $id));
                $this->session->set_flashdata('success_msg', "Notification has been deleted successfully....");
            }
            redirect('admin/notification/');
        }
        $this->form_validation->set_rules('content', 'Message content can not be empty.','trim|required|xss_clean');
        if( $this->form_validation->run() == FALSE ){
            $this->session->set_flashdata('error_msg', validation_errors());
            $this->load->view('app/admin/notification', $page_data);
        }else{
            $message = $this->input->post('content', true);
            if( $this->site->insert_data('notifications', array('message' => $message, 'date_posted' => get_now(), 'status' => 1))){
                $this->session->set_flashdata('success_msg', "Great! The notification message has been posted...");
            }else{
                $this->session->set_flashdata('error_msg', "There was an eror posting the update...");
            }
            $this->load->view('app/admin/notification', $page_data);
        }

    }

    /*
     * Fund Approval
     * */
    public function funds(){
        $page_data['page'] = 'funds';
        $page_data['title'] = 'Awaiting Approval Funds';
        $page_data['user'] = $this->get_profile( $this->session->userdata('logged_id'));
        $page_data['transactions'] = $this->site->run_sql("SELECT t.*, f.id fid, f.tid, f.bank, f.comment, f.image, u.id uid, u.name FROM transactions t 
        LEFT JOIN funds f ON(f.tid = t.id) 
        LEFT JOIN users u ON(u.id = t.user_id)
        WHERE t.product_id = 6 AND t.status = 'pending' ORDER BY t.id DESC LIMIT 100")->result();
        $this->load->view('app/admin/funds', $page_data);
    }


    /*
     * Upgrade Request Approval
     * Register using this link >>> https://www.clubkonnect.com/register.asp?SponsorID=ADMIN&UplineID=CK10148228
     * */
    public function upgrade_request(){
        $page_data['page'] = 'upgrade';
        $page_data['title'] = 'Upgrade Request Approval';
        $page_data['user'] = $this->get_profile( $this->session->userdata('logged_id'));
        $page_data['requests'] = $this->site->run_sql("SELECT up.*, u.name, u.email, u.phone FROM upgrade up 
        LEFT JOIN users u ON (u.id = up.uid) 
        WHERE up.status = 'pending' OR up.status = 'processing' ORDER BY up.id DESC LIMIT 100")->result();
        $this->load->view('app/admin/upgrade_request', $page_data);
    }


    /*
     * Approve commission
     * */
    public function commission_request(){
        $page_data['page'] = 'commission_request';
        $page_data['title'] = 'Commission Request Approval';
        $page_data['user'] = $this->get_profile( $this->session->userdata('logged_id'));
        $page_data['requests'] = $this->site->run_sql("SELECT t.*, u.name, u.phone, u.account_name, u.account_number, u.bank_name FROM transactions t 
        LEFT JOIN users u ON (u.id = t.user_id) 
        WHERE (t.status = 'pending' AND t.product_id = 13) ORDER BY t.id DESC LIMIT 100")->result();
        $this->load->view('app/admin/commission_request', $page_data);
    }


    /*
     * Airtime to cash approval
     * */
    public function airtime(){
        $page_data['page'] = 'airtime';
        $page_data['title'] = 'Awaiting Approval Funds';
        $page_data['airtime_to_cash_pin'] = $this->site->run_sql("SELECT a.* , t.description FROM airtime_to_cash a LEFT JOIN transactions t ON (t.id = a.tid) 
            WHERE t.status = 'pending' ORDER BY a.id DESC")->result();
        $page_data['user'] = $this->get_profile( $this->session->userdata('logged_id'));
        $this->form_validation->set_rules('action', 'Action','trim|required|xss_clean');
        if( $this->form_validation->run() == FALSE ){
            $this->load->view('app/admin/airtime', $page_data);
            return;
        }else{
            $user_id = $this->input->post('user_id');
            $amount = $this->input->post('amount');
            $tid = $this->input->post('txn_id');
            $action = $this->input->post('action');
            $this->db->trans_start();
            switch ( $action ){
                case 'approve' :
                    $this->site->set_field('users', 'wallet', "wallet+{$amount}", "id={$user_id}");
                    $this->site->update('transactions', array('status' => 'approved'), "( id = '{$tid}')");
                    break;
                case 'decline':
                    $this->site->update('transactions', array('status' => 'declined'), "( id = '{$tid}')");
                    break;
            }
            $this->db->trans_complete();
            if ($this->db->trans_status() === FALSE){
                $this->session->set_flashdata('error_msg', 'There was an error updating the transaction.');
                $this->db->trans_rollback();
            }else{
                $this->db->trans_commit();
                $this->session->set_flashdata('success_msg', 'Transaction has been updated successfully..');
            }
            $this->load->view('app/admin/airtime', $page_data);
            return;
        }


    }

    /*
     * Users
     * */
    public function users(){
        $page_data['page'] = 'users';
        $page_data['title'] = 'Manage User In The System';
        $page_data['users'] = $this->site->get_result('users', '*', array( 'is_admin != ' => 1));
        $page_data['user'] = $this->get_profile( $this->session->userdata('logged_id'));


        $this->load->view('app/admin/users', $page_data);
    }

    // Get a particular user transactions
    public function user(){
        $uid = $this->input->get('uid', true);
        if( $uid ){
            $query = "SELECT * FROM transactions WHERE user_id = {$uid} ORDER BY id DESC ";
            $page_data['transactions'] = $this->site->run_sql( $query )->result();
            $page_data['user'] = $this->site->get_row('users', '*', array('id' => $uid));
            $page_data['downlines'] = $this->site->my_downlines(  $page_data['user']->user_code );
            $page_data['page'] = 'users';
            $page_data['title'] = $page_data['user']->name . ' transaction in the system';

            $this->load->view('app/admin/user', $page_data);
        }else{

            if( $_POST ){

                $uid = $_POST['uid']; unset( $_POST['uid']);
                $name = $_POST['name']; unset( $_POST['name']);
                $data = array();
//                $counter = count($_POST['bankName']);
                foreach ( $_POST as $k => $v ){
//                    if( in_array( $k, array('bankName', 'accountName', 'accountNumber')) ){
//                        $arr = array();
//                        for ( $x = 0; $x < $counter; $x++ ){
//                            $i['bankName'] = $_POST['bankName'][$x];
//                            $i['accountName'] = $_POST['acctName'][$x];
//                            $i['accountNumber'] = $_POST['accountNumber'][$x];
//                            array_push( $arr, $i);
//                        }
//                        unset( $_POST['bankName']);
//                        unset( $_POST['acctName']);
//                        unset( $_POST['accountNumber']);
//
//                        $data['providus'] = json_encode( $arr );
//                    }

                    $data[$k] = cleanit($v);

                }

                $this->site->update('users', $data, array('id' => $uid));

                $this->session->set_flashdata('success_msg', "User updated successfully..");
                redirect(base_url('admin/user/?uid=' . $uid . '&name=' . $name));

            }

            redirect('admin/users/');
        }
    }

    /*
     * Transaction in the system
     * */
    public function transactions()
    {
        $page_data['page'] = 'transactions';
        $page_data['title'] = 'Transactions in the system.';
        $page_data['transactions'] = $this->site->run_sql('SELECT t.*, u.phone,u.name, u.id uid FROM transactions t LEFT JOIN users u ON(u.id = t.user_id) ORDER BY id DESC LIMIT 20')->result();
        $page_data['user'] = $this->get_profile( $this->session->userdata('logged_id'));
        $page_data['products'] = $this->site->get_result('products');
        if ($this->input->post()) {
            // start empty
            $start = $this->input->post('start_date');
            if (empty($start) || !isset($start)) {
                $start = $_POST['start_date'] = date('Y-m-d', strtotime('first day of this year'));
            } else {
                $start = date('Y-m-d', strtotime($start));
            }
            $end = $this->input->post('end_date');
            if (empty($end) || !isset($end)) {
                $end = $_POST['end_date'] = date('Y-m-d', strtotime('last day of this year'));
            } else {
                $end = date('Y-m-d', strtotime($end));
            }

            $query = "SELECT t.*, u.phone, u.name, u.id uid FROM transactions t LEFT JOIN users u ON(u.id = t.user_id) WHERE date_initiated BETWEEN '{$start}' AND '{$end}'";

            if ($this->input->post('transaction_type')) {
                $transaction = $this->input->post('transaction_type');
                $query .= " AND product_id = {$transaction} ORDER BY id DESC";
            }
            $page_data['transactions'] = $this->site->run_sql($query)->result();
        }
        $this->load->view('app/admin/transactions', $page_data);
    }


    /*
     * User setting
     * */
    public function settings(){
        $id = $this->session->userdata('logged_id');
        $page_data['page'] = 'profile';
        $page_data['title'] = "Profile Setting";
        $page_data['user'] = $this->site->run_sql("SELECT * FROM users WHERE id = {$id}")->row();
        $this->load->view('app/admin/settings', $page_data);
    }

    function profile_setting(){

        $action_type = $this->input->post('post_type');
        $uid = $this->session->userdata('logged_id');
        switch ( $action_type ){
            case 'account':
                $this->form_validation->set_rules('name', 'Full name','trim|required|xss_clean|min_length[3]|max_length[50]');
                $this->form_validation->set_rules('account_name', 'Account name','trim|required|xss_clean|max_length[50]');
                $this->form_validation->set_rules('account_type', 'Account type','trim|required|xss_clean');
                $this->form_validation->set_rules('bank_name', 'Bank name','trim|required|xss_clean');
                $this->form_validation->set_rules('account_number', 'Account Number','trim|required|xss_clean');
                if( $this->form_validation->run() == false ){
                    $this->session->set_flashdata('error_msg', validation_errors());
                    redirect($_SERVER['HTTP_REFERER']);
                }else{
                    $password = cleanit($_POST['confirm_password']);
                    if(!$this->user->cur_pass_match($password, $uid, 'users')){
                        $this->session->set_flashdata('error_msg', "Oops! The password does not match your current password.");
                        redirect($_SERVER['HTTP_REFERER']);
                    }
                    $data = array(
                        'name' => cleanit($_POST['name']),
                        'account_name' => cleanit($_POST['account_name']),
                        'account_type' => cleanit($_POST['account_type']),
                        'bank_name' => cleanit($_POST['bank_name']),
                        'bio' => cleanit($_POST['bio']),
                        'company' => cleanit($_POST['company']),
                        'url' => cleanit($_POST['url']),
                        'account_number' => cleanit($_POST['account_number']),
                    );

                    if( $this->site->update('users', $data, "(id = {$uid})")){
                        $this->session->set_flashdata('success_msg', "Profile updated successfully.");
                    }else{
                        $this->session->set_flashdata('error_msg', "There was an error updating your profile.");
                    }
                    redirect($_SERVER['HTTP_REFERER']);
                }
                break;
            case 'password_change':
                $this->form_validation->set_rules('current_password', 'Password','trim|required|xss_clean');
                $this->form_validation->set_rules('new_password', 'New Password','trim|required|xss_clean');
                $this->form_validation->set_rules('confirm_password', 'Confirm Password','trim|required|xss_clean|min_length[6]|max_length[15]|matches[new_password]');

                $password = cleanit($_POST['current_password']);
                if(!$this->user->cur_pass_match($password, $uid, 'users')){
                    $this->session->set_flashdata('error_msg', "Oops! The password does not match your current password. ");
                    redirect($_SERVER['HTTP_REFERER']);
                }
                $new_password = cleanit( $_POST['new_password'] );

                if( $this->user->change_password( $new_password, $uid, 'users')){
                    $this->session->set_flashdata('success_msg', "Password changed successfully.");
                }else{
                    $this->session->set_flashdata('error_msg', "There was an error updating your password.");
                }
                redirect($_SERVER['HTTP_REFERER']);
                break;
        }
    }

    public function resolution(){
        $trans_id = cleanit( $_GET['trans_id']);
        $page_data['user'] = $this->get_profile( $this->session->userdata('logged_id'));
        if( $trans_id ){
            $page_data['row'] = $this->site->run_sql("SELECT t.*, p.title product_name, u.name user_name  FROM transactions t LEFT JOIN products p ON (p.id = t.product_id) 
LEFT JOIN users u ON (u.id = t.user_id) WHERE trans_id = '{$trans_id}'")->row();
            if( !$page_data['row'] ){
                $this->session->set_flashdata('error_msg', "The transaction does not exists");
                redirect('admin');
            }else{
                $page_data['page'] = 'transactions';
                $page_data['title'] = 'Resolution for transaction - ' . $trans_id;
                $this->load->view('app/admin/resolution', $page_data);
            }
        }
    }

    function resolution_process(){
        $action = $this->input->post('action');
        $amount = $this->input->post('amount');
        $trans_id = $this->input->post('trans_id');
        $user_id = $this->input->post('user_id');
        if( $action == 'refund' ){
            $this->site->set_field('users', 'wallet', "wallet+{$amount}", "id={$user_id}");
            $this->site->update('transactions', array('status' => 'refunded'), array('trans_id' => $trans_id));
            $this->session->set_flashdata('success_msg', "The amount has been refunded.");
        }elseif( $action == 'decline' ){
            $this->site->update('users', array('status' => 'declined'), array('trans_id' => $trans_id));
            $this->session->set_flashdata('success_msg', "The transaction has been declined.");
        }elseif( $action == 'success'){
            $this->site->update('transactions', array('status' => 'success'), array('trans_id' => $trans_id));
            $this->session->set_flashdata('success_msg', "The transaction has been marked as success.");
        }elseif( $action == 'fail'){
            $this->site->update('transactions', array('status' => 'fail'), array('trans_id' => $trans_id));
            $this->session->set_flashdata('success_msg', "The transaction has been marked as failed.");
        }elseif( $action == 'approved' ){
            $this->site->set_field('users', 'wallet', "wallet+{$amount}", "id={$user_id}");
            $this->site->update('transactions', array('status' => 'approved'), array('trans_id' => $trans_id));
            $this->session->set_flashdata('success_msg', "The amount has been refunded.");
        }elseif( $action == "retract" ){
            $this->site->set_field('users', 'wallet', "wallet-{$amount}", "id={$user_id}");
            $this->site->update('transactions', array('status' => 'fail'), array('trans_id' => $trans_id));
            $this->session->set_flashdata('success_msg', "The transaction has been retracted.");
        }
        redirect( 'admin/resolution/?trans_id=' .$trans_id);
    }


    /*
     * Site setting process
    */
    public function site_settings(){
        $page_data['page'] = 'profile';
        $page_data['title'] = "SIte Administration Setting";
        $page_data['airtimes'] = $this->site->get_result('airtime_settings');
        $page_data['notifications'] = $this->site->get_result('notifications');
        $this->load->view('app/admin/site_settings', $page_data);
    }

    public function emailsms(){
        $id = $this->session->userdata('logged_id');
        $page_data['page'] = 'emailsms';
        $page_data['title'] = "Scrap Email & SMS";
        $page_data['user'] = $this->site->run_sql("SELECT * FROM users WHERE id = {$id}")->row();
        $page_data['users'] = $this->site->get_result('users', '*', array( 'is_admin != ' => 1));
        $this->load->view('app/admin/emailsms', $page_data);
    }

    function site_settings_process(){
        $action_type = $this->input->post('post_type');
        switch ( $action_type ){
            case 'airtime_to_cash' :
                $airtime_array = array(
                    'network' => $this->input->post('network'),
                    'phone_no' => $this->input->post('phone_no'),
                    'percentage' => $this->input->post('percentage'),
                    'active' => $this->input->post('active')
                );
                $row = $this->site->get_row('airtime_settings', 'id', array('network' => $airtime_array['network']));
                if( $row ){
                    try {
                        $this->site->update('airtime_settings', $airtime_array, array('id' => $row->id));
                        $this->session->set_flashdata('success_msg', 'The network has been updated successfully.');
                    } catch (Exception $e) {
                        $this->session->set_flashdata('error_msg', 'There was an error updating ' . $e->getMessage());
                    }
                }else{
                    try {
                        $this->site->insert_data('airtime_settings', $airtime_array);
                        $this->session->set_flashdata('success_msg', 'The network setting has been added successfully.');
                    } catch (Exception $e) {
                        $this->session->set_flashdata('error_msg', 'There was an error inserting the network setting ' . $e->getMessage());
                    }
                }
                redirect( $_SERVER['HTTP_REFERER']);
                break;
            case 'notification':
                if( $this->input->post('update_notification')) {
                    $id = $this->input->post('id');
                    $message = $this->input->post('message');
                    try {
                        $this->session->set_flashdata('success_msg', 'Notification message updated successfully.');
                        $this->site->update('notifications', array('message' => $message ), array('id' => $id));
                    } catch (Exception $e) {
                        $this->session->set_flashdata('error_msg', 'There was an error updating the notification message.' . $e->getMessage());
                    }
                }else{
                    $data = array(
                        'receiver' => $this->input->post('receiver'),
                        'message'  => $this->input->post('message')
                    );
                    try {
                        $this->site->insert_data('notifications', $data);
                        $this->session->set_flashdata('success_msg', 'Notification message saved.');
                    } catch (Exception $e) {
                        $this->session->set_flashdata('error_msg', 'There was an error saving the notification message.');
                    }
                }
                redirect( $_SERVER['HTTP_REFERER']);
                break;
            default:
                break;

        }
    }


    function tocashprocess(){
        $action = $this->input->post('action');
        $txid  = $this->input->post('txn_id');
        $user_id = $this->input->post('user_id');
        $amount = $this->input->post('amount');

        if( $action == 'approve' ){
            $txn_update = array('status' => 'success');
            $airtime_update = array('status' => 'success');
            $this->db->trans_start();
            if( $_POST['transaction_type'] == 'wallet' ){
                $this->site->set_field('users', 'wallet', "wallet+{$amount}", "id={$user_id}");
            }
            $this->site->update('airtime_to_cash', $airtime_update, "( tid = '{$txid}')");
            $this->site->update('transactions', $txn_update, "( id = '{$txid}')");

            $this->db->trans_complete();
            if ($this->db->trans_status() === FALSE){
                $this->session->set_flashdata('error_msg', 'There was an error processing that request.');
                $this->db->trans_rollback();
            }else{
                $this->db->trans_commit();
                $this->session->set_flashdata('success_msg', 'Request successful.');
            }
        }else{
            $this->site->update('transactions', array('status' => 'decline'), "( id = '{$txid}')");
            $this->session->set_flashdata('success_msg', 'Transaction has been declined.');
        }
        redirect( $_SERVER['HTTP_REFERER']);
    }

    public function confirm_payment(){
        $tid = $this->input->get('tid', true);
        if( $tid ){
            $page_data['row'] = $this->site->run_sql("SELECT t.amount, t.id,t.user_id, s.bank_name, s.amount_paid, s.deposit_type, s.remark, s.date_paid, s.pop FROM transactions t LEFT JOIN transaction_status s ON (s.tid = t.trans_id) 
WHERE t.trans_id = {$tid}")->row();
            $page_data['users'] = $this->site->get_result('users');
            $page_data['title'] = "Confirm Payment";
            $page_data['page'] = 'Confirm Payment';
            $this->load->view('app/admin/confirm_payment', $page_data);
        }
    }

    function user_action(){
        $action = $this->uri->segment(3);
        $user_id = $this->uri->segment(4);
        if( !$action || ! $user_id ){
            $this->session->set_flashdata('error_msg', 'Something is wrong somewhere...');
            redirect( $_SERVER['HTTP_REFERER']);
        }
        if( $action == 'delete' ){
            $this->site->delete('transactions', array('user_id' => $user_id));
            $this->site->delete('users', array('id' => $user_id));
        }else if($action == 'active'){
            $this->site->update('users', array('status' => $action, 'everify' => 1), array('id' => $user_id));
        }else{
            $this->site->update('users', array('status' => $action), array('id' => $user_id));
        }
        $this->session->set_flashdata('success_msg', "Action successful");
        redirect('admin/users/');
    }

    public function statistics(){
        $page_data['page'] = 'statistics';
        $page_data['users_money'] = $this->site->run_sql("SELECT SUM(wallet) amt FROM users")->row()->amt;
        $this->load->view('app/admin/statistics', $page_data);
    }
    /*
     * Plans
     * */

    public function plans(){
        if( $this->input->post()){
            $plans = $this->input->post('plans', true);
            $sid = $this->input->post('service');
            $explode_plans = explode(',', $plans );
            $plans_array = array();
            $count = count( $explode_plans );
            // explode plans = array(1GB - 4000, 2GB - 5000 ...)
            // Lets get the discount for this service
//            $discount = $this->site->run_sql("SELECT discount FROM services WHERE id = {$sid}")->row()->discount;
            for ($x = 0; $x < $count; $x++){
                $explode = explode( '-',$explode_plans[$x] );
                if( $explode ) { // double check that admin didn't add extra comma (,)
                    $res['sid'] = $sid;
                    $res['name'] = trim(strtoupper($explode[0]));
                    $res['amount'] = null;
                    if( isset( $explode[1]) ) {
                        $res['amount'] = trim($explode[1]);
                        // leave to when it will be processed
//                        if( $discount > 0 ) {
//                            $res['amount'] = trim((int)$explode[1]) - ( $discount / 100 * trim((int)$explode[1]) );
//                        }
                    }
                    array_push( $plans_array, $res );
                }
            }
            // insert batch
            if( $this->site->insert_batch('plans', $plans_array)){
                $this->session->set_flashdata('success_msg', 'The plan has been added to the service');
            }else{
                $this->session->set_flashdata('error_msg', 'The plan has been added to the service');
            }

            redirect( $_SERVER['HTTP_REFERER']);

        }else{
            $query = "SELECT p.*,s.title service_name, s.discount_type FROM plans p LEFT JOIN services s ON(s.id = p.sid) GROUP BY p.sid";
            $id = $this->input->get('id', true);
            $id = cleanit($id);
            $page_data['id_set'] = false;
            if( $id ) {
                $query = "SELECT p.*,s.title service_name, s.discount_type FROM plans p LEFT JOIN services s ON(s.id = p.sid) WHERE p.sid = {$id}";
                $page_data['id_set'] = true;
            }
            $page_data['page'] = 'plans';
//            $page_data['services'] = $this->site->get_result('services', 'id, title, discount_type');
            $page_data['services'] = $this->site->run_sql('SELECT s.id,s.title,s.discount_type, p.title product_name FROM services s LEFT JOIN products p ON (p.id = s.product_id)')->result();
            $page_data['plans'] = $this->site->run_sql($query)->result();
//            var_dump( $page_data['plans']);
            $this->load->view('app/admin/plans', $page_data);
        }
    }


    /*
     * Update user wallet
     * */
    function update_wallet(){
        $wallet = $this->input->post('wallet');
        $id = $this->input->post('user_id');
        $name = $this->input->post('user');
        $post_type = $this->input->post('post_type');


        if( $post_type == 'referral' ){
            $array = array(
                'referral_bonus' => $wallet
            );
        }else{
            $array = array(
                'wallet' => $wallet
            );
        }

        if( $this->site->update('users', $array, array('id' => $id)) ){
            $this->session->set_flashdata('success_msg', "The user (" . ucwords($name) . ") wallet has been updated successfully.");
        }else{
            $this->session->set_flashdata('error_msg', "There was an an error updating the user wallet");
        }
        redirect('admin/users/');
    }

    // Airtime
    public function buy_airtime(){
        $id = $this->session->userdata('logged_id');
        $page_data['page'] = 'airtime';
        $page_data['title'] = 'Buy Mtn, Glo, 9mobile, Airtel Airtime';
        $page_data['user'] = $this->get_profile($id);
        $page_data['networks'] = $this->site->run_sql("SELECT p.slug, s.id, s.title, network_name, discount, image FROM products p LEFT JOIN services s ON (p.id = s.product_id) WHERE p.title ='airtime' ")->result();
//        $page_data['transactions'] = $this->site->run_sql("SELECT id, trans_id, amount, description, date_initiated,payment_method, product_id, status FROM transactions WHERE product_id = 2 AND user_id = {$id} ORDER BY id DESC LIMIT 10")->result();
        $this->load->view('app/users/airtime', $page_data);
    }


    // Data
    public function buy_data(){
        $id = $this->session->userdata('logged_id');
        $page_data['page'] = 'data';
        $page_data['title'] = 'Buy Mtn, Glo, 9mobile, Airtel Data Subscription, works for all Smartphones and devices...';
        $page_data['user'] = $this->get_profile($id);
        $membership_type = $page_data['user']->membership_type;
        $page_data['networks'] = $this->site->run_sql("SELECT p.slug, s.* FROM products p LEFT JOIN services s ON (p.id = s.product_id) WHERE 
        p.title ='data' AND s.discount_type = '{$membership_type}' ")->result();
        $this->load->view('app/users/data', $page_data);
    }
    function get_profile($id){
        return $this->site->run_sql("SELECT phone, email, name, user_code, wallet, account_type , membership_type, is_admin FROM users where id = {$id}")->row();
    }
}
